/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Rational;
import java.nio.ByteBuffer;

public final class MarshalQueryablePrimitive<T>
implements MarshalQueryable<T> {
    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> typeReference, int n) {
        return new MarshalerPrimitive(typeReference, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isTypeMappingSupported(TypeReference<T> typeReference, int n) {
        if (!(typeReference.getType() instanceof Class)) return false;
        Class clazz = (Class)typeReference.getType();
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            if (n == 0) return true;
            return false;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (n == 1) return true;
            return false;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            if (n == 2) return true;
            return false;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (n == 3) return true;
            return false;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (n == 4) return true;
            return false;
        }
        if (clazz != Rational.class) return false;
        if (n != 5) return false;
        return true;
    }

    private class MarshalerPrimitive
    extends Marshaler<T> {
        private final Class<T> mClass;

        protected MarshalerPrimitive(TypeReference<T> typeReference, int n) {
            super(MarshalQueryablePrimitive.this, typeReference, n);
            this.mClass = MarshalHelpers.wrapClassIfPrimitive(typeReference.getRawType());
        }

        private void marshalPrimitive(byte by, ByteBuffer byteBuffer) {
            byteBuffer.put(by);
        }

        private void marshalPrimitive(double d, ByteBuffer byteBuffer) {
            byteBuffer.putDouble(d);
        }

        private void marshalPrimitive(float f, ByteBuffer byteBuffer) {
            byteBuffer.putFloat(f);
        }

        private void marshalPrimitive(int n, ByteBuffer byteBuffer) {
            byteBuffer.putInt(n);
        }

        private void marshalPrimitive(long l, ByteBuffer byteBuffer) {
            byteBuffer.putLong(l);
        }

        private void marshalPrimitive(Rational rational, ByteBuffer byteBuffer) {
            byteBuffer.putInt(rational.getNumerator());
            byteBuffer.putInt(rational.getDenominator());
        }

        private Object unmarshalObject(ByteBuffer byteBuffer) {
            switch (this.mNativeType) {
                default: {
                    throw new UnsupportedOperationException("Can't unmarshal native type " + this.mNativeType);
                }
                case 1: {
                    return byteBuffer.getInt();
                }
                case 2: {
                    return Float.valueOf(byteBuffer.getFloat());
                }
                case 3: {
                    return byteBuffer.getLong();
                }
                case 5: {
                    return new Rational(byteBuffer.getInt(), byteBuffer.getInt());
                }
                case 4: {
                    return byteBuffer.getDouble();
                }
                case 0: 
            }
            return byteBuffer.get();
        }

        @Override
        public int calculateMarshalSize(T t) {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        @Override
        public int getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        @Override
        public void marshal(T t, ByteBuffer byteBuffer) {
            if (t instanceof Integer) {
                MarshalHelpers.checkNativeTypeEquals(1, this.mNativeType);
                this.marshalPrimitive((Integer)t, byteBuffer);
                return;
            }
            if (t instanceof Float) {
                MarshalHelpers.checkNativeTypeEquals(2, this.mNativeType);
                this.marshalPrimitive(((Float)t).floatValue(), byteBuffer);
                return;
            }
            if (t instanceof Long) {
                MarshalHelpers.checkNativeTypeEquals(3, this.mNativeType);
                this.marshalPrimitive((Long)t, byteBuffer);
                return;
            }
            if (t instanceof Rational) {
                MarshalHelpers.checkNativeTypeEquals(5, this.mNativeType);
                this.marshalPrimitive((Rational)t, byteBuffer);
                return;
            }
            if (t instanceof Double) {
                MarshalHelpers.checkNativeTypeEquals(4, this.mNativeType);
                this.marshalPrimitive((Double)t, byteBuffer);
                return;
            }
            if (t instanceof Byte) {
                MarshalHelpers.checkNativeTypeEquals(0, this.mNativeType);
                this.marshalPrimitive((Byte)t, byteBuffer);
                return;
            }
            throw new UnsupportedOperationException("Can't marshal managed type " + this.mTypeReference);
        }

        @Override
        public T unmarshal(ByteBuffer byteBuffer) {
            return this.mClass.cast(this.unmarshalObject(byteBuffer));
        }
    }
}

