/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableStreamConfiguration
implements MarshalQueryable<StreamConfiguration> {
    private static final int SIZE = 16;

    @Override
    public Marshaler<StreamConfiguration> createMarshaler(TypeReference<StreamConfiguration> typeReference, int n) {
        return new MarshalerStreamConfiguration(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<StreamConfiguration> typeReference, int n) {
        return n == 1 && typeReference.getType().equals(StreamConfiguration.class);
    }

    private class MarshalerStreamConfiguration
    extends Marshaler<StreamConfiguration> {
        protected MarshalerStreamConfiguration(TypeReference<StreamConfiguration> typeReference, int n) {
            super(MarshalQueryableStreamConfiguration.this, typeReference, n);
        }

        @Override
        public int getNativeSize() {
            return 16;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void marshal(StreamConfiguration streamConfiguration, ByteBuffer byteBuffer) {
            byteBuffer.putInt(streamConfiguration.getFormat());
            byteBuffer.putInt(streamConfiguration.getWidth());
            byteBuffer.putInt(streamConfiguration.getHeight());
            int n = streamConfiguration.isInput() ? 1 : 0;
            byteBuffer.putInt(n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public StreamConfiguration unmarshal(ByteBuffer byteBuffer) {
            boolean bl;
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            if (byteBuffer.getInt() != 0) {
                bl = true;
                return new StreamConfiguration(n, n2, n3, bl);
            }
            bl = false;
            return new StreamConfiguration(n, n2, n3, bl);
        }
    }
}

