/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class MarshalQueryableString
implements MarshalQueryable<String> {
    private static final byte NUL;
    private static final String TAG;
    private static final Charset UTF8_CHARSET;
    private static final boolean VERBOSE;

    static {
        TAG = MarshalQueryableString.class.getSimpleName();
        VERBOSE = Log.isLoggable(TAG, 2);
        UTF8_CHARSET = Charset.forName("UTF-8");
    }

    @Override
    public Marshaler<String> createMarshaler(TypeReference<String> typeReference, int n) {
        return new MarshalerString(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<String> typeReference, int n) {
        return n == 0 && String.class.equals((Object)typeReference.getType());
    }

    private class MarshalerString
    extends Marshaler<String> {
        protected MarshalerString(TypeReference<String> typeReference, int n) {
            super(MarshalQueryableString.this, typeReference, n);
        }

        @Override
        public int calculateMarshalSize(String string2) {
            return 1 + string2.getBytes(UTF8_CHARSET).length;
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public void marshal(String string2, ByteBuffer byteBuffer) {
            byteBuffer.put(string2.getBytes(UTF8_CHARSET));
            byteBuffer.put((byte)0);
        }

        @Override
        public String unmarshal(ByteBuffer byteBuffer) {
            byteBuffer.mark();
            int n = 0;
            while (true) {
                block6: {
                    boolean bl;
                    block5: {
                        boolean bl2 = byteBuffer.hasRemaining();
                        bl = false;
                        if (!bl2) break block5;
                        if (byteBuffer.get() != 0) break block6;
                        bl = true;
                    }
                    if (VERBOSE) {
                        Log.v(TAG, "unmarshal - scanned " + n + " characters; found null? " + bl);
                    }
                    if (bl) break;
                    throw new UnsupportedOperationException("Strings must be null-terminated");
                }
                ++n;
            }
            byteBuffer.reset();
            byte[] byArray = new byte[n + 1];
            byteBuffer.get(byArray, 0, n + 1);
            return new String(byArray, 0, n, UTF8_CHARSET);
        }
    }
}

