/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.graphics.Point;
import android.graphics.Rect;

public final class Face {
    public static final int ID_UNSUPPORTED = -1;
    public static final int SCORE_MAX = 100;
    public static final int SCORE_MIN = 1;
    private final Rect mBounds;
    private final int mId;
    private final Point mLeftEye;
    private final Point mMouth;
    private final Point mRightEye;
    private final int mScore;

    public Face(Rect rect, int n) {
        this(rect, n, -1, null, null, null);
    }

    public Face(Rect rect, int n, int n2, Point point, Point point2, Point point3) {
        Face.checkNotNull("bounds", rect);
        if (n < 1 || n > 100) {
            throw new IllegalArgumentException("Confidence out of range");
        }
        if (n2 < 0 && n2 != -1) {
            throw new IllegalArgumentException("Id out of range");
        }
        if (n2 == -1) {
            Face.checkNull("leftEyePosition", point);
            Face.checkNull("rightEyePosition", point2);
            Face.checkNull("mouthPosition", point3);
        }
        this.mBounds = rect;
        this.mScore = n;
        this.mId = n2;
        this.mLeftEye = point;
        this.mRightEye = point2;
        this.mMouth = point3;
    }

    private static void checkNotNull(String string2, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(string2 + " was required, but it was null");
        }
    }

    private static void checkNull(String string2, Object object) {
        if (object != null) {
            throw new IllegalArgumentException(string2 + " was required to be null, but it wasn't");
        }
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public int getId() {
        return this.mId;
    }

    public Point getLeftEyePosition() {
        return this.mLeftEye;
    }

    public Point getMouthPosition() {
        return this.mMouth;
    }

    public Point getRightEyePosition() {
        return this.mRightEye;
    }

    public int getScore() {
        return this.mScore;
    }

    public String toString() {
        Object[] objectArray = new Object[]{this.mBounds, this.mScore, this.mId, this.mLeftEye, this.mRightEye, this.mMouth};
        return String.format("{ bounds: %s, score: %s, id: %d, leftEyePosition: %s, rightEyePosition: %s, mouthPosition: %s }", objectArray);
    }
}

