/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.RemoteException;
import android.util.Log;

public abstract class HdmiClient {
    private static final String TAG = "HdmiClient";
    protected final IHdmiControlService mService;

    public HdmiClient(IHdmiControlService iHdmiControlService) {
        this.mService = iHdmiControlService;
    }

    private static IHdmiVendorCommandListener getListenerWrapper(final HdmiControlManager.VendorCommandListener vendorCommandListener) {
        return new IHdmiVendorCommandListener.Stub(){

            @Override
            public void onReceived(int n, byte[] byArray, boolean bl) {
                vendorCommandListener.onReceived(n, byArray, bl);
            }
        };
    }

    public void addVendorCommandListener(HdmiControlManager.VendorCommandListener vendorCommandListener) {
        if (vendorCommandListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        try {
            this.mService.addVendorCommandListener(HdmiClient.getListenerWrapper(vendorCommandListener), this.getDeviceType());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to add vendor command listener: ", remoteException);
            return;
        }
    }

    public HdmiDeviceInfo getActiveSource() {
        try {
            HdmiDeviceInfo hdmiDeviceInfo = this.mService.getActiveSource();
            return hdmiDeviceInfo;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getActiveSource threw exception ", remoteException);
            return null;
        }
    }

    protected abstract int getDeviceType();

    public void sendKeyEvent(int n, boolean bl) {
        try {
            this.mService.sendKeyEvent(this.getDeviceType(), n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "sendKeyEvent threw exception ", remoteException);
            return;
        }
    }

    public void sendVendorCommand(int n, byte[] byArray, boolean bl) {
        try {
            this.mService.sendVendorCommand(this.getDeviceType(), n, byArray, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "failed to send vendor command: ", remoteException);
            return;
        }
    }
}

