/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.os.Parcel;
import android.os.Parcelable;

public final class HdmiPortInfo
implements Parcelable {
    public static final Parcelable.Creator<HdmiPortInfo> CREATOR = new Parcelable.Creator<HdmiPortInfo>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public HdmiPortInfo createFromParcel(Parcel parcel) {
            boolean bl;
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl2 = parcel.readInt() == 1;
            boolean bl3 = parcel.readInt() == 1;
            if (parcel.readInt() == 1) {
                bl = true;
                return new HdmiPortInfo(n, n2, n3, bl2, bl3, bl);
            }
            bl = false;
            return new HdmiPortInfo(n, n2, n3, bl2, bl3, bl);
        }

        public HdmiPortInfo[] newArray(int n) {
            return new HdmiPortInfo[n];
        }
    };
    public static final int PORT_INPUT = 0;
    public static final int PORT_OUTPUT = 1;
    private final int mAddress;
    private final boolean mArcSupported;
    private final boolean mCecSupported;
    private final int mId;
    private final boolean mMhlSupported;
    private final int mType;

    public HdmiPortInfo(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        this.mId = n;
        this.mType = n2;
        this.mAddress = n3;
        this.mCecSupported = bl;
        this.mArcSupported = bl3;
        this.mMhlSupported = bl2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getAddress() {
        return this.mAddress;
    }

    public int getId() {
        return this.mId;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isArcSupported() {
        return this.mArcSupported;
    }

    public boolean isCecSupported() {
        return this.mCecSupported;
    }

    public boolean isMhlSupported() {
        return this.mMhlSupported;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("port_id: ").append(this.mId).append(", ");
        StringBuffer stringBuffer2 = stringBuffer.append("address: ");
        Object[] objectArray = new Object[]{this.mAddress};
        stringBuffer2.append(String.format("0x%04x", objectArray)).append(", ");
        stringBuffer.append("cec: ").append(this.mCecSupported).append(", ");
        stringBuffer.append("arc: ").append(this.mArcSupported).append(", ");
        stringBuffer.append("mhl: ").append(this.mMhlSupported);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mAddress);
        int n3 = this.mCecSupported ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mArcSupported ? n2 : 0;
        parcel.writeInt(n4);
        if (!this.mMhlSupported) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }
}

