/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.content.Context;
import android.hardware.location.GeofenceHardwareMonitorEvent;
import android.hardware.location.GeofenceHardwareRequestParcelable;
import android.hardware.location.IGeofenceHardwareCallback;
import android.hardware.location.IGeofenceHardwareMonitorCallback;
import android.location.IFusedGeofenceHardware;
import android.location.IGpsGeofenceHardware;
import android.location.Location;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import java.util.ArrayList;

public final class GeofenceHardwareImpl {
    private static final int ADD_GEOFENCE_CALLBACK = 2;
    private static final int CALLBACK_ADD = 2;
    private static final int CALLBACK_REMOVE = 3;
    private static final boolean DEBUG = false;
    private static final int GEOFENCE_CALLBACK_BINDER_DIED = 6;
    private static final int GEOFENCE_STATUS = 1;
    private static final int GEOFENCE_TRANSITION_CALLBACK = 1;
    private static final int LOCATION_HAS_ACCURACY = 16;
    private static final int LOCATION_HAS_ALTITUDE = 2;
    private static final int LOCATION_HAS_BEARING = 8;
    private static final int LOCATION_HAS_LAT_LONG = 1;
    private static final int LOCATION_HAS_SPEED = 4;
    private static final int LOCATION_INVALID = 0;
    private static final int MONITOR_CALLBACK_BINDER_DIED = 4;
    private static final int PAUSE_GEOFENCE_CALLBACK = 4;
    private static final int REAPER_GEOFENCE_ADDED = 1;
    private static final int REAPER_MONITOR_CALLBACK_ADDED = 2;
    private static final int REAPER_REMOVED = 3;
    private static final int REMOVE_GEOFENCE_CALLBACK = 3;
    private static final int RESOLUTION_LEVEL_COARSE = 2;
    private static final int RESOLUTION_LEVEL_FINE = 3;
    private static final int RESOLUTION_LEVEL_NONE = 1;
    private static final int RESUME_GEOFENCE_CALLBACK = 5;
    private static final String TAG = "GeofenceHardwareImpl";
    private static GeofenceHardwareImpl sInstance;
    private final ArrayList<IGeofenceHardwareMonitorCallback>[] mCallbacks;
    private Handler mCallbacksHandler;
    private final Context mContext;
    private IFusedGeofenceHardware mFusedService;
    private Handler mGeofenceHandler;
    private final SparseArray<IGeofenceHardwareCallback> mGeofences = new SparseArray();
    private IGpsGeofenceHardware mGpsService;
    private Handler mReaperHandler;
    private final ArrayList<Reaper> mReapers;
    private int[] mSupportedMonitorTypes;
    private PowerManager.WakeLock mWakeLock;

    static {
        DEBUG = Log.isLoggable(TAG, 3);
    }

    private GeofenceHardwareImpl(Context context) {
        this.mCallbacks = new ArrayList[2];
        this.mReapers = new ArrayList();
        this.mSupportedMonitorTypes = new int[2];
        this.mGeofenceHandler = new Handler(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void handleMessage(Message message) {
                int n;
                int n2;
                IGeofenceHardwareCallback iGeofenceHardwareCallback;
                block49: {
                    block48: {
                        int n3;
                        block44: {
                            block45: {
                                block46: {
                                    block47: {
                                        switch (message.what) {
                                            default: {
                                                return;
                                            }
                                            case 2: {
                                                int n4 = message.arg1;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                IGeofenceHardwareCallback iGeofenceHardwareCallback2 = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(n4);
                                                // MONITOREXIT : sparseArray
                                                if (iGeofenceHardwareCallback2 != null) {
                                                    try {
                                                        iGeofenceHardwareCallback2.onGeofenceAdd(n4, message.arg2);
                                                    }
                                                    catch (RemoteException remoteException) {
                                                        Log.i(GeofenceHardwareImpl.TAG, "Remote Exception:" + remoteException);
                                                    }
                                                }
                                                GeofenceHardwareImpl.this.releaseWakeLock();
                                                return;
                                            }
                                            case 3: {
                                                n3 = message.arg1;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                IGeofenceHardwareCallback iGeofenceHardwareCallback3 = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(n3);
                                                // MONITOREXIT : sparseArray
                                                if (iGeofenceHardwareCallback3 == null) break block48;
                                                iGeofenceHardwareCallback3.onGeofenceRemove(n3, message.arg2);
                                                break block44;
                                            }
                                            case 4: {
                                                int n5 = message.arg1;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                IGeofenceHardwareCallback iGeofenceHardwareCallback4 = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(n5);
                                                // MONITOREXIT : sparseArray
                                                if (iGeofenceHardwareCallback4 == null) break block45;
                                                iGeofenceHardwareCallback4.onGeofencePause(n5, message.arg2);
                                                break block45;
                                            }
                                            case 5: {
                                                int n6 = message.arg1;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                IGeofenceHardwareCallback iGeofenceHardwareCallback5 = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(n6);
                                                // MONITOREXIT : sparseArray
                                                if (iGeofenceHardwareCallback5 == null) break block46;
                                                iGeofenceHardwareCallback5.onGeofenceResume(n6, message.arg2);
                                                break block46;
                                            }
                                            case 1: {
                                                GeofenceTransition geofenceTransition = (GeofenceTransition)message.obj;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                IGeofenceHardwareCallback iGeofenceHardwareCallback6 = (IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.get(geofenceTransition.mGeofenceId);
                                                if (DEBUG) {
                                                    Log.d(GeofenceHardwareImpl.TAG, "GeofenceTransistionCallback: GPS : GeofenceId: " + geofenceTransition.mGeofenceId + " Transition: " + geofenceTransition.mTransition + " Location: " + geofenceTransition.mLocation + ":" + GeofenceHardwareImpl.this.mGeofences);
                                                }
                                                // MONITOREXIT : sparseArray
                                                if (iGeofenceHardwareCallback6 == null) break block47;
                                                iGeofenceHardwareCallback6.onGeofenceTransition(geofenceTransition.mGeofenceId, geofenceTransition.mTransition, geofenceTransition.mLocation, geofenceTransition.mTimestamp, geofenceTransition.mMonitoringType);
                                                break block47;
                                            }
                                            case 6: {
                                                iGeofenceHardwareCallback = (IGeofenceHardwareCallback)message.obj;
                                                if (DEBUG) {
                                                    Log.d(GeofenceHardwareImpl.TAG, "Geofence callback reaped:" + iGeofenceHardwareCallback);
                                                }
                                                n2 = message.arg1;
                                                SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                                                // MONITORENTER : sparseArray
                                                n = 0;
                                                break;
                                            }
                                        }
                                        break block49;
                                        catch (RemoteException remoteException) {}
                                    }
                                    GeofenceHardwareImpl.this.releaseWakeLock();
                                    return;
                                    catch (RemoteException remoteException) {}
                                }
                                GeofenceHardwareImpl.this.releaseWakeLock();
                                return;
                                catch (RemoteException remoteException) {}
                            }
                            GeofenceHardwareImpl.this.releaseWakeLock();
                            return;
                            catch (RemoteException remoteException) {}
                        }
                        SparseArray sparseArray = GeofenceHardwareImpl.this.mGeofences;
                        // MONITORENTER : sparseArray
                        GeofenceHardwareImpl.this.mGeofences.remove(n3);
                        // MONITOREXIT : sparseArray
                    }
                    GeofenceHardwareImpl.this.releaseWakeLock();
                    return;
                }
                while (true) {
                    if (n >= GeofenceHardwareImpl.this.mGeofences.size()) {
                        // MONITOREXIT : sparseArray
                        return;
                    }
                    if (((IGeofenceHardwareCallback)GeofenceHardwareImpl.this.mGeofences.valueAt(n)).equals(iGeofenceHardwareCallback)) {
                        int n7 = GeofenceHardwareImpl.this.mGeofences.keyAt(n);
                        GeofenceHardwareImpl.this.removeGeofence(GeofenceHardwareImpl.this.mGeofences.keyAt(n), n2);
                        GeofenceHardwareImpl.this.mGeofences.remove(n7);
                    }
                    ++n;
                }
            }
        };
        this.mCallbacksHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                ArrayList arrayList;
                switch (message.what) {
                    case 1: {
                        GeofenceHardwareMonitorEvent geofenceHardwareMonitorEvent = (GeofenceHardwareMonitorEvent)message.obj;
                        ArrayList arrayList2 = GeofenceHardwareImpl.this.mCallbacks[geofenceHardwareMonitorEvent.getMonitoringType()];
                        if (arrayList2 != null) {
                            if (DEBUG) {
                                Log.d(GeofenceHardwareImpl.TAG, "MonitoringSystemChangeCallback: " + geofenceHardwareMonitorEvent);
                            }
                            for (IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback : arrayList2) {
                                try {
                                    iGeofenceHardwareMonitorCallback.onMonitoringSystemChange(geofenceHardwareMonitorEvent);
                                }
                                catch (RemoteException remoteException) {
                                    Log.d(GeofenceHardwareImpl.TAG, "Error reporting onMonitoringSystemChange.", remoteException);
                                }
                            }
                        }
                        GeofenceHardwareImpl.this.releaseWakeLock();
                        return;
                    }
                    case 2: {
                        int n = message.arg1;
                        IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback = (IGeofenceHardwareMonitorCallback)message.obj;
                        ArrayList<IGeofenceHardwareMonitorCallback> arrayList3 = GeofenceHardwareImpl.this.mCallbacks[n];
                        if (arrayList3 == null) {
                            ((GeofenceHardwareImpl)GeofenceHardwareImpl.this).mCallbacks[n] = arrayList3 = new ArrayList<IGeofenceHardwareMonitorCallback>();
                        }
                        if (arrayList3.contains(iGeofenceHardwareMonitorCallback)) return;
                        arrayList3.add(iGeofenceHardwareMonitorCallback);
                        return;
                    }
                    case 3: {
                        int n = message.arg1;
                        IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback = (IGeofenceHardwareMonitorCallback)message.obj;
                        ArrayList arrayList4 = GeofenceHardwareImpl.this.mCallbacks[n];
                        if (arrayList4 == null) return;
                        arrayList4.remove(iGeofenceHardwareMonitorCallback);
                        return;
                    }
                    default: {
                        return;
                    }
                    case 4: 
                }
                IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback = (IGeofenceHardwareMonitorCallback)message.obj;
                if (DEBUG) {
                    Log.d(GeofenceHardwareImpl.TAG, "Monitor callback reaped:" + iGeofenceHardwareMonitorCallback);
                }
                if ((arrayList = GeofenceHardwareImpl.this.mCallbacks[message.arg1]) == null || !arrayList.contains(iGeofenceHardwareMonitorCallback)) return;
                arrayList.remove(iGeofenceHardwareMonitorCallback);
            }
        };
        this.mReaperHandler = new Handler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        IGeofenceHardwareCallback iGeofenceHardwareCallback = (IGeofenceHardwareCallback)message.obj;
                        int n = message.arg1;
                        Reaper reaper = new Reaper(iGeofenceHardwareCallback, n);
                        if (GeofenceHardwareImpl.this.mReapers.contains(reaper)) return;
                        GeofenceHardwareImpl.this.mReapers.add(reaper);
                        IBinder iBinder = iGeofenceHardwareCallback.asBinder();
                        try {
                            iBinder.linkToDeath(reaper, 0);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            return;
                        }
                    }
                    case 2: {
                        IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback = (IGeofenceHardwareMonitorCallback)message.obj;
                        int n = message.arg1;
                        Reaper reaper = new Reaper(iGeofenceHardwareMonitorCallback, n);
                        if (GeofenceHardwareImpl.this.mReapers.contains(reaper)) return;
                        GeofenceHardwareImpl.this.mReapers.add(reaper);
                        IBinder iBinder = iGeofenceHardwareMonitorCallback.asBinder();
                        try {
                            iBinder.linkToDeath(reaper, 0);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            return;
                        }
                    }
                    case 3: 
                }
                Reaper reaper = (Reaper)message.obj;
                GeofenceHardwareImpl.this.mReapers.remove(reaper);
            }
        };
        this.mContext = context;
        this.setMonitorAvailability(0, 2);
        this.setMonitorAvailability(1, 2);
    }

    private void acquireWakeLock() {
        if (this.mWakeLock == null) {
            this.mWakeLock = ((PowerManager)this.mContext.getSystemService("power")).newWakeLock(1, TAG);
        }
        this.mWakeLock.acquire();
    }

    public static GeofenceHardwareImpl getInstance(Context context) {
        synchronized (GeofenceHardwareImpl.class) {
            if (sInstance == null) {
                sInstance = new GeofenceHardwareImpl(context);
            }
            GeofenceHardwareImpl geofenceHardwareImpl = sInstance;
            return geofenceHardwareImpl;
        }
    }

    private void releaseWakeLock() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private void reportGeofenceOperationStatus(int n, int n2, int n3) {
        this.acquireWakeLock();
        Message message = this.mGeofenceHandler.obtainMessage(n);
        message.arg1 = n2;
        message.arg2 = n3;
        message.sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setMonitorAvailability(int n, int n2) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (nArray) {
            this.mSupportedMonitorTypes[n] = n2;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFusedHardwareAvailability() {
        boolean bl;
        try {
            boolean bl2;
            if (this.mFusedService == null) return;
            bl = bl2 = this.mFusedService.isSupported();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException calling LocationManagerService");
            return;
        }
        if (!bl) return;
        this.setMonitorAvailability(1, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateGpsHardwareAvailability() {
        try {
            boolean bl;
            boolean bl2 = bl = this.mGpsService.isHardwareGeofenceSupported();
            if (!bl2) return;
            this.setMonitorAvailability(0, 0);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Remote Exception calling LocationManagerService");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addCircularFence(int n, GeofenceHardwareRequestParcelable geofenceHardwareRequestParcelable, IGeofenceHardwareCallback iGeofenceHardwareCallback) {
        boolean bl;
        int n2 = geofenceHardwareRequestParcelable.getId();
        if (DEBUG) {
            Object[] objectArray = new Object[]{n, geofenceHardwareRequestParcelable};
            Log.d(TAG, String.format("addCircularFence: monitoringType=%d, %s", objectArray));
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            this.mGeofences.put(n2, iGeofenceHardwareCallback);
        }
        switch (n) {
            default: {
                bl = false;
                break;
            }
            case 0: {
                if (this.mGpsService == null) {
                    return false;
                }
                try {
                    boolean bl2;
                    bl = bl2 = this.mGpsService.addCircularHardwareGeofence(geofenceHardwareRequestParcelable.getId(), geofenceHardwareRequestParcelable.getLatitude(), geofenceHardwareRequestParcelable.getLongitude(), geofenceHardwareRequestParcelable.getRadius(), geofenceHardwareRequestParcelable.getLastTransition(), geofenceHardwareRequestParcelable.getMonitorTransitions(), geofenceHardwareRequestParcelable.getNotificationResponsiveness(), geofenceHardwareRequestParcelable.getUnknownTimer());
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "AddGeofence: Remote Exception calling LocationManagerService");
                    bl = false;
                }
                break;
            }
            case 1: {
                if (this.mFusedService == null) {
                    return false;
                }
                try {
                    this.mFusedService.addGeofences(new GeofenceHardwareRequestParcelable[]{geofenceHardwareRequestParcelable});
                    bl = true;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "AddGeofence: RemoteException calling LocationManagerService");
                    bl = false;
                }
            }
        }
        if (bl) {
            Message message = this.mReaperHandler.obtainMessage(1, iGeofenceHardwareCallback);
            message.arg1 = n;
            this.mReaperHandler.sendMessage(message);
        } else {
            SparseArray<IGeofenceHardwareCallback> sparseArray2 = this.mGeofences;
            synchronized (sparseArray2) {
                this.mGeofences.remove(n2);
            }
        }
        if (DEBUG) {
            Log.d(TAG, "addCircularFence: Result is: " + bl);
        }
        return bl;
    }

    int getAllowedResolutionLevel(int n, int n2) {
        if (this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", n, n2) == 0) {
            return 3;
        }
        if (this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", n, n2) == 0) {
            return 2;
        }
        return 1;
    }

    int getMonitoringResolutionLevel(int n) {
        int n2 = 3;
        switch (n) {
            default: {
                n2 = 1;
            }
            case 0: 
            case 1: 
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int[] getMonitoringTypes() {
        int[] nArray = this.mSupportedMonitorTypes;
        // MONITORENTER : nArray
        boolean bl = this.mSupportedMonitorTypes[0] != 2;
        boolean bl2 = this.mSupportedMonitorTypes[1] != 2;
        // MONITOREXIT : nArray
        if (!bl) {
            if (!bl2) return new int[0];
            return new int[]{1};
        }
        if (!bl2) return new int[]{0};
        return new int[]{0, 1};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStatusOfMonitoringType(int n) {
        int[] nArray = this.mSupportedMonitorTypes;
        synchronized (nArray) {
            if (n >= this.mSupportedMonitorTypes.length) throw new IllegalArgumentException("Unknown monitoring type");
            if (n < 0) throw new IllegalArgumentException("Unknown monitoring type");
            return this.mSupportedMonitorTypes[n];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pauseGeofence(int n, int n2) {
        boolean bl;
        if (DEBUG) {
            Log.d(TAG, "Pause Geofence: GeofenceId: " + n);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(n) == null) {
                throw new IllegalArgumentException("Geofence " + n + " not registered.");
            }
        }
        switch (n2) {
            default: {
                bl = false;
                break;
            }
            case 0: {
                IGpsGeofenceHardware iGpsGeofenceHardware = this.mGpsService;
                bl = false;
                if (iGpsGeofenceHardware == null) return bl;
                try {
                    boolean bl2;
                    bl = bl2 = this.mGpsService.pauseHardwareGeofence(n);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "PauseGeofence: Remote Exception calling LocationManagerService");
                    bl = false;
                }
                break;
            }
            case 1: {
                IFusedGeofenceHardware iFusedGeofenceHardware = this.mFusedService;
                bl = false;
                if (iFusedGeofenceHardware == null) return bl;
                try {
                    this.mFusedService.pauseMonitoringGeofence(n);
                    bl = true;
                    break;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "PauseGeofence: RemoteException calling LocationManagerService");
                    bl = false;
                }
            }
        }
        if (!DEBUG) return bl;
        Log.d(TAG, "pauseGeofence: Result is: " + bl);
        return bl;
    }

    public boolean registerForMonitorStateChangeCallback(int n, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback) {
        Message message = this.mReaperHandler.obtainMessage(2, iGeofenceHardwareMonitorCallback);
        message.arg1 = n;
        this.mReaperHandler.sendMessage(message);
        Message message2 = this.mCallbacksHandler.obtainMessage(2, iGeofenceHardwareMonitorCallback);
        message2.arg1 = n;
        this.mCallbacksHandler.sendMessage(message2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeGeofence(int n, int n2) {
        boolean bl;
        if (DEBUG) {
            Log.d(TAG, "Remove Geofence: GeofenceId: " + n);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(n) == null) {
                throw new IllegalArgumentException("Geofence " + n + " not registered.");
            }
        }
        switch (n2) {
            default: {
                bl = false;
                break;
            }
            case 0: {
                IGpsGeofenceHardware iGpsGeofenceHardware = this.mGpsService;
                boolean bl2 = false;
                if (iGpsGeofenceHardware == null) return bl2;
                try {
                    boolean bl3;
                    bl = bl3 = this.mGpsService.removeHardwareGeofence(n);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "RemoveGeofence: Remote Exception calling LocationManagerService");
                    bl = false;
                }
                break;
            }
            case 1: {
                IFusedGeofenceHardware iFusedGeofenceHardware = this.mFusedService;
                boolean bl2 = false;
                if (iFusedGeofenceHardware == null) return bl2;
                try {
                    this.mFusedService.removeGeofences(new int[]{n});
                    bl = true;
                    break;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "RemoveGeofence: RemoteException calling LocationManagerService");
                    bl = false;
                }
            }
        }
        if (!DEBUG) return bl;
        Log.d(TAG, "removeGeofence: Result is: " + bl);
        return bl;
    }

    public void reportGeofenceAddStatus(int n, int n2) {
        if (DEBUG) {
            Log.d(TAG, "AddCallback| id:" + n + ", status:" + n2);
        }
        this.reportGeofenceOperationStatus(2, n, n2);
    }

    public void reportGeofenceMonitorStatus(int n, int n2, Location location, int n3) {
        this.setMonitorAvailability(n, n2);
        this.acquireWakeLock();
        GeofenceHardwareMonitorEvent geofenceHardwareMonitorEvent = new GeofenceHardwareMonitorEvent(n, n2, n3, location);
        this.mCallbacksHandler.obtainMessage(1, geofenceHardwareMonitorEvent).sendToTarget();
    }

    public void reportGeofencePauseStatus(int n, int n2) {
        if (DEBUG) {
            Log.d(TAG, "PauseCallbac| id:" + n + ", status" + n2);
        }
        this.reportGeofenceOperationStatus(4, n, n2);
    }

    public void reportGeofenceRemoveStatus(int n, int n2) {
        if (DEBUG) {
            Log.d(TAG, "RemoveCallback| id:" + n + ", status:" + n2);
        }
        this.reportGeofenceOperationStatus(3, n, n2);
    }

    public void reportGeofenceResumeStatus(int n, int n2) {
        if (DEBUG) {
            Log.d(TAG, "ResumeCallback| id:" + n + ", status:" + n2);
        }
        this.reportGeofenceOperationStatus(5, n, n2);
    }

    public void reportGeofenceTransition(int n, Location location, int n2, long l, int n3, int n4) {
        if (location == null) {
            Log.e(TAG, String.format("Invalid Geofence Transition: location=%p", location));
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "GeofenceTransition| " + location + ", transition:" + n2 + ", transitionTimestamp:" + l + ", monitoringType:" + n3 + ", sourcesUsed:" + n4);
        }
        GeofenceTransition geofenceTransition = new GeofenceTransition(n, n2, l, location, n3, n4);
        this.acquireWakeLock();
        this.mGeofenceHandler.obtainMessage(1, geofenceTransition).sendToTarget();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resumeGeofence(int n, int n2, int n3) {
        boolean bl;
        if (DEBUG) {
            Log.d(TAG, "Resume Geofence: GeofenceId: " + n);
        }
        SparseArray<IGeofenceHardwareCallback> sparseArray = this.mGeofences;
        synchronized (sparseArray) {
            if (this.mGeofences.get(n) == null) {
                throw new IllegalArgumentException("Geofence " + n + " not registered.");
            }
        }
        switch (n2) {
            default: {
                bl = false;
                break;
            }
            case 0: {
                IGpsGeofenceHardware iGpsGeofenceHardware = this.mGpsService;
                bl = false;
                if (iGpsGeofenceHardware == null) return bl;
                try {
                    boolean bl2;
                    bl = bl2 = this.mGpsService.resumeHardwareGeofence(n, n3);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "ResumeGeofence: Remote Exception calling LocationManagerService");
                    bl = false;
                }
                break;
            }
            case 1: {
                IFusedGeofenceHardware iFusedGeofenceHardware = this.mFusedService;
                bl = false;
                if (iFusedGeofenceHardware == null) return bl;
                try {
                    this.mFusedService.resumeMonitoringGeofence(n, n3);
                    bl = true;
                    break;
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, "ResumeGeofence: RemoteException calling LocationManagerService");
                    bl = false;
                }
            }
        }
        if (!DEBUG) return bl;
        Log.d(TAG, "resumeGeofence: Result is: " + bl);
        return bl;
    }

    public void setFusedGeofenceHardware(IFusedGeofenceHardware iFusedGeofenceHardware) {
        if (this.mFusedService == null) {
            this.mFusedService = iFusedGeofenceHardware;
            this.updateFusedHardwareAvailability();
            return;
        }
        if (iFusedGeofenceHardware == null) {
            this.mFusedService = null;
            Log.w(TAG, "Fused Geofence Hardware service seems to have crashed");
            return;
        }
        Log.e(TAG, "Error: FusedService being set again");
    }

    public void setGpsHardwareGeofence(IGpsGeofenceHardware iGpsGeofenceHardware) {
        if (this.mGpsService == null) {
            this.mGpsService = iGpsGeofenceHardware;
            this.updateGpsHardwareAvailability();
            return;
        }
        if (iGpsGeofenceHardware == null) {
            this.mGpsService = null;
            Log.w(TAG, "GPS Geofence Hardware service seems to have crashed");
            return;
        }
        Log.e(TAG, "Error: GpsService being set again.");
    }

    public boolean unregisterForMonitorStateChangeCallback(int n, IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback) {
        Message message = this.mCallbacksHandler.obtainMessage(3, iGeofenceHardwareMonitorCallback);
        message.arg1 = n;
        this.mCallbacksHandler.sendMessage(message);
        return true;
    }

    private class GeofenceTransition {
        private int mGeofenceId;
        private Location mLocation;
        private int mMonitoringType;
        private int mSourcesUsed;
        private long mTimestamp;
        private int mTransition;

        GeofenceTransition(int n, int n2, long l, Location location, int n3, int n4) {
            this.mGeofenceId = n;
            this.mTransition = n2;
            this.mTimestamp = l;
            this.mLocation = location;
            this.mMonitoringType = n3;
            this.mSourcesUsed = n4;
        }
    }

    class Reaper
    implements IBinder.DeathRecipient {
        private IGeofenceHardwareCallback mCallback;
        private IGeofenceHardwareMonitorCallback mMonitorCallback;
        private int mMonitoringType;

        Reaper(IGeofenceHardwareCallback iGeofenceHardwareCallback, int n) {
            this.mCallback = iGeofenceHardwareCallback;
            this.mMonitoringType = n;
        }

        Reaper(IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback, int n) {
            this.mMonitorCallback = iGeofenceHardwareMonitorCallback;
            this.mMonitoringType = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void binderDied() {
            if (this.mCallback != null) {
                Message message = GeofenceHardwareImpl.this.mGeofenceHandler.obtainMessage(6, this.mCallback);
                message.arg1 = this.mMonitoringType;
                GeofenceHardwareImpl.this.mGeofenceHandler.sendMessage(message);
            } else if (this.mMonitorCallback != null) {
                Message message = GeofenceHardwareImpl.this.mCallbacksHandler.obtainMessage(4, this.mMonitorCallback);
                message.arg1 = this.mMonitoringType;
                GeofenceHardwareImpl.this.mCallbacksHandler.sendMessage(message);
            }
            Message message = GeofenceHardwareImpl.this.mReaperHandler.obtainMessage(3, this);
            GeofenceHardwareImpl.this.mReaperHandler.sendMessage(message);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = true;
            if (object == null) {
                return false;
            }
            if (object == this) return bl;
            Reaper reaper = (Reaper)object;
            if (reaper.mCallback != this.mCallback) return false;
            if (reaper.mMonitorCallback != this.mMonitorCallback) return false;
            if (reaper.mMonitoringType == this.mMonitoringType) return bl;
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n = this.mCallback != null ? this.mCallback.hashCode() : 0;
            int n2 = 31 * (n + 527);
            IGeofenceHardwareMonitorCallback iGeofenceHardwareMonitorCallback = this.mMonitorCallback;
            int n3 = 0;
            if (iGeofenceHardwareMonitorCallback != null) {
                n3 = this.mMonitorCallback.hashCode();
            }
            return 31 * (n2 + n3) + this.mMonitoringType;
        }
    }
}

