/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.os.ParcelFileDescriptor;
import java.io.FileDescriptor;

public class UsbDeviceConnection {
    private static final String TAG = "UsbDeviceConnection";
    private final UsbDevice mDevice;
    private long mNativeContext;

    public UsbDeviceConnection(UsbDevice usbDevice) {
        this.mDevice = usbDevice;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void checkBounds(byte[] byArray, int n, int n2) {
        int n3 = byArray != null ? byArray.length : 0;
        if (n >= 0 && n + n2 <= n3) {
            return;
        }
        throw new IllegalArgumentException("Buffer start or length out of bounds.");
    }

    private native int native_bulk_request(int var1, byte[] var2, int var3, int var4, int var5);

    private native boolean native_claim_interface(int var1, boolean var2);

    private native void native_close();

    private native int native_control_request(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, int var8);

    private native byte[] native_get_desc();

    private native int native_get_fd();

    private native String native_get_serial();

    private native boolean native_open(String var1, FileDescriptor var2);

    private native boolean native_release_interface(int var1);

    private native UsbRequest native_request_wait();

    private native boolean native_set_configuration(int var1);

    private native boolean native_set_interface(int var1, int var2);

    public int bulkTransfer(UsbEndpoint usbEndpoint, byte[] byArray, int n, int n2) {
        return this.bulkTransfer(usbEndpoint, byArray, 0, n, n2);
    }

    public int bulkTransfer(UsbEndpoint usbEndpoint, byte[] byArray, int n, int n2, int n3) {
        UsbDeviceConnection.checkBounds(byArray, n, n2);
        return this.native_bulk_request(usbEndpoint.getAddress(), byArray, n, n2, n3);
    }

    public boolean claimInterface(UsbInterface usbInterface, boolean bl) {
        return this.native_claim_interface(usbInterface.getId(), bl);
    }

    public void close() {
        this.native_close();
    }

    public int controlTransfer(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        return this.controlTransfer(n, n2, n3, n4, byArray, 0, n5, n6);
    }

    public int controlTransfer(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, int n7) {
        UsbDeviceConnection.checkBounds(byArray, n5, n6);
        return this.native_control_request(n, n2, n3, n4, byArray, n5, n6, n7);
    }

    public int getFileDescriptor() {
        return this.native_get_fd();
    }

    public byte[] getRawDescriptors() {
        return this.native_get_desc();
    }

    public String getSerial() {
        return this.native_get_serial();
    }

    boolean open(String string2, ParcelFileDescriptor parcelFileDescriptor) {
        return this.native_open(string2, parcelFileDescriptor.getFileDescriptor());
    }

    public boolean releaseInterface(UsbInterface usbInterface) {
        return this.native_release_interface(usbInterface.getId());
    }

    public UsbRequest requestWait() {
        UsbRequest usbRequest = this.native_request_wait();
        if (usbRequest != null) {
            usbRequest.dequeue();
        }
        return usbRequest;
    }

    public boolean setConfiguration(UsbConfiguration usbConfiguration) {
        return this.native_set_configuration(usbConfiguration.getId());
    }

    public boolean setInterface(UsbInterface usbInterface) {
        return this.native_set_interface(usbInterface.getId(), usbInterface.getAlternateSetting());
    }
}

