/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParserException;

public class Keyboard {
    public static final int EDGE_BOTTOM = 8;
    public static final int EDGE_LEFT = 1;
    public static final int EDGE_RIGHT = 2;
    public static final int EDGE_TOP = 4;
    private static final int GRID_HEIGHT = 5;
    private static final int GRID_SIZE = 50;
    private static final int GRID_WIDTH = 10;
    public static final int KEYCODE_ALT = -6;
    public static final int KEYCODE_CANCEL = -3;
    public static final int KEYCODE_DELETE = -5;
    public static final int KEYCODE_DONE = -4;
    public static final int KEYCODE_MODE_CHANGE = -2;
    public static final int KEYCODE_SHIFT = -1;
    private static float SEARCH_DISTANCE = 0.0f;
    static final String TAG = "Keyboard";
    private static final String TAG_KEY = "Key";
    private static final String TAG_KEYBOARD = "Keyboard";
    private static final String TAG_ROW = "Row";
    private int mCellHeight;
    private int mCellWidth;
    private int mDefaultHeight;
    private int mDefaultHorizontalGap;
    private int mDefaultVerticalGap;
    private int mDefaultWidth;
    private int mDisplayHeight;
    private int mDisplayWidth;
    private int[][] mGridNeighbors;
    private int mKeyHeight;
    private int mKeyWidth;
    private int mKeyboardMode;
    private List<Key> mKeys;
    private CharSequence mLabel;
    private List<Key> mModifierKeys;
    private int mProximityThreshold;
    private int[] mShiftKeyIndices;
    private Key[] mShiftKeys = new Key[]{null, null};
    private boolean mShifted;
    private int mTotalHeight;
    private int mTotalWidth;
    private ArrayList<Row> rows;

    static {
        SEARCH_DISTANCE = 1.8f;
    }

    public Keyboard(Context context, int n) {
        this(context, n, 0);
    }

    public Keyboard(Context context, int n, int n2) {
        this.mShiftKeyIndices = new int[]{-1, -1};
        this.rows = new ArrayList();
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDisplayWidth = displayMetrics.widthPixels;
        this.mDisplayHeight = displayMetrics.heightPixels;
        this.mDefaultHorizontalGap = 0;
        this.mDefaultWidth = this.mDisplayWidth / 10;
        this.mDefaultVerticalGap = 0;
        this.mDefaultHeight = this.mDefaultWidth;
        this.mKeys = new ArrayList<Key>();
        this.mModifierKeys = new ArrayList<Key>();
        this.mKeyboardMode = n2;
        this.loadKeyboard(context, context.getResources().getXml(n));
    }

    public Keyboard(Context context, int n, int n2, int n3, int n4) {
        this.mShiftKeyIndices = new int[]{-1, -1};
        this.rows = new ArrayList();
        this.mDisplayWidth = n3;
        this.mDisplayHeight = n4;
        this.mDefaultHorizontalGap = 0;
        this.mDefaultWidth = this.mDisplayWidth / 10;
        this.mDefaultVerticalGap = 0;
        this.mDefaultHeight = this.mDefaultWidth;
        this.mKeys = new ArrayList<Key>();
        this.mModifierKeys = new ArrayList<Key>();
        this.mKeyboardMode = n2;
        this.loadKeyboard(context, context.getResources().getXml(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Keyboard(Context context, int n, CharSequence charSequence, int n2, int n3) {
        this(context, n);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.mTotalWidth = 0;
        Row row = new Row(this);
        row.defaultHeight = this.mDefaultHeight;
        row.defaultWidth = this.mDefaultWidth;
        row.defaultHorizontalGap = this.mDefaultHorizontalGap;
        row.verticalGap = this.mDefaultVerticalGap;
        row.rowEdgeFlags = 12;
        int n7 = n2 == -1 ? Integer.MAX_VALUE : n2;
        int n8 = 0;
        while (true) {
            if (n8 >= charSequence.length()) {
                this.mTotalHeight = n5 + this.mDefaultHeight;
                this.rows.add(row);
                return;
            }
            char c = charSequence.charAt(n8);
            if (n6 >= n7 || n3 + (n4 + this.mDefaultWidth) > this.mDisplayWidth) {
                n4 = 0;
                n5 += this.mDefaultVerticalGap + this.mDefaultHeight;
                n6 = 0;
            }
            Key key = new Key(row);
            key.x = n4;
            key.y = n5;
            key.label = String.valueOf(c);
            key.codes = new int[]{c};
            ++n6;
            this.mKeys.add(key);
            row.mKeys.add(key);
            if ((n4 += key.width + key.gap) > this.mTotalWidth) {
                this.mTotalWidth = n4;
            }
            ++n8;
        }
    }

    private void computeNearestNeighbors() {
        this.mCellWidth = (-1 + (10 + this.getMinWidth())) / 10;
        this.mCellHeight = (-1 + (5 + this.getHeight())) / 5;
        this.mGridNeighbors = new int[50][];
        int[] nArray = new int[this.mKeys.size()];
        int n = 10 * this.mCellWidth;
        int n2 = 5 * this.mCellHeight;
        for (int i = 0; i < n; i += this.mCellWidth) {
            for (int j = 0; j < n2; j += this.mCellHeight) {
                int n3 = 0;
                for (int k = 0; k < this.mKeys.size(); ++k) {
                    Key key = this.mKeys.get(k);
                    if (key.squaredDistanceFrom(i, j) >= this.mProximityThreshold && key.squaredDistanceFrom(-1 + (i + this.mCellWidth), j) >= this.mProximityThreshold && key.squaredDistanceFrom(-1 + (i + this.mCellWidth), -1 + (j + this.mCellHeight)) >= this.mProximityThreshold && key.squaredDistanceFrom(i, -1 + (j + this.mCellHeight)) >= this.mProximityThreshold) continue;
                    int n4 = n3 + 1;
                    nArray[n3] = k;
                    n3 = n4;
                }
                int[] nArray2 = new int[n3];
                System.arraycopy((int[])nArray, (int)0, (int[])nArray2, (int)0, (int)n3);
                this.mGridNeighbors[10 * (j / this.mCellHeight) + i / this.mCellWidth] = nArray2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static int getDimensionOrFraction(TypedArray typedArray, int n, int n2, int n3) {
        block5: {
            block4: {
                TypedValue typedValue = typedArray.peekValue(n);
                if (typedValue == null) break block4;
                if (typedValue.type == 5) {
                    return typedArray.getDimensionPixelOffset(n, n3);
                }
                if (typedValue.type == 6) break block5;
            }
            return n3;
        }
        return Math.round(typedArray.getFraction(n, n2, n2, n3));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadKeyboard(Context var1_1, XmlResourceParser var2_2) {
        block15: {
            block14: {
                var3_3 = false;
                var4_4 = false;
                var5_5 = 0;
                var6_6 = 0;
                var7_7 = 0;
                var8_8 = null;
                var9_9 = null;
                var10_10 = var1_1.getResources();
                try {
                    block3: while ((var13_11 = var2_2.next()) != 1) {
                        block17: {
                            block16: {
                                if (var13_11 != 2) break block16;
                                var14_12 = var2_2.getName();
                                if ("Row".equals(var14_12)) {
                                    var4_4 = true;
                                    var9_9 = this.createRowFromXml(var10_10, var2_2);
                                    this.rows.add(var9_9);
                                    var16_13 = var9_9.mode != 0 && var9_9.mode != this.mKeyboardMode;
                                    var6_6 = 0;
                                    if (!var16_13) continue;
                                    this.skipToEndOfRow(var2_2);
                                    var6_6 = 0;
                                    var4_4 = false;
                                    continue;
                                }
                                if ("Key".equals(var14_12)) {
                                    var3_3 = true;
                                    var8_8 = this.createKeyFromXml(var10_10, var9_9, var6_6, var7_7, var2_2);
                                    this.mKeys.add(var8_8);
                                    if (var8_8.codes[0] != -1) break block14;
                                    break block17;
                                } else {
                                    if (!"Keyboard".equals(var14_12)) continue;
                                    this.parseKeyboardAttributes(var10_10, var2_2);
                                    continue;
                                }
                            }
                            if (var13_11 != 3) continue;
                            if (var3_3) {
                                var22_15 = this.mTotalWidth;
                                var3_3 = false;
                                if ((var6_6 += var8_8.gap + var8_8.width) <= var22_15) continue;
                                this.mTotalWidth = var6_6;
                                var3_3 = false;
                                continue;
                            }
                            if (!var4_4) continue;
                            var7_7 += var9_9.verticalGap;
                            var23_16 = var9_9.defaultHeight;
                            var7_7 += var23_16;
                            ++var5_5;
                            var4_4 = false;
                            continue;
                        }
                        var18_14 = 0;
                        while (true) {
                            block19: {
                                block18: {
                                    if (var18_14 >= this.mShiftKeys.length) break block18;
                                    if (this.mShiftKeys[var18_14] != null) break block19;
                                    this.mShiftKeys[var18_14] = var8_8;
                                    this.mShiftKeyIndices[var18_14] = -1 + this.mKeys.size();
                                }
                                this.mModifierKeys.add(var8_8);
                                break;
                            }
                            ++var18_14;
                        }
lbl65:
                        // 3 sources

                        while (true) {
                            var9_9.mKeys.add(var8_8);
                            continue block3;
                            break;
                        }
                    }
                    break block15;
                }
                catch (Exception var11_17) {
                    Log.e("Keyboard", "Parse error:" + var11_17);
                    var11_17.printStackTrace();
                    break block15;
                }
            }
            if (var8_8.codes[0] != -6) ** GOTO lbl65
            this.mModifierKeys.add(var8_8);
            ** while (true)
        }
        this.mTotalHeight = var7_7 - this.mDefaultVerticalGap;
    }

    private void parseKeyboardAttributes(Resources resources, XmlResourceParser xmlResourceParser) {
        TypedArray typedArray = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.Keyboard);
        this.mDefaultWidth = Keyboard.getDimensionOrFraction(typedArray, 0, this.mDisplayWidth, this.mDisplayWidth / 10);
        this.mDefaultHeight = Keyboard.getDimensionOrFraction(typedArray, 1, this.mDisplayHeight, 50);
        this.mDefaultHorizontalGap = Keyboard.getDimensionOrFraction(typedArray, 2, this.mDisplayWidth, 0);
        this.mDefaultVerticalGap = Keyboard.getDimensionOrFraction(typedArray, 3, this.mDisplayHeight, 0);
        this.mProximityThreshold = (int)((float)this.mDefaultWidth * SEARCH_DISTANCE);
        this.mProximityThreshold *= this.mProximityThreshold;
        typedArray.recycle();
    }

    private void skipToEndOfRow(XmlResourceParser xmlResourceParser) throws XmlPullParserException, IOException {
        int n;
        while (!((n = xmlResourceParser.next()) == 1 || n == 3 && xmlResourceParser.getName().equals(TAG_ROW))) {
        }
    }

    protected Key createKeyFromXml(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
        return new Key(resources, row, n, n2, xmlResourceParser);
    }

    protected Row createRowFromXml(Resources resources, XmlResourceParser xmlResourceParser) {
        return new Row(resources, this, xmlResourceParser);
    }

    public int getHeight() {
        return this.mTotalHeight;
    }

    protected int getHorizontalGap() {
        return this.mDefaultHorizontalGap;
    }

    protected int getKeyHeight() {
        return this.mDefaultHeight;
    }

    protected int getKeyWidth() {
        return this.mDefaultWidth;
    }

    public List<Key> getKeys() {
        return this.mKeys;
    }

    public int getMinWidth() {
        return this.mTotalWidth;
    }

    public List<Key> getModifierKeys() {
        return this.mModifierKeys;
    }

    public int[] getNearestKeys(int n, int n2) {
        int n3;
        if (this.mGridNeighbors == null) {
            this.computeNearestNeighbors();
        }
        if (n >= 0 && n < this.getMinWidth() && n2 >= 0 && n2 < this.getHeight() && (n3 = 10 * (n2 / this.mCellHeight) + n / this.mCellWidth) < 50) {
            return this.mGridNeighbors[n3];
        }
        return new int[0];
    }

    public int getShiftKeyIndex() {
        return this.mShiftKeyIndices[0];
    }

    public int[] getShiftKeyIndices() {
        return this.mShiftKeyIndices;
    }

    protected int getVerticalGap() {
        return this.mDefaultVerticalGap;
    }

    public boolean isShifted() {
        return this.mShifted;
    }

    final void resize(int n, int n2) {
        int n3 = this.rows.size();
        for (int i = 0; i < n3; ++i) {
            Row row = this.rows.get(i);
            int n4 = row.mKeys.size();
            int n5 = 0;
            int n6 = 0;
            for (int j = 0; j < n4; ++j) {
                Key key = row.mKeys.get(j);
                if (j > 0) {
                    n5 += key.gap;
                }
                n6 += key.width;
            }
            if (n5 + n6 <= n) continue;
            int n7 = 0;
            float f = (float)(n - n5) / (float)n6;
            for (int j = 0; j < n4; ++j) {
                Key key = row.mKeys.get(j);
                key.width = (int)(f * (float)key.width);
                key.x = n7;
                n7 += key.width + key.gap;
            }
        }
        this.mTotalWidth = n;
    }

    protected void setHorizontalGap(int n) {
        this.mDefaultHorizontalGap = n;
    }

    protected void setKeyHeight(int n) {
        this.mDefaultHeight = n;
    }

    protected void setKeyWidth(int n) {
        this.mDefaultWidth = n;
    }

    public boolean setShifted(boolean bl) {
        for (Key key : this.mShiftKeys) {
            if (key == null) continue;
            key.on = bl;
        }
        if (this.mShifted != bl) {
            this.mShifted = bl;
            return true;
        }
        return false;
    }

    protected void setVerticalGap(int n) {
        this.mDefaultVerticalGap = n;
    }

    public static class Key {
        private static final int[] KEY_STATE_NORMAL;
        private static final int[] KEY_STATE_NORMAL_OFF;
        private static final int[] KEY_STATE_NORMAL_ON;
        private static final int[] KEY_STATE_PRESSED;
        private static final int[] KEY_STATE_PRESSED_OFF;
        private static final int[] KEY_STATE_PRESSED_ON;
        public int[] codes;
        public int edgeFlags;
        public int gap;
        public int height;
        public Drawable icon;
        public Drawable iconPreview;
        private Keyboard keyboard;
        public CharSequence label;
        public boolean modifier;
        public boolean on;
        public CharSequence popupCharacters;
        public int popupResId;
        public boolean pressed;
        public boolean repeatable;
        public boolean sticky;
        public CharSequence text;
        public int width;
        public int x;
        public int y;

        static {
            KEY_STATE_NORMAL_ON = new int[]{16842911, 0x10100A0};
            KEY_STATE_PRESSED_ON = new int[]{16842919, 16842911, 0x10100A0};
            KEY_STATE_NORMAL_OFF = new int[]{16842911};
            KEY_STATE_PRESSED_OFF = new int[]{16842919, 16842911};
            KEY_STATE_NORMAL = new int[0];
            KEY_STATE_PRESSED = new int[]{16842919};
        }

        /*
         * Enabled aggressive block sorting
         */
        public Key(Resources resources, Row row, int n, int n2, XmlResourceParser xmlResourceParser) {
            this(row);
            this.x = n;
            this.y = n2;
            TypedArray typedArray = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.Keyboard);
            this.width = Keyboard.getDimensionOrFraction(typedArray, 0, this.keyboard.mDisplayWidth, row.defaultWidth);
            this.height = Keyboard.getDimensionOrFraction(typedArray, 1, this.keyboard.mDisplayHeight, row.defaultHeight);
            this.gap = Keyboard.getDimensionOrFraction(typedArray, 2, this.keyboard.mDisplayWidth, row.defaultHorizontalGap);
            typedArray.recycle();
            TypedArray typedArray2 = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.Keyboard_Key);
            this.x += this.gap;
            TypedValue typedValue = new TypedValue();
            typedArray2.getValue(0, typedValue);
            if (typedValue.type == 16 || typedValue.type == 17) {
                int[] nArray = new int[]{typedValue.data};
                this.codes = nArray;
            } else if (typedValue.type == 3) {
                this.codes = this.parseCSV(typedValue.string.toString());
            }
            this.iconPreview = typedArray2.getDrawable(7);
            if (this.iconPreview != null) {
                this.iconPreview.setBounds(0, 0, this.iconPreview.getIntrinsicWidth(), this.iconPreview.getIntrinsicHeight());
            }
            this.popupCharacters = typedArray2.getText(2);
            this.popupResId = typedArray2.getResourceId(1, 0);
            this.repeatable = typedArray2.getBoolean(6, false);
            this.modifier = typedArray2.getBoolean(4, false);
            this.sticky = typedArray2.getBoolean(5, false);
            this.edgeFlags = typedArray2.getInt(3, 0);
            this.edgeFlags |= row.rowEdgeFlags;
            this.icon = typedArray2.getDrawable(10);
            if (this.icon != null) {
                this.icon.setBounds(0, 0, this.icon.getIntrinsicWidth(), this.icon.getIntrinsicHeight());
            }
            this.label = typedArray2.getText(9);
            this.text = typedArray2.getText(8);
            if (this.codes == null && !TextUtils.isEmpty(this.label)) {
                int[] nArray = new int[]{this.label.charAt(0)};
                this.codes = nArray;
            }
            typedArray2.recycle();
        }

        public Key(Row row) {
            this.keyboard = row.parent;
            this.height = row.defaultHeight;
            this.width = row.defaultWidth;
            this.gap = row.defaultHorizontalGap;
            this.edgeFlags = row.rowEdgeFlags;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int[] getCurrentDrawableState() {
            int[] nArray = KEY_STATE_NORMAL;
            if (this.on) {
                if (!this.pressed) return KEY_STATE_NORMAL_ON;
                return KEY_STATE_PRESSED_ON;
            }
            if (this.sticky) {
                if (!this.pressed) return KEY_STATE_NORMAL_OFF;
                return KEY_STATE_PRESSED_OFF;
            }
            if (!this.pressed) return nArray;
            return KEY_STATE_PRESSED;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean isInside(int n, int n2) {
            boolean bl = (1 & this.edgeFlags) > 0;
            boolean bl2 = (2 & this.edgeFlags) > 0;
            boolean bl3 = (4 & this.edgeFlags) > 0;
            boolean bl4 = (8 & this.edgeFlags) > 0;
            return (n >= this.x || bl && n <= this.x + this.width) && (n < this.x + this.width || bl2 && n >= this.x) && (n2 >= this.y || bl3 && n2 <= this.y + this.height) && (n2 < this.y + this.height || bl4 && n2 >= this.y);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onPressed() {
            boolean bl = !this.pressed;
            this.pressed = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onReleased(boolean bl) {
            boolean bl2 = true;
            boolean bl3 = !this.pressed ? bl2 : false;
            this.pressed = bl3;
            if (this.sticky) {
                if (this.on) {
                    bl2 = false;
                }
                this.on = bl2;
            }
        }

        int[] parseCSV(String string2) {
            int n = 0;
            int n2 = string2.length();
            int n3 = 0;
            if (n2 > 0) {
                n3 = 0 + 1;
                while ((n = string2.indexOf(",", n + 1)) > 0) {
                    ++n3;
                }
            }
            int[] nArray = new int[n3];
            int n4 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = n4 + 1;
                try {
                    nArray[n4] = Integer.parseInt(stringTokenizer.nextToken());
                    n4 = n5;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e("Keyboard", "Error parsing keycodes " + string2);
                    n4 = n5;
                }
            }
            return nArray;
        }

        public int squaredDistanceFrom(int n, int n2) {
            int n3 = this.x + this.width / 2 - n;
            int n4 = this.y + this.height / 2 - n2;
            return n3 * n3 + n4 * n4;
        }
    }

    public static class Row {
        public int defaultHeight;
        public int defaultHorizontalGap;
        public int defaultWidth;
        ArrayList<Key> mKeys = new ArrayList();
        public int mode;
        private Keyboard parent;
        public int rowEdgeFlags;
        public int verticalGap;

        public Row(Resources resources, Keyboard keyboard, XmlResourceParser xmlResourceParser) {
            this.parent = keyboard;
            TypedArray typedArray = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.Keyboard);
            this.defaultWidth = Keyboard.getDimensionOrFraction(typedArray, 0, keyboard.mDisplayWidth, keyboard.mDefaultWidth);
            this.defaultHeight = Keyboard.getDimensionOrFraction(typedArray, 1, keyboard.mDisplayHeight, keyboard.mDefaultHeight);
            this.defaultHorizontalGap = Keyboard.getDimensionOrFraction(typedArray, 2, keyboard.mDisplayWidth, keyboard.mDefaultHorizontalGap);
            this.verticalGap = Keyboard.getDimensionOrFraction(typedArray, 3, keyboard.mDisplayHeight, keyboard.mDefaultVerticalGap);
            typedArray.recycle();
            TypedArray typedArray2 = resources.obtainAttributes(Xml.asAttributeSet(xmlResourceParser), R.styleable.Keyboard_Row);
            this.rowEdgeFlags = typedArray2.getInt(0, 0);
            this.mode = typedArray2.getResourceId(1, 0);
        }

        public Row(Keyboard keyboard) {
            this.parent = keyboard;
        }
    }
}

