/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GpsClock;
import android.location.GpsMeasurement;
import android.os.Parcel;
import android.os.Parcelable;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class GpsMeasurementsEvent
implements Parcelable {
    public static final Parcelable.Creator<GpsMeasurementsEvent> CREATOR = new Parcelable.Creator<GpsMeasurementsEvent>(){

        @Override
        public GpsMeasurementsEvent createFromParcel(Parcel parcel) {
            GpsClock gpsClock = (GpsClock)parcel.readParcelable(this.getClass().getClassLoader());
            GpsMeasurement[] gpsMeasurementArray = new GpsMeasurement[parcel.readInt()];
            parcel.readTypedArray(gpsMeasurementArray, GpsMeasurement.CREATOR);
            return new GpsMeasurementsEvent(gpsClock, gpsMeasurementArray);
        }

        public GpsMeasurementsEvent[] newArray(int n) {
            return new GpsMeasurementsEvent[n];
        }
    };
    private final GpsClock mClock;
    private final Collection<GpsMeasurement> mReadOnlyMeasurements;

    public GpsMeasurementsEvent(GpsClock gpsClock, GpsMeasurement[] gpsMeasurementArray) {
        if (gpsClock == null) {
            throw new InvalidParameterException("Parameter 'clock' must not be null.");
        }
        if (gpsMeasurementArray == null || gpsMeasurementArray.length == 0) {
            throw new InvalidParameterException("Parameter 'measurements' must not be null or empty.");
        }
        this.mClock = gpsClock;
        this.mReadOnlyMeasurements = Collections.unmodifiableCollection(Arrays.asList(gpsMeasurementArray));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public GpsClock getClock() {
        return this.mClock;
    }

    public Collection<GpsMeasurement> getMeasurements() {
        return this.mReadOnlyMeasurements;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[ GpsMeasurementsEvent:\n\n");
        stringBuilder.append(this.mClock.toString());
        stringBuilder.append("\n");
        Iterator<GpsMeasurement> iterator = this.mReadOnlyMeasurements.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.mClock, n);
        Parcelable[] parcelableArray = this.mReadOnlyMeasurements.toArray(new GpsMeasurement[0]);
        parcel.writeInt(parcelableArray.length);
        parcel.writeTypedArray(parcelableArray, n);
    }

    public static interface Listener {
        public void onGpsMeasurementsReceived(GpsMeasurementsEvent var1);
    }
}

