/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.Image;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageReader
implements AutoCloseable {
    private static final int ACQUIRE_MAX_IMAGES = 2;
    private static final int ACQUIRE_NO_BUFS = 1;
    private static final int ACQUIRE_SUCCESS;
    private final int mFormat;
    private final int mHeight;
    private OnImageAvailableListener mListener;
    private ListenerHandler mListenerHandler;
    private final Object mListenerLock = new Object();
    private final int mMaxImages;
    private long mNativeContext;
    private final int mNumPlanes;
    private final Surface mSurface;
    private final int mWidth;

    static {
        System.loadLibrary("media_jni");
        ImageReader.nativeClassInit();
    }

    protected ImageReader(int n, int n2, int n3, int n4) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mFormat = n3;
        this.mMaxImages = n4;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("The image dimensions must be positive");
        }
        if (this.mMaxImages < 1) {
            throw new IllegalArgumentException("Maximum outstanding image count must be at least 1");
        }
        if (n3 == 17) {
            throw new IllegalArgumentException("NV21 format is not supported");
        }
        this.mNumPlanes = this.getNumPlanesFromFormat();
        this.nativeInit(new WeakReference<ImageReader>(this), n, n2, n3, n4);
        this.mSurface = this.nativeGetSurface();
    }

    private int acquireNextSurfaceImage(SurfaceImage surfaceImage) {
        int n = this.nativeImageSetup(surfaceImage);
        switch (n) {
            default: {
                throw new AssertionError((Object)("Unknown nativeImageSetup return code " + n));
            }
            case 0: {
                surfaceImage.createSurfacePlanes();
                surfaceImage.setImageValid(true);
            }
            case 1: 
            case 2: 
        }
        return n;
    }

    private int getNumPlanesFromFormat() {
        int n = 1;
        switch (this.mFormat) {
            default: {
                Object[] objectArray = new Object[n];
                objectArray[0] = this.mFormat;
                throw new UnsupportedOperationException(String.format("Invalid format specified %d", objectArray));
            }
            case 17: 
            case 35: 
            case 842094169: {
                n = 3;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 20: 
            case 32: 
            case 37: 
            case 256: 
            case 538982489: 
            case 540422489: {
                return n;
            }
            case 16: 
        }
        return 2;
    }

    private static native void nativeClassInit();

    private synchronized native void nativeClose();

    private synchronized native Surface nativeGetSurface();

    private synchronized native int nativeImageSetup(Image var1);

    private synchronized native void nativeInit(Object var1, int var2, int var3, int var4, int var5);

    private synchronized native void nativeReleaseImage(Image var1);

    public static ImageReader newInstance(int n, int n2, int n3, int n4) {
        return new ImageReader(n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void postEventFromNative(Object object) {
        ListenerHandler listenerHandler;
        block6: {
            block5: {
                ImageReader imageReader = (ImageReader)((WeakReference)object).get();
                if (imageReader == null) break block5;
                Object object2 = imageReader.mListenerLock;
                synchronized (object2) {
                    listenerHandler = imageReader.mListenerHandler;
                    if (listenerHandler != null) break block6;
                }
            }
            return;
        }
        listenerHandler.sendEmptyMessage(0);
    }

    private void releaseImage(Image image) {
        if (!(image instanceof SurfaceImage)) {
            throw new IllegalArgumentException("This image was not produced by an ImageReader");
        }
        SurfaceImage surfaceImage = (SurfaceImage)image;
        if (surfaceImage.getReader() != this) {
            throw new IllegalArgumentException("This image was not produced by this ImageReader");
        }
        surfaceImage.clearSurfacePlanes();
        this.nativeReleaseImage(image);
        surfaceImage.setImageValid(false);
    }

    /*
     * Exception decompiling
     */
    public Image acquireLatestImage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Image acquireNextImage() {
        SurfaceImage surfaceImage = new SurfaceImage();
        int n = this.acquireNextSurfaceImage(surfaceImage);
        switch (n) {
            default: {
                throw new AssertionError((Object)("Unknown nativeImageSetup return code " + n));
            }
            case 1: {
                surfaceImage = null;
            }
            case 0: {
                return surfaceImage;
            }
            case 2: 
        }
        Object[] objectArray = new Object[]{this.mMaxImages};
        throw new IllegalStateException(String.format("maxImages (%d) has already been acquired, call #close before acquiring more.", objectArray));
    }

    public Image acquireNextImageNoThrowISE() {
        SurfaceImage surfaceImage = new SurfaceImage();
        if (this.acquireNextSurfaceImage(surfaceImage) == 0) {
            return surfaceImage;
        }
        return null;
    }

    @Override
    public void close() {
        this.setOnImageAvailableListener(null, null);
        this.nativeClose();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getImageFormat() {
        return this.mFormat;
    }

    public int getMaxImages() {
        return this.mMaxImages;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public int getWidth() {
        return this.mWidth;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnImageAvailableListener(OnImageAvailableListener onImageAvailableListener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            if (onImageAvailableListener != null) {
                Looper looper = handler != null ? handler.getLooper() : Looper.myLooper();
                if (looper == null) {
                    throw new IllegalArgumentException("handler is null but the current thread is not a looper");
                }
                if (this.mListenerHandler == null || this.mListenerHandler.getLooper() != looper) {
                    this.mListenerHandler = new ListenerHandler(looper);
                }
                this.mListener = onImageAvailableListener;
            } else {
                this.mListener = null;
                this.mListenerHandler = null;
            }
            return;
        }
    }

    private final class ListenerHandler
    extends Handler {
        public ListenerHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            Object object = ImageReader.this.mListenerLock;
            // MONITORENTER : object
            OnImageAvailableListener onImageAvailableListener = ImageReader.this.mListener;
            // MONITOREXIT : object
            if (onImageAvailableListener == null) return;
            onImageAvailableListener.onImageAvailable(ImageReader.this);
        }
    }

    public static interface OnImageAvailableListener {
        public void onImageAvailable(ImageReader var1);
    }

    private class SurfaceImage
    extends Image {
        private boolean mIsImageValid = false;
        private long mLockedBuffer;
        private SurfacePlane[] mPlanes;
        private long mTimestamp;

        private void clearSurfacePlanes() {
            if (this.mIsImageValid) {
                for (int i = 0; i < this.mPlanes.length; ++i) {
                    if (this.mPlanes[i] == null) continue;
                    this.mPlanes[i].clearBuffer();
                    this.mPlanes[i] = null;
                }
            }
        }

        private void createSurfacePlanes() {
            this.mPlanes = new SurfacePlane[ImageReader.this.mNumPlanes];
            for (int i = 0; i < ImageReader.this.mNumPlanes; ++i) {
                this.mPlanes[i] = this.nativeCreatePlane(i, ImageReader.this.mFormat);
            }
        }

        private boolean isImageValid() {
            return this.mIsImageValid;
        }

        private synchronized native SurfacePlane nativeCreatePlane(int var1, int var2);

        private synchronized native ByteBuffer nativeImageGetBuffer(int var1, int var2);

        private void setImageValid(boolean bl) {
            this.mIsImageValid = bl;
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                ImageReader.this.releaseImage(this);
            }
        }

        protected final void finalize() throws Throwable {
            try {
                this.close();
                return;
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public int getFormat() {
            if (this.mIsImageValid) {
                return ImageReader.this.mFormat;
            }
            throw new IllegalStateException("Image is already released");
        }

        @Override
        public int getHeight() {
            if (this.mIsImageValid) {
                return ImageReader.this.mHeight;
            }
            throw new IllegalStateException("Image is already released");
        }

        @Override
        public Image.Plane[] getPlanes() {
            if (this.mIsImageValid) {
                return (Image.Plane[])this.mPlanes.clone();
            }
            throw new IllegalStateException("Image is already released");
        }

        public ImageReader getReader() {
            return ImageReader.this;
        }

        @Override
        public long getTimestamp() {
            if (this.mIsImageValid) {
                return this.mTimestamp;
            }
            throw new IllegalStateException("Image is already released");
        }

        @Override
        public int getWidth() {
            if (this.mIsImageValid) {
                return ImageReader.this.mWidth;
            }
            throw new IllegalStateException("Image is already released");
        }

        private class SurfacePlane
        extends Image.Plane {
            private ByteBuffer mBuffer;
            private final int mIndex;
            private final int mPixelStride;
            private final int mRowStride;

            private SurfacePlane(int n, int n2, int n3) {
                this.mIndex = n;
                this.mRowStride = n2;
                this.mPixelStride = n3;
            }

            private void clearBuffer() {
                this.mBuffer = null;
            }

            @Override
            public ByteBuffer getBuffer() {
                if (!SurfaceImage.this.isImageValid()) {
                    throw new IllegalStateException("Image is already released");
                }
                if (this.mBuffer != null) {
                    return this.mBuffer;
                }
                this.mBuffer = SurfaceImage.this.nativeImageGetBuffer(this.mIndex, ImageReader.this.mFormat);
                return this.mBuffer.order(ByteOrder.nativeOrder());
            }

            @Override
            public int getPixelStride() {
                if (SurfaceImage.this.isImageValid()) {
                    return this.mPixelStride;
                }
                throw new IllegalStateException("Image is already released");
            }

            @Override
            public int getRowStride() {
                if (SurfaceImage.this.isImageValid()) {
                    return this.mRowStride;
                }
                throw new IllegalStateException("Image is already released");
            }
        }
    }
}

