/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.IMediaHTTPConnection;
import android.net.NetworkUtils;
import android.os.IBinder;
import android.os.StrictMode;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MediaHTTPConnection
extends IMediaHTTPConnection.Stub {
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int MAX_REDIRECTS = 20;
    private static final String TAG = "MediaHTTPConnection";
    private static final boolean VERBOSE;
    private boolean mAllowCrossDomainRedirect = true;
    private boolean mAllowCrossProtocolRedirect = true;
    private HttpURLConnection mConnection = null;
    private long mCurrentOffset = -1L;
    private Map<String, String> mHeaders = null;
    private InputStream mInputStream = null;
    private long mNativeContext;
    private long mTotalSize = -1L;
    private URL mURL = null;

    static {
        System.loadLibrary("media_jni");
        MediaHTTPConnection.native_init();
    }

    public MediaHTTPConnection() {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        this.native_setup();
    }

    private Map<String, String> convertHeaderStringToMap(String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : string2.split("\r\n")) {
            String string4;
            String string5;
            int n = string3.indexOf(":");
            if (n < 0 || this.filterOutInternalHeaders(string5 = string3.substring(0, n), string4 = string3.substring(n + 1))) continue;
            hashMap.put(string5, string4);
        }
        return hashMap;
    }

    private boolean filterOutInternalHeaders(String string2, String string3) {
        if ("android-allow-cross-domain-redirect".equalsIgnoreCase(string2)) {
            this.mAllowCrossProtocolRedirect = this.mAllowCrossDomainRedirect = this.parseBoolean(string3);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isLocalHost(URL uRL) {
        String string2;
        if (uRL == null || (string2 = uRL.getHost()) == null) return false;
        try {
            if (string2.equalsIgnoreCase("localhost")) {
                return true;
            }
            boolean bl = NetworkUtils.numericToInetAddress(string2).isLoopbackAddress();
            if (!bl) return false;
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private final native void native_finalize();

    private final native IBinder native_getIMemory();

    private static final native void native_init();

    private final native int native_readAt(long var1, int var3);

    private final native void native_setup();

    private boolean parseBoolean(String string2) {
        try {
            long l = Long.parseLong(string2);
            return l != 0L;
        }
        catch (NumberFormatException numberFormatException) {
            boolean bl;
            block5: {
                block4: {
                    if ("true".equalsIgnoreCase(string2)) break block4;
                    boolean bl2 = "yes".equalsIgnoreCase(string2);
                    bl = false;
                    if (!bl2) break block5;
                }
                bl = true;
            }
            return bl;
        }
    }

    private int readAt(long l, byte[] byArray, int n) {
        int n2;
        block6: {
            StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder().permitAll().build());
            if (l != this.mCurrentOffset) {
                this.seekTo(l);
            }
            if ((n2 = this.mInputStream.read(byArray, 0, n)) != -1) break block6;
            n2 = 0;
        }
        try {
            this.mCurrentOffset += (long)n2;
            return n2;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            Log.w(TAG, "readAt " + l + " / " + n + " => " + noRouteToHostException);
            return -1010;
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void seekTo(long var1_1) throws IOException {
        block21: {
            block20: {
                this.teardownConnection();
                var3_2 = 0;
                try {
                    var5_3 = this.mURL;
                    var6_4 = MediaHTTPConnection.isLocalHost(var5_3);
lbl6:
                    // 3 sources

                    while (true) {
                        this.mConnection = var6_4 != false ? (HttpURLConnection)var5_3.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)var5_3.openConnection();
                        this.mConnection.setInstanceFollowRedirects(this.mAllowCrossDomainRedirect);
                        if (this.mHeaders != null) {
                            for (Map.Entry<String, String> var18_12 : this.mHeaders.entrySet()) {
                                this.mConnection.setRequestProperty(var18_12.getKey(), var18_12.getValue());
                            }
                        }
                        if (var1_1 > 0L) {
                            this.mConnection.setRequestProperty("Range", "bytes=" + var1_1 + "-");
                        }
                        if ((var7_5 = this.mConnection.getResponseCode()) != 300 && var7_5 != 301 && var7_5 != 302 && var7_5 != 303 && var7_5 != 307) {
                            if (this.mAllowCrossDomainRedirect) {
                                this.mURL = this.mConnection.getURL();
                            }
                            if (var7_5 != 206) break block20;
                            var13_14 = this.mConnection.getHeaderField("Content-Range");
                            this.mTotalSize = -1L;
                            if (var13_14 == null || (var14_15 = var13_14.lastIndexOf(47)) < 0) break block21;
                            var15_16 = var13_14.substring(var14_15 + 1);
                            this.mTotalSize = Long.parseLong(var15_16);
                            break block21;
                        }
                        if (++var3_2 > 20) {
                            throw new NoRouteToHostException("Too many redirects: " + var3_2);
                        }
                        break;
                    }
                }
                catch (IOException var4_13) {
                    this.mTotalSize = -1L;
                    this.mInputStream = null;
                    this.mConnection = null;
                    this.mCurrentOffset = -1L;
                    throw var4_13;
                }
                var8_6 = this.mConnection.getRequestMethod();
                if (var7_5 == 307 && !var8_6.equals("GET") && !var8_6.equals("HEAD")) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                var9_7 = this.mConnection.getHeaderField("Location");
                if (var9_7 == null) {
                    throw new NoRouteToHostException("Invalid redirect");
                }
                var10_8 = this.mURL;
                var5_3 = new URL(var10_8, var9_7);
                if (!var5_3.getProtocol().equals("https") && !var5_3.getProtocol().equals("http")) {
                    throw new NoRouteToHostException("Unsupported protocol redirect");
                }
                var11_9 = this.mURL.getProtocol().equals(var5_3.getProtocol());
                if (!this.mAllowCrossProtocolRedirect && !var11_9) {
                    throw new NoRouteToHostException("Cross-protocol redirects are disallowed");
                }
                var12_10 = this.mURL.getHost().equals(var5_3.getHost());
                if (!this.mAllowCrossDomainRedirect && !var12_10) {
                    throw new NoRouteToHostException("Cross-domain redirects are disallowed");
                }
                if (var7_5 == 307) ** GOTO lbl6
                this.mURL = var5_3;
                ** while (true)
            }
            if (var7_5 != 200) {
                throw new IOException();
            }
            this.mTotalSize = this.mConnection.getContentLength();
            break block21;
            catch (NumberFormatException var16_17) {}
        }
        if (var1_1 > 0L && var7_5 != 206) {
            throw new IOException();
        }
        this.mInputStream = new BufferedInputStream(this.mConnection.getInputStream());
        this.mCurrentOffset = var1_1;
    }

    private void teardownConnection() {
        if (this.mConnection != null) {
            this.mInputStream = null;
            this.mConnection.disconnect();
            this.mConnection = null;
            this.mCurrentOffset = -1L;
        }
    }

    @Override
    public IBinder connect(String string2, String string3) {
        try {
            this.disconnect();
            this.mAllowCrossDomainRedirect = true;
            this.mURL = new URL(string2);
            this.mHeaders = this.convertHeaderStringToMap(string3);
            return this.native_getIMemory();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void disconnect() {
        this.teardownConnection();
        this.mHeaders = null;
        this.mURL = null;
    }

    @Override
    protected void finalize() {
        this.native_finalize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getMIMEType() {
        if (this.mConnection != null) return this.mConnection.getContentType();
        try {
            this.seekTo(0L);
        }
        catch (IOException iOException) {
            return "application/octet-stream";
        }
        return this.mConnection.getContentType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getSize() {
        if (this.mConnection != null) return this.mTotalSize;
        try {
            this.seekTo(0L);
        }
        catch (IOException iOException) {
            return -1L;
        }
        return this.mTotalSize;
    }

    @Override
    public String getUri() {
        return this.mURL.toString();
    }

    @Override
    public int readAt(long l, int n) {
        return this.native_readAt(l, n);
    }
}

