/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.graphics.Bitmap;
import android.media.MediaDescription;
import android.media.Rating;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import java.util.Set;

public final class MediaMetadata
implements Parcelable {
    public static final Parcelable.Creator<MediaMetadata> CREATOR;
    private static final SparseArray<String> EDITOR_KEY_MAPPING;
    private static final ArrayMap<String, Integer> METADATA_KEYS_TYPE;
    public static final String METADATA_KEY_ALBUM = "android.media.metadata.ALBUM";
    public static final String METADATA_KEY_ALBUM_ART = "android.media.metadata.ALBUM_ART";
    public static final String METADATA_KEY_ALBUM_ARTIST = "android.media.metadata.ALBUM_ARTIST";
    public static final String METADATA_KEY_ALBUM_ART_URI = "android.media.metadata.ALBUM_ART_URI";
    public static final String METADATA_KEY_ART = "android.media.metadata.ART";
    public static final String METADATA_KEY_ARTIST = "android.media.metadata.ARTIST";
    public static final String METADATA_KEY_ART_URI = "android.media.metadata.ART_URI";
    public static final String METADATA_KEY_AUTHOR = "android.media.metadata.AUTHOR";
    public static final String METADATA_KEY_COMPILATION = "android.media.metadata.COMPILATION";
    public static final String METADATA_KEY_COMPOSER = "android.media.metadata.COMPOSER";
    public static final String METADATA_KEY_DATE = "android.media.metadata.DATE";
    public static final String METADATA_KEY_DISC_NUMBER = "android.media.metadata.DISC_NUMBER";
    public static final String METADATA_KEY_DISPLAY_DESCRIPTION = "android.media.metadata.DISPLAY_DESCRIPTION";
    public static final String METADATA_KEY_DISPLAY_ICON = "android.media.metadata.DISPLAY_ICON";
    public static final String METADATA_KEY_DISPLAY_ICON_URI = "android.media.metadata.DISPLAY_ICON_URI";
    public static final String METADATA_KEY_DISPLAY_SUBTITLE = "android.media.metadata.DISPLAY_SUBTITLE";
    public static final String METADATA_KEY_DISPLAY_TITLE = "android.media.metadata.DISPLAY_TITLE";
    public static final String METADATA_KEY_DURATION = "android.media.metadata.DURATION";
    public static final String METADATA_KEY_GENRE = "android.media.metadata.GENRE";
    public static final String METADATA_KEY_MEDIA_ID = "android.media.metadata.MEDIA_ID";
    public static final String METADATA_KEY_NUM_TRACKS = "android.media.metadata.NUM_TRACKS";
    public static final String METADATA_KEY_RATING = "android.media.metadata.RATING";
    public static final String METADATA_KEY_TITLE = "android.media.metadata.TITLE";
    public static final String METADATA_KEY_TRACK_NUMBER = "android.media.metadata.TRACK_NUMBER";
    public static final String METADATA_KEY_USER_RATING = "android.media.metadata.USER_RATING";
    public static final String METADATA_KEY_WRITER = "android.media.metadata.WRITER";
    public static final String METADATA_KEY_YEAR = "android.media.metadata.YEAR";
    private static final int METADATA_TYPE_BITMAP = 2;
    private static final int METADATA_TYPE_INVALID = -1;
    private static final int METADATA_TYPE_LONG = 0;
    private static final int METADATA_TYPE_RATING = 3;
    private static final int METADATA_TYPE_TEXT = 1;
    private static final String[] PREFERRED_BITMAP_ORDER;
    private static final String[] PREFERRED_DESCRIPTION_ORDER;
    private static final String[] PREFERRED_URI_ORDER;
    private static final String TAG = "MediaMetadata";
    private final Bundle mBundle;
    private MediaDescription mDescription;

    static {
        PREFERRED_DESCRIPTION_ORDER = new String[]{METADATA_KEY_TITLE, METADATA_KEY_ARTIST, METADATA_KEY_ALBUM, METADATA_KEY_ALBUM_ARTIST, METADATA_KEY_WRITER, METADATA_KEY_AUTHOR, METADATA_KEY_COMPOSER};
        PREFERRED_BITMAP_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON, METADATA_KEY_ART, METADATA_KEY_ALBUM_ART};
        PREFERRED_URI_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON_URI, METADATA_KEY_ART_URI, METADATA_KEY_ALBUM_ART_URI};
        METADATA_KEYS_TYPE = new ArrayMap();
        METADATA_KEYS_TYPE.put(METADATA_KEY_TITLE, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ARTIST, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DURATION, 0);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ALBUM, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_AUTHOR, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_WRITER, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_COMPOSER, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_COMPILATION, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DATE, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_YEAR, 0);
        METADATA_KEYS_TYPE.put(METADATA_KEY_GENRE, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_TRACK_NUMBER, 0);
        METADATA_KEYS_TYPE.put(METADATA_KEY_NUM_TRACKS, 0);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISC_NUMBER, 0);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ALBUM_ARTIST, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ART, 2);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ART_URI, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ALBUM_ART, 2);
        METADATA_KEYS_TYPE.put(METADATA_KEY_ALBUM_ART_URI, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_USER_RATING, 3);
        METADATA_KEYS_TYPE.put(METADATA_KEY_RATING, 3);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISPLAY_TITLE, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISPLAY_SUBTITLE, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISPLAY_DESCRIPTION, 1);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISPLAY_ICON, 2);
        METADATA_KEYS_TYPE.put(METADATA_KEY_DISPLAY_ICON_URI, 1);
        EDITOR_KEY_MAPPING = new SparseArray();
        EDITOR_KEY_MAPPING.put(100, METADATA_KEY_ART);
        EDITOR_KEY_MAPPING.put(101, METADATA_KEY_RATING);
        EDITOR_KEY_MAPPING.put(0x10000001, METADATA_KEY_USER_RATING);
        EDITOR_KEY_MAPPING.put(1, METADATA_KEY_ALBUM);
        EDITOR_KEY_MAPPING.put(13, METADATA_KEY_ALBUM_ARTIST);
        EDITOR_KEY_MAPPING.put(2, METADATA_KEY_ARTIST);
        EDITOR_KEY_MAPPING.put(3, METADATA_KEY_AUTHOR);
        EDITOR_KEY_MAPPING.put(0, METADATA_KEY_TRACK_NUMBER);
        EDITOR_KEY_MAPPING.put(4, METADATA_KEY_COMPOSER);
        EDITOR_KEY_MAPPING.put(15, METADATA_KEY_COMPILATION);
        EDITOR_KEY_MAPPING.put(5, METADATA_KEY_DATE);
        EDITOR_KEY_MAPPING.put(14, METADATA_KEY_DISC_NUMBER);
        EDITOR_KEY_MAPPING.put(9, METADATA_KEY_DURATION);
        EDITOR_KEY_MAPPING.put(6, METADATA_KEY_GENRE);
        EDITOR_KEY_MAPPING.put(10, METADATA_KEY_NUM_TRACKS);
        EDITOR_KEY_MAPPING.put(7, METADATA_KEY_TITLE);
        EDITOR_KEY_MAPPING.put(11, METADATA_KEY_WRITER);
        EDITOR_KEY_MAPPING.put(8, METADATA_KEY_YEAR);
        CREATOR = new Parcelable.Creator<MediaMetadata>(){

            @Override
            public MediaMetadata createFromParcel(Parcel parcel) {
                return new MediaMetadata(parcel);
            }

            public MediaMetadata[] newArray(int n) {
                return new MediaMetadata[n];
            }
        };
    }

    private MediaMetadata(Bundle bundle) {
        this.mBundle = new Bundle(bundle);
    }

    private MediaMetadata(Parcel parcel) {
        this.mBundle = parcel.readBundle();
    }

    public static String getKeyFromMetadataEditorKey(int n) {
        return EDITOR_KEY_MAPPING.get(n, null);
    }

    public boolean containsKey(String string2) {
        return this.mBundle.containsKey(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Bitmap getBitmap(String string2) {
        try {
            Bitmap bitmap = (Bitmap)this.mBundle.getParcelable(string2);
            return bitmap;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to retrieve a key as Bitmap.", exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MediaDescription getDescription() {
        Bitmap bitmap;
        if (this.mDescription != null) {
            return this.mDescription;
        }
        String string2 = this.getString(METADATA_KEY_MEDIA_ID);
        CharSequence[] charSequenceArray = new CharSequence[3];
        CharSequence charSequence = this.getText(METADATA_KEY_DISPLAY_TITLE);
        if (!TextUtils.isEmpty(charSequence)) {
            charSequenceArray[0] = charSequence;
            charSequenceArray[1] = this.getText(METADATA_KEY_DISPLAY_SUBTITLE);
            charSequenceArray[2] = this.getText(METADATA_KEY_DISPLAY_DESCRIPTION);
        } else {
            int n = 0;
            int n2 = 0;
            while (n < charSequenceArray.length && n2 < PREFERRED_DESCRIPTION_ORDER.length) {
                String[] stringArray = PREFERRED_DESCRIPTION_ORDER;
                int n3 = n2 + 1;
                CharSequence charSequence2 = this.getText(stringArray[n2]);
                if (!TextUtils.isEmpty(charSequence2)) {
                    int n4 = n + 1;
                    charSequenceArray[n] = charSequence2;
                    n = n4;
                }
                n2 = n3;
            }
        }
        int n = 0;
        while (true) {
            int n5 = PREFERRED_BITMAP_ORDER.length;
            bitmap = null;
            if (n >= n5) break;
            Bitmap bitmap2 = this.getBitmap(PREFERRED_BITMAP_ORDER[n]);
            if (bitmap2 != null) {
                bitmap = bitmap2;
                break;
            }
            ++n;
        }
        int n6 = 0;
        while (true) {
            block12: {
                Uri uri;
                block11: {
                    int n7 = PREFERRED_URI_ORDER.length;
                    uri = null;
                    if (n6 >= n7) break block11;
                    String string3 = this.getString(PREFERRED_URI_ORDER[n6]);
                    if (TextUtils.isEmpty(string3)) break block12;
                    uri = Uri.parse(string3);
                }
                MediaDescription.Builder builder = new MediaDescription.Builder();
                builder.setMediaId(string2);
                builder.setTitle(charSequenceArray[0]);
                builder.setSubtitle(charSequenceArray[1]);
                builder.setDescription(charSequenceArray[2]);
                builder.setIconBitmap(bitmap);
                builder.setIconUri(uri);
                this.mDescription = builder.build();
                return this.mDescription;
            }
            ++n6;
        }
    }

    public long getLong(String string2) {
        return this.mBundle.getLong(string2, 0L);
    }

    public Rating getRating(String string2) {
        try {
            Rating rating = (Rating)this.mBundle.getParcelable(string2);
            return rating;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to retrieve a key as Rating.", exception);
            return null;
        }
    }

    public String getString(String string2) {
        CharSequence charSequence = this.getText(string2);
        if (charSequence != null) {
            return charSequence.toString();
        }
        return null;
    }

    public CharSequence getText(String string2) {
        return this.mBundle.getCharSequence(string2);
    }

    public Set<String> keySet() {
        return this.mBundle.keySet();
    }

    public int size() {
        return this.mBundle.size();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeBundle(this.mBundle);
    }

    public static final class Builder {
        private final Bundle mBundle;

        public Builder() {
            this.mBundle = new Bundle();
        }

        public Builder(MediaMetadata mediaMetadata) {
            this.mBundle = new Bundle(mediaMetadata.mBundle);
        }

        public MediaMetadata build() {
            return new MediaMetadata(this.mBundle);
        }

        public Builder putBitmap(String string2, Bitmap bitmap) {
            if (METADATA_KEYS_TYPE.containsKey(string2) && (Integer)METADATA_KEYS_TYPE.get(string2) != 2) {
                throw new IllegalArgumentException("The " + string2 + " key cannot be used to put a Bitmap");
            }
            this.mBundle.putParcelable(string2, bitmap);
            return this;
        }

        public Builder putLong(String string2, long l) {
            if (METADATA_KEYS_TYPE.containsKey(string2) && (Integer)METADATA_KEYS_TYPE.get(string2) != 0) {
                throw new IllegalArgumentException("The " + string2 + " key cannot be used to put a long");
            }
            this.mBundle.putLong(string2, l);
            return this;
        }

        public Builder putRating(String string2, Rating rating) {
            if (METADATA_KEYS_TYPE.containsKey(string2) && (Integer)METADATA_KEYS_TYPE.get(string2) != 3) {
                throw new IllegalArgumentException("The " + string2 + " key cannot be used to put a Rating");
            }
            this.mBundle.putParcelable(string2, rating);
            return this;
        }

        public Builder putString(String string2, String string3) {
            if (METADATA_KEYS_TYPE.containsKey(string2) && (Integer)METADATA_KEYS_TYPE.get(string2) != 1) {
                throw new IllegalArgumentException("The " + string2 + " key cannot be used to put a String");
            }
            this.mBundle.putCharSequence(string2, string3);
            return this;
        }

        public Builder putText(String string2, CharSequence charSequence) {
            if (METADATA_KEYS_TYPE.containsKey(string2) && (Integer)METADATA_KEYS_TYPE.get(string2) != 1) {
                throw new IllegalArgumentException("The " + string2 + " key cannot be used to put a CharSequence");
            }
            this.mBundle.putCharSequence(string2, charSequence);
            return this;
        }
    }
}

