/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioAttributes;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.AndroidRuntimeException;
import android.util.Log;
import com.android.internal.app.IAppOpsService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class SoundPool {
    private final SoundPoolDelegate mImpl;

    public SoundPool(int n, int n2, int n3) {
        this(n, new AudioAttributes.Builder().setInternalLegacyStreamType(n2).build());
    }

    private SoundPool(int n, AudioAttributes audioAttributes) {
        if (SystemProperties.getBoolean("config.disable_media", false)) {
            this.mImpl = new SoundPoolStub();
            return;
        }
        this.mImpl = new SoundPoolImpl(this, n, audioAttributes);
    }

    public final void autoPause() {
        this.mImpl.autoPause();
    }

    public final void autoResume() {
        this.mImpl.autoResume();
    }

    public int load(Context context, int n, int n2) {
        return this.mImpl.load(context, n, n2);
    }

    public int load(AssetFileDescriptor assetFileDescriptor, int n) {
        return this.mImpl.load(assetFileDescriptor, n);
    }

    public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
        return this.mImpl.load(fileDescriptor, l, l2, n);
    }

    public int load(String string2, int n) {
        return this.mImpl.load(string2, n);
    }

    public final void pause(int n) {
        this.mImpl.pause(n);
    }

    public final int play(int n, float f, float f2, int n2, int n3, float f3) {
        return this.mImpl.play(n, f, f2, n2, n3, f3);
    }

    public final void release() {
        this.mImpl.release();
    }

    public final void resume(int n) {
        this.mImpl.resume(n);
    }

    public final void setLoop(int n, int n2) {
        this.mImpl.setLoop(n, n2);
    }

    public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        this.mImpl.setOnLoadCompleteListener(onLoadCompleteListener);
    }

    public final void setPriority(int n, int n2) {
        this.mImpl.setPriority(n, n2);
    }

    public final void setRate(int n, float f) {
        this.mImpl.setRate(n, f);
    }

    public void setVolume(int n, float f) {
        this.setVolume(n, f, f);
    }

    public final void setVolume(int n, float f, float f2) {
        this.mImpl.setVolume(n, f, f2);
    }

    public final void stop(int n) {
        this.mImpl.stop(n);
    }

    public final boolean unload(int n) {
        return this.mImpl.unload(n);
    }

    public static class Builder {
        private AudioAttributes mAudioAttributes;
        private int mMaxStreams = 1;

        public SoundPool build() {
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new SoundPool(this.mMaxStreams, this.mAudioAttributes);
        }

        public Builder setAudioAttributes(AudioAttributes audioAttributes) throws IllegalArgumentException {
            if (audioAttributes == null) {
                throw new IllegalArgumentException("Invalid null AudioAttributes");
            }
            this.mAudioAttributes = audioAttributes;
            return this;
        }

        public Builder setMaxStreams(int n) throws IllegalArgumentException {
            if (n <= 0) {
                throw new IllegalArgumentException("Strictly positive value required for the maximum number of streams");
            }
            this.mMaxStreams = n;
            return this;
        }
    }

    public static interface OnLoadCompleteListener {
        public void onLoadComplete(SoundPool var1, int var2, int var3);
    }

    static interface SoundPoolDelegate {
        public void autoPause();

        public void autoResume();

        public int load(Context var1, int var2, int var3);

        public int load(AssetFileDescriptor var1, int var2);

        public int load(FileDescriptor var1, long var2, long var4, int var6);

        public int load(String var1, int var2);

        public void pause(int var1);

        public int play(int var1, float var2, float var3, int var4, int var5, float var6);

        public void release();

        public void resume(int var1);

        public void setLoop(int var1, int var2);

        public void setOnLoadCompleteListener(OnLoadCompleteListener var1);

        public void setPriority(int var1, int var2);

        public void setRate(int var1, float var2);

        public void setVolume(int var1, float var2);

        public void setVolume(int var1, float var2, float var3);

        public void stop(int var1);

        public boolean unload(int var1);
    }

    static class SoundPoolImpl
    implements SoundPoolDelegate {
        private static final boolean DEBUG = false;
        private static final int SAMPLE_LOADED = 1;
        private static final String TAG = "SoundPool";
        private final IAppOpsService mAppOps;
        private final AudioAttributes mAttributes;
        private EventHandler mEventHandler;
        private final Object mLock;
        private long mNativeContext;
        private OnLoadCompleteListener mOnLoadCompleteListener;
        private SoundPool mProxy;

        static {
            System.loadLibrary("soundpool");
        }

        public SoundPoolImpl(SoundPool soundPool, int n, AudioAttributes audioAttributes) {
            if (this.native_setup(new WeakReference<SoundPoolImpl>(this), n, audioAttributes) != 0) {
                throw new RuntimeException("Native setup failed");
            }
            this.mLock = new Object();
            this.mProxy = soundPool;
            this.mAttributes = audioAttributes;
            this.mAppOps = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        }

        private final native int _load(FileDescriptor var1, long var2, long var4, int var6);

        private final native int _load(String var1, int var2);

        private final native void _setVolume(int var1, float var2, float var3);

        private boolean isRestricted() {
            try {
                int n = this.mAppOps.checkAudioOperation(28, this.mAttributes.getUsage(), Process.myUid(), ActivityThread.currentPackageName());
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                return bl;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        private final native int native_setup(Object var1, int var2, Object var3);

        /*
         * Enabled aggressive block sorting
         */
        private static void postEventFromNative(Object object, int n, int n2, int n3, Object object2) {
            SoundPoolImpl soundPoolImpl = (SoundPoolImpl)((WeakReference)object).get();
            if (soundPoolImpl == null || soundPoolImpl.mEventHandler == null) {
                return;
            }
            Message message = soundPoolImpl.mEventHandler.obtainMessage(n, n2, n3, object2);
            soundPoolImpl.mEventHandler.sendMessage(message);
        }

        public final native int _play(int var1, float var2, float var3, int var4, int var5, float var6);

        @Override
        public final native void autoPause();

        @Override
        public final native void autoResume();

        protected void finalize() {
            this.release();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int load(Context context, int n, int n2) {
            AssetFileDescriptor assetFileDescriptor = context.getResources().openRawResourceFd(n);
            int n3 = 0;
            if (assetFileDescriptor == null) return n3;
            n3 = this._load(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength(), n2);
            try {
                assetFileDescriptor.close();
            }
            catch (IOException iOException) {
                return n3;
            }
            return n3;
        }

        @Override
        public int load(AssetFileDescriptor assetFileDescriptor, int n) {
            if (assetFileDescriptor != null) {
                long l = assetFileDescriptor.getLength();
                if (l < 0L) {
                    throw new AndroidRuntimeException("no length for fd");
                }
                return this._load(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), l, n);
            }
            return 0;
        }

        @Override
        public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return this._load(fileDescriptor, l, l2, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int load(String string2, int n) {
            ParcelFileDescriptor parcelFileDescriptor;
            File file;
            if (string2.startsWith("http:")) {
                return this._load(string2, n);
            }
            int n2 = 0;
            try {
                file = new File(string2);
                parcelFileDescriptor = ParcelFileDescriptor.open(file, 0x10000000);
                n2 = 0;
                if (parcelFileDescriptor == null) return n2;
            }
            catch (IOException iOException) {
                Log.e(TAG, "error loading " + string2);
                return n2;
            }
            n2 = this._load(parcelFileDescriptor.getFileDescriptor(), 0L, file.length(), n);
            parcelFileDescriptor.close();
            return n2;
        }

        @Override
        public final native void pause(int var1);

        @Override
        public final int play(int n, float f, float f2, int n2, int n3, float f3) {
            if (this.isRestricted()) {
                f2 = 0.0f;
                f = 0.0f;
            }
            return this._play(n, f, f2, n2, n3, f3);
        }

        @Override
        public final native void release();

        @Override
        public final native void resume(int var1);

        @Override
        public final native void setLoop(int var1, int var2);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
            Object object = this.mLock;
            synchronized (object) {
                Looper looper;
                Looper looper2;
                this.mEventHandler = onLoadCompleteListener != null ? ((looper2 = Looper.myLooper()) != null ? new EventHandler(this.mProxy, looper2) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this.mProxy, looper) : null)) : null;
                this.mOnLoadCompleteListener = onLoadCompleteListener;
                return;
            }
        }

        @Override
        public final native void setPriority(int var1, int var2);

        @Override
        public final native void setRate(int var1, float var2);

        @Override
        public void setVolume(int n, float f) {
            this.setVolume(n, f, f);
        }

        @Override
        public final void setVolume(int n, float f, float f2) {
            if (this.isRestricted()) {
                return;
            }
            this._setVolume(n, f, f2);
        }

        @Override
        public final native void stop(int var1);

        @Override
        public final native boolean unload(int var1);

        private class EventHandler
        extends Handler {
            private SoundPool mSoundPool;

            public EventHandler(SoundPool soundPool, Looper looper) {
                super(looper);
                this.mSoundPool = soundPool;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        Log.e(SoundPoolImpl.TAG, "Unknown message type " + message.what);
                        return;
                    }
                    case 1: 
                }
                Object object = SoundPoolImpl.this.mLock;
                synchronized (object) {
                    if (SoundPoolImpl.this.mOnLoadCompleteListener != null) {
                        SoundPoolImpl.this.mOnLoadCompleteListener.onLoadComplete(this.mSoundPool, message.arg1, message.arg2);
                    }
                    return;
                }
            }
        }
    }

    static class SoundPoolStub
    implements SoundPoolDelegate {
        @Override
        public final void autoPause() {
        }

        @Override
        public final void autoResume() {
        }

        @Override
        public int load(Context context, int n, int n2) {
            return 0;
        }

        @Override
        public int load(AssetFileDescriptor assetFileDescriptor, int n) {
            return 0;
        }

        @Override
        public int load(FileDescriptor fileDescriptor, long l, long l2, int n) {
            return 0;
        }

        @Override
        public int load(String string2, int n) {
            return 0;
        }

        @Override
        public final void pause(int n) {
        }

        @Override
        public final int play(int n, float f, float f2, int n2, int n3, float f3) {
            return 0;
        }

        @Override
        public final void release() {
        }

        @Override
        public final void resume(int n) {
        }

        @Override
        public final void setLoop(int n, int n2) {
        }

        @Override
        public void setOnLoadCompleteListener(OnLoadCompleteListener onLoadCompleteListener) {
        }

        @Override
        public final void setPriority(int n, int n2) {
        }

        @Override
        public final void setRate(int n, float f) {
        }

        @Override
        public void setVolume(int n, float f) {
        }

        @Override
        public final void setVolume(int n, float f, float f2) {
        }

        @Override
        public final void stop(int n) {
        }

        @Override
        public final boolean unload(int n) {
            return true;
        }
    }
}

