/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaFormat;
import android.media.SubtitleTrack;
import android.media.TtmlCue;
import android.media.TtmlNode;
import android.media.TtmlNodeListener;
import android.media.TtmlParser;
import android.media.TtmlRenderingWidget;
import android.media.TtmlUtils;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParserException;

class TtmlTrack
extends SubtitleTrack
implements TtmlNodeListener {
    private static final String TAG = "TtmlTrack";
    private Long mCurrentRunID;
    private final TtmlParser mParser = new TtmlParser(this);
    private String mParsingData;
    private final TtmlRenderingWidget mRenderingWidget;
    private TtmlNode mRootNode;
    private final TreeSet<Long> mTimeEvents;
    private final LinkedList<TtmlNode> mTtmlNodes = new LinkedList();

    TtmlTrack(TtmlRenderingWidget ttmlRenderingWidget, MediaFormat mediaFormat) {
        super(mediaFormat);
        this.mTimeEvents = new TreeSet();
        this.mRenderingWidget = ttmlRenderingWidget;
        this.mParsingData = "";
    }

    private void addTimeEvents(TtmlNode ttmlNode) {
        this.mTimeEvents.add(ttmlNode.mStartTimeMs);
        this.mTimeEvents.add(ttmlNode.mEndTimeMs);
        for (int i = 0; i < ttmlNode.mChildren.size(); ++i) {
            this.addTimeEvents(ttmlNode.mChildren.get(i));
        }
    }

    private List<TtmlNode> getActiveNodes(long l, long l2) {
        ArrayList<TtmlNode> arrayList = new ArrayList<TtmlNode>();
        for (int i = 0; i < this.mTtmlNodes.size(); ++i) {
            TtmlNode ttmlNode = this.mTtmlNodes.get(i);
            if (!ttmlNode.isActive(l, l2)) continue;
            arrayList.add(ttmlNode);
        }
        return arrayList;
    }

    public TtmlCue getNextResult() {
        while (this.mTimeEvents.size() >= 2) {
            long l;
            long l2 = this.mTimeEvents.pollFirst();
            if (this.getActiveNodes(l2, l = this.mTimeEvents.first().longValue()).isEmpty()) continue;
            return new TtmlCue(l2, l, TtmlUtils.applySpacePolicy(TtmlUtils.extractText(this.mRootNode, l2, l), false), TtmlUtils.extractTtmlFragment(this.mRootNode, l2, l));
        }
        return null;
    }

    @Override
    public TtmlRenderingWidget getRenderingWidget() {
        return this.mRenderingWidget;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onData(byte[] byArray, boolean bl, long l) {
        String string2;
        try {
            string2 = new String(byArray, "UTF-8");
            TtmlParser ttmlParser = this.mParser;
            synchronized (ttmlParser) {
                if (this.mCurrentRunID != null && l != this.mCurrentRunID) {
                    throw new IllegalStateException("Run #" + this.mCurrentRunID + " in progress.  Cannot process run #" + l);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.w(TAG, "subtitle data is not UTF-8 encoded: " + unsupportedEncodingException);
            return;
        }
        {
            this.mCurrentRunID = l;
            this.mParsingData = this.mParsingData + string2;
            if (bl) {
                try {
                    this.mParser.parse(this.mParsingData, this.mCurrentRunID);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    xmlPullParserException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.finishedRun(l);
                this.mParsingData = "";
                this.mCurrentRunID = null;
            }
            return;
        }
    }

    @Override
    public void onRootNodeParsed(TtmlNode ttmlNode) {
        TtmlCue ttmlCue;
        this.mRootNode = ttmlNode;
        while ((ttmlCue = this.getNextResult()) != null) {
            this.addCue(ttmlCue);
        }
        this.mRootNode = null;
        this.mTtmlNodes.clear();
        this.mTimeEvents.clear();
    }

    @Override
    public void onTtmlNodeParsed(TtmlNode ttmlNode) {
        this.mTtmlNodes.addLast(ttmlNode);
        this.addTimeEvents(ttmlNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateView(Vector<SubtitleTrack.Cue> vector) {
        if (!this.mVisible) {
            return;
        }
        if (this.DEBUG && this.mTimeProvider != null) {
            try {
                Log.d(TAG, "at " + this.mTimeProvider.getCurrentTimeUs(false, true) / 1000L + " ms the active cues are:");
            }
            catch (IllegalStateException illegalStateException) {
                Log.d(TAG, "at (illegal state) the active cues are:");
            }
        }
        this.mRenderingWidget.setActiveCues(vector);
    }
}

