/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.content.ComponentName;
import android.content.ContentUris;
import android.net.Uri;
import android.provider.BaseColumns;
import android.util.ArraySet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TvContract {
    public static final String AUTHORITY = "android.media.tv";
    public static final String PARAM_BROWSABLE_ONLY = "browsable_only";
    public static final String PARAM_CANONICAL_GENRE = "canonical_genre";
    public static final String PARAM_CHANNEL = "channel";
    public static final String PARAM_END_TIME = "end_time";
    public static final String PARAM_INPUT = "input";
    public static final String PARAM_START_TIME = "start_time";
    private static final String PATH_CHANNEL = "channel";
    private static final String PATH_PASSTHROUGH = "passthrough";
    private static final String PATH_PROGRAM = "program";

    private TvContract() {
    }

    public static final Uri buildChannelLogoUri(long l) {
        return TvContract.buildChannelLogoUri(TvContract.buildChannelUri(l));
    }

    public static final Uri buildChannelLogoUri(Uri uri) {
        if (!TvContract.isChannelUriForTunerInput(uri)) {
            throw new IllegalArgumentException("Not a channel: " + uri);
        }
        return Uri.withAppendedPath(uri, "logo");
    }

    public static final Uri buildChannelUri(long l) {
        return ContentUris.withAppendedId(Channels.CONTENT_URI, l);
    }

    public static final Uri buildChannelUriForPassthroughInput(String string2) {
        return new Uri.Builder().scheme("content").authority(AUTHORITY).appendPath(PATH_PASSTHROUGH).appendPath(string2).build();
    }

    public static final Uri buildChannelsUriForInput(String string2) {
        return TvContract.buildChannelsUriForInput(string2, false);
    }

    public static final Uri buildChannelsUriForInput(String string2, String string3, boolean bl) {
        if (string3 == null) {
            return TvContract.buildChannelsUriForInput(string2, bl);
        }
        if (!Programs.Genres.isCanonical(string3)) {
            throw new IllegalArgumentException("Not a canonical genre: '" + string3 + "'");
        }
        return TvContract.buildChannelsUriForInput(string2, bl).buildUpon().appendQueryParameter(PARAM_CANONICAL_GENRE, string3).build();
    }

    public static final Uri buildChannelsUriForInput(String string2, boolean bl) {
        Uri.Builder builder = Channels.CONTENT_URI.buildUpon();
        if (string2 != null) {
            builder.appendQueryParameter(PARAM_INPUT, string2);
        }
        return builder.appendQueryParameter(PARAM_BROWSABLE_ONLY, String.valueOf(bl)).build();
    }

    public static final String buildInputId(ComponentName componentName) {
        return componentName.flattenToShortString();
    }

    public static final Uri buildProgramUri(long l) {
        return ContentUris.withAppendedId(Programs.CONTENT_URI, l);
    }

    public static final Uri buildProgramsUriForChannel(long l) {
        return Programs.CONTENT_URI.buildUpon().appendQueryParameter("channel", String.valueOf(l)).build();
    }

    public static final Uri buildProgramsUriForChannel(long l, long l2, long l3) {
        return TvContract.buildProgramsUriForChannel(l).buildUpon().appendQueryParameter(PARAM_START_TIME, String.valueOf(l2)).appendQueryParameter(PARAM_END_TIME, String.valueOf(l3)).build();
    }

    public static final Uri buildProgramsUriForChannel(Uri uri) {
        if (!TvContract.isChannelUriForTunerInput(uri)) {
            throw new IllegalArgumentException("Not a channel: " + uri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(uri));
    }

    public static final Uri buildProgramsUriForChannel(Uri uri, long l, long l2) {
        if (!TvContract.isChannelUriForTunerInput(uri)) {
            throw new IllegalArgumentException("Not a channel: " + uri);
        }
        return TvContract.buildProgramsUriForChannel(ContentUris.parseId(uri), l, l2);
    }

    public static final Uri buildWatchedProgramUri(long l) {
        return ContentUris.withAppendedId(WatchedPrograms.CONTENT_URI, l);
    }

    public static final boolean isChannelUri(Uri uri) {
        return TvContract.isChannelUriForTunerInput(uri) || TvContract.isChannelUriForPassthroughInput(uri);
    }

    public static final boolean isChannelUriForPassthroughInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, PATH_PASSTHROUGH);
    }

    public static final boolean isChannelUriForTunerInput(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, "channel");
    }

    public static final boolean isProgramUri(Uri uri) {
        return TvContract.isTvUri(uri) && TvContract.isTwoSegmentUriStartingWith(uri, PATH_PROGRAM);
    }

    private static final boolean isTvUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme()) && AUTHORITY.equals(uri.getAuthority());
    }

    private static final boolean isTwoSegmentUriStartingWith(Uri uri, String string2) {
        List<String> list = uri.getPathSegments();
        int n = list.size();
        boolean bl = false;
        if (n == 2) {
            boolean bl2 = string2.equals(list.get(0));
            bl = false;
            if (bl2) {
                bl = true;
            }
        }
        return bl;
    }

    public static interface BaseTvColumns
    extends BaseColumns {
        public static final String COLUMN_PACKAGE_NAME = "package_name";
    }

    public static final class Channels
    implements BaseTvColumns {
        public static final String COLUMN_BROWSABLE = "browsable";
        public static final String COLUMN_DESCRIPTION = "description";
        public static final String COLUMN_DISPLAY_NAME = "display_name";
        public static final String COLUMN_DISPLAY_NUMBER = "display_number";
        public static final String COLUMN_INPUT_ID = "input_id";
        public static final String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static final String COLUMN_LOCKED = "locked";
        public static final String COLUMN_NETWORK_AFFILIATION = "network_affiliation";
        public static final String COLUMN_ORIGINAL_NETWORK_ID = "original_network_id";
        public static final String COLUMN_SEARCHABLE = "searchable";
        public static final String COLUMN_SERVICE_ID = "service_id";
        public static final String COLUMN_SERVICE_TYPE = "service_type";
        public static final String COLUMN_TRANSPORT_STREAM_ID = "transport_stream_id";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_VERSION_NUMBER = "version_number";
        public static final String COLUMN_VIDEO_FORMAT = "video_format";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/channel";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/channel";
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/channel");
        public static final String SERVICE_TYPE_AUDIO = "SERVICE_TYPE_AUDIO";
        public static final String SERVICE_TYPE_AUDIO_VIDEO = "SERVICE_TYPE_AUDIO_VIDEO";
        public static final String SERVICE_TYPE_OTHER = "SERVICE_TYPE_OTHER";
        public static final String TYPE_1SEG = "TYPE_1SEG";
        public static final String TYPE_ATSC_C = "TYPE_ATSC_C";
        public static final String TYPE_ATSC_M_H = "TYPE_ATSC_M_H";
        public static final String TYPE_ATSC_T = "TYPE_ATSC_T";
        public static final String TYPE_CMMB = "TYPE_CMMB";
        public static final String TYPE_DTMB = "TYPE_DTMB";
        public static final String TYPE_DVB_C = "TYPE_DVB_C";
        public static final String TYPE_DVB_C2 = "TYPE_DVB_C2";
        public static final String TYPE_DVB_H = "TYPE_DVB_H";
        public static final String TYPE_DVB_S = "TYPE_DVB_S";
        public static final String TYPE_DVB_S2 = "TYPE_DVB_S2";
        public static final String TYPE_DVB_SH = "TYPE_DVB_SH";
        public static final String TYPE_DVB_T = "TYPE_DVB_T";
        public static final String TYPE_DVB_T2 = "TYPE_DVB_T2";
        public static final String TYPE_ISDB_C = "TYPE_ISDB_C";
        public static final String TYPE_ISDB_S = "TYPE_ISDB_S";
        public static final String TYPE_ISDB_T = "TYPE_ISDB_T";
        public static final String TYPE_ISDB_TB = "TYPE_ISDB_TB";
        public static final String TYPE_NTSC = "TYPE_NTSC";
        public static final String TYPE_OTHER = "TYPE_OTHER";
        public static final String TYPE_PAL = "TYPE_PAL";
        public static final String TYPE_SECAM = "TYPE_SECAM";
        public static final String TYPE_S_DMB = "TYPE_S_DMB";
        public static final String TYPE_T_DMB = "TYPE_T_DMB";
        public static final String VIDEO_FORMAT_1080I = "VIDEO_FORMAT_1080I";
        public static final String VIDEO_FORMAT_1080P = "VIDEO_FORMAT_1080P";
        public static final String VIDEO_FORMAT_2160P = "VIDEO_FORMAT_2160P";
        public static final String VIDEO_FORMAT_240P = "VIDEO_FORMAT_240P";
        public static final String VIDEO_FORMAT_360P = "VIDEO_FORMAT_360P";
        public static final String VIDEO_FORMAT_4320P = "VIDEO_FORMAT_4320P";
        public static final String VIDEO_FORMAT_480I = "VIDEO_FORMAT_480I";
        public static final String VIDEO_FORMAT_480P = "VIDEO_FORMAT_480P";
        public static final String VIDEO_FORMAT_576I = "VIDEO_FORMAT_576I";
        public static final String VIDEO_FORMAT_576P = "VIDEO_FORMAT_576P";
        public static final String VIDEO_FORMAT_720P = "VIDEO_FORMAT_720P";
        private static final Map<String, String> VIDEO_FORMAT_TO_RESOLUTION_MAP = new HashMap<String, String>();
        public static final String VIDEO_RESOLUTION_ED = "VIDEO_RESOLUTION_ED";
        public static final String VIDEO_RESOLUTION_FHD = "VIDEO_RESOLUTION_FHD";
        public static final String VIDEO_RESOLUTION_HD = "VIDEO_RESOLUTION_HD";
        public static final String VIDEO_RESOLUTION_SD = "VIDEO_RESOLUTION_SD";
        public static final String VIDEO_RESOLUTION_UHD = "VIDEO_RESOLUTION_UHD";

        static {
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_480I, VIDEO_RESOLUTION_SD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_480P, VIDEO_RESOLUTION_ED);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_576I, VIDEO_RESOLUTION_SD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_576P, VIDEO_RESOLUTION_ED);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_720P, VIDEO_RESOLUTION_HD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_1080I, VIDEO_RESOLUTION_HD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_1080P, VIDEO_RESOLUTION_FHD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_2160P, VIDEO_RESOLUTION_UHD);
            VIDEO_FORMAT_TO_RESOLUTION_MAP.put(VIDEO_FORMAT_4320P, VIDEO_RESOLUTION_UHD);
        }

        private Channels() {
        }

        public static final String getVideoResolution(String string2) {
            return VIDEO_FORMAT_TO_RESOLUTION_MAP.get(string2);
        }

        public static final class Logo {
            public static final String CONTENT_DIRECTORY = "logo";

            private Logo() {
            }
        }
    }

    public static final class Programs
    implements BaseTvColumns {
        public static final String COLUMN_AUDIO_LANGUAGE = "audio_language";
        public static final String COLUMN_BROADCAST_GENRE = "broadcast_genre";
        public static final String COLUMN_CANONICAL_GENRE = "canonical_genre";
        public static final String COLUMN_CHANNEL_ID = "channel_id";
        public static final String COLUMN_CONTENT_RATING = "content_rating";
        public static final String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static final String COLUMN_EPISODE_NUMBER = "episode_number";
        public static final String COLUMN_EPISODE_TITLE = "episode_title";
        public static final String COLUMN_INTERNAL_PROVIDER_DATA = "internal_provider_data";
        public static final String COLUMN_LONG_DESCRIPTION = "long_description";
        public static final String COLUMN_POSTER_ART_URI = "poster_art_uri";
        public static final String COLUMN_SEASON_NUMBER = "season_number";
        public static final String COLUMN_SHORT_DESCRIPTION = "short_description";
        public static final String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static final String COLUMN_THUMBNAIL_URI = "thumbnail_uri";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_VERSION_NUMBER = "version_number";
        public static final String COLUMN_VIDEO_HEIGHT = "video_height";
        public static final String COLUMN_VIDEO_WIDTH = "video_width";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/program";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/program";
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/program");

        private Programs() {
        }

        public static final class Genres {
            public static final String ANIMAL_WILDLIFE = "ANIMAL_WILDLIFE";
            private static final ArraySet<String> CANONICAL_GENRES = new ArraySet();
            public static final String COMEDY = "COMEDY";
            public static final String DRAMA = "DRAMA";
            public static final String EDUCATION = "EDUCATION";
            public static final String FAMILY_KIDS = "FAMILY_KIDS";
            public static final String GAMING = "GAMING";
            public static final String MOVIES = "MOVIES";
            public static final String NEWS = "NEWS";
            public static final String SHOPPING = "SHOPPING";
            public static final String SPORTS = "SPORTS";
            public static final String TRAVEL = "TRAVEL";

            static {
                CANONICAL_GENRES.add(FAMILY_KIDS);
                CANONICAL_GENRES.add(SPORTS);
                CANONICAL_GENRES.add(SHOPPING);
                CANONICAL_GENRES.add(MOVIES);
                CANONICAL_GENRES.add(COMEDY);
                CANONICAL_GENRES.add(TRAVEL);
                CANONICAL_GENRES.add(DRAMA);
                CANONICAL_GENRES.add(EDUCATION);
                CANONICAL_GENRES.add(ANIMAL_WILDLIFE);
                CANONICAL_GENRES.add(NEWS);
                CANONICAL_GENRES.add(GAMING);
            }

            private Genres() {
            }

            public static String[] decode(String string2) {
                return string2.split("\\s*,\\s*");
            }

            public static String encode(String ... stringArray) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = "";
                for (String string3 : stringArray) {
                    stringBuilder.append(string2).append(string3);
                    string2 = ",";
                }
                return stringBuilder.toString();
            }

            public static boolean isCanonical(String string2) {
                return CANONICAL_GENRES.contains(string2);
            }
        }
    }

    public static final class WatchedPrograms
    implements BaseTvColumns {
        public static final String COLUMN_CHANNEL_ID = "channel_id";
        public static final String COLUMN_DESCRIPTION = "description";
        public static final String COLUMN_END_TIME_UTC_MILLIS = "end_time_utc_millis";
        public static final String COLUMN_INTERNAL_SESSION_TOKEN = "session_token";
        public static final String COLUMN_INTERNAL_TUNE_PARAMS = "tune_params";
        public static final String COLUMN_START_TIME_UTC_MILLIS = "start_time_utc_millis";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_WATCH_END_TIME_UTC_MILLIS = "watch_end_time_utc_millis";
        public static final String COLUMN_WATCH_START_TIME_UTC_MILLIS = "watch_start_time_utc_millis";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/watched_program";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/watched_program";
        public static final Uri CONTENT_URI = Uri.parse("content://android.media.tv/watched_program");

        private WatchedPrograms() {
        }
    }
}

