/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.graphics.Rect;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManager;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.TvContentRating;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pools;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.View;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TvInputManager {
    public static final String ACTION_BLOCKED_RATINGS_CHANGED = "android.media.tv.action.BLOCKED_RATINGS_CHANGED";
    public static final String ACTION_PARENTAL_CONTROLS_ENABLED_CHANGED = "android.media.tv.action.PARENTAL_CONTROLS_ENABLED_CHANGED";
    public static final String ACTION_QUERY_CONTENT_RATING_SYSTEMS = "android.media.tv.action.QUERY_CONTENT_RATING_SYSTEMS";
    public static final int INPUT_STATE_CONNECTED = 0;
    public static final int INPUT_STATE_CONNECTED_STANDBY = 1;
    public static final int INPUT_STATE_DISCONNECTED = 2;
    public static final String META_DATA_CONTENT_RATING_SYSTEMS = "android.media.tv.metadata.CONTENT_RATING_SYSTEMS";
    private static final String TAG = "TvInputManager";
    public static final int VIDEO_UNAVAILABLE_REASON_BUFFERING = 3;
    static final int VIDEO_UNAVAILABLE_REASON_END = 3;
    static final int VIDEO_UNAVAILABLE_REASON_START = 0;
    public static final int VIDEO_UNAVAILABLE_REASON_TUNING = 1;
    public static final int VIDEO_UNAVAILABLE_REASON_UNKNOWN = 0;
    public static final int VIDEO_UNAVAILABLE_REASON_WEAK_SIGNAL = 2;
    private final List<TvInputCallbackRecord> mCallbackRecords;
    private final ITvInputClient mClient;
    private final Object mLock = new Object();
    private final ITvInputManagerCallback mManagerCallback;
    private int mNextSeq;
    private final ITvInputManager mService;
    private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
    private final Map<String, Integer> mStateMap;
    private final int mUserId;

    public TvInputManager(ITvInputManager iTvInputManager, int n) {
        this.mCallbackRecords = new LinkedList<TvInputCallbackRecord>();
        this.mStateMap = new ArrayMap<String, Integer>();
        this.mSessionCallbackRecordMap = new SparseArray();
        this.mService = iTvInputManager;
        this.mUserId = n;
        this.mClient = new ITvInputClient.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onChannelRetuned(Uri uri, int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postChannelRetuned(uri);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onContentAllowed(int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postContentAllowed();
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onContentBlocked(String string2, int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postContentBlocked(TvContentRating.unflattenFromString(string2));
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onLayoutSurface(int n, int n2, int n3, int n4, int n5) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n5);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n5);
                        return;
                    }
                    sessionCallbackRecord.postLayoutSurface(n, n2, n3, n4);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSessionCreated(String string2, IBinder iBinder, InputChannel inputChannel, int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for " + iBinder);
                        return;
                    }
                    Session session = null;
                    if (iBinder != null) {
                        session = new Session(iBinder, inputChannel, TvInputManager.this.mService, TvInputManager.this.mUserId, n, TvInputManager.this.mSessionCallbackRecordMap);
                    }
                    sessionCallbackRecord.postSessionCreated(session);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSessionEvent(String string2, Bundle bundle, int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postSessionEvent(string2, bundle);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSessionReleased(int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    TvInputManager.this.mSessionCallbackRecordMap.delete(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq:" + n);
                        return;
                    }
                    sessionCallbackRecord.mSession.releaseInternal();
                    sessionCallbackRecord.postSessionReleased();
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onTrackSelected(int n, String string2, int n2) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n2);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n2);
                        return;
                    }
                    sessionCallbackRecord.postTrackSelected(n, string2);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onTracksChanged(List<TvTrackInfo> list, int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postTracksChanged(list);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onVideoAvailable(int n) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n);
                        return;
                    }
                    sessionCallbackRecord.postVideoAvailable();
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onVideoUnavailable(int n, int n2) {
                SparseArray sparseArray = TvInputManager.this.mSessionCallbackRecordMap;
                synchronized (sparseArray) {
                    SessionCallbackRecord sessionCallbackRecord = (SessionCallbackRecord)TvInputManager.this.mSessionCallbackRecordMap.get(n2);
                    if (sessionCallbackRecord == null) {
                        Log.e(TvInputManager.TAG, "Callback not found for seq " + n2);
                        return;
                    }
                    sessionCallbackRecord.postVideoUnavailable(n);
                    return;
                }
            }
        };
        this.mManagerCallback = new ITvInputManagerCallback.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onInputAdded(String string2) {
                Object object = TvInputManager.this.mLock;
                synchronized (object) {
                    TvInputManager.this.mStateMap.put(string2, 0);
                    Iterator iterator = TvInputManager.this.mCallbackRecords.iterator();
                    while (iterator.hasNext()) {
                        ((TvInputCallbackRecord)iterator.next()).postInputAdded(string2);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onInputRemoved(String string2) {
                Object object = TvInputManager.this.mLock;
                synchronized (object) {
                    TvInputManager.this.mStateMap.remove(string2);
                    Iterator iterator = TvInputManager.this.mCallbackRecords.iterator();
                    while (iterator.hasNext()) {
                        ((TvInputCallbackRecord)iterator.next()).postInputRemoved(string2);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onInputStateChanged(String string2, int n) {
                Object object = TvInputManager.this.mLock;
                synchronized (object) {
                    TvInputManager.this.mStateMap.put(string2, n);
                    Iterator iterator = TvInputManager.this.mCallbackRecords.iterator();
                    while (iterator.hasNext()) {
                        ((TvInputCallbackRecord)iterator.next()).postInputStateChanged(string2, n);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onInputUpdated(String string2) {
                Object object = TvInputManager.this.mLock;
                synchronized (object) {
                    Iterator iterator = TvInputManager.this.mCallbackRecords.iterator();
                    while (iterator.hasNext()) {
                        ((TvInputCallbackRecord)iterator.next()).postInputUpdated(string2);
                    }
                    return;
                }
            }
        };
        try {
            if (this.mService != null) {
                this.mService.registerCallback(this.mManagerCallback, this.mUserId);
            }
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "mService.registerCallback failed: " + remoteException);
            return;
        }
    }

    public Hardware acquireTvInputHardware(int n, final HardwareCallback hardwareCallback, TvInputInfo tvInputInfo) {
        try {
            Hardware hardware = new Hardware(this.mService.acquireTvInputHardware(n, new ITvInputHardwareCallback.Stub(){

                @Override
                public void onReleased() {
                    hardwareCallback.onReleased();
                }

                @Override
                public void onStreamConfigChanged(TvStreamConfig[] tvStreamConfigArray) {
                    hardwareCallback.onStreamConfigChanged(tvStreamConfigArray);
                }
            }, tvInputInfo, this.mUserId));
            return hardware;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void addBlockedRating(TvContentRating tvContentRating) {
        if (tvContentRating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            this.mService.addBlockedRating(tvContentRating.flattenToString(), this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean captureFrame(String string2, Surface surface, TvStreamConfig tvStreamConfig) {
        try {
            boolean bl = this.mService.captureFrame(string2, surface, tvStreamConfig, this.mUserId);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createSession(String string2, SessionCallback sessionCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (sessionCallback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        SessionCallbackRecord sessionCallbackRecord = new SessionCallbackRecord(sessionCallback, handler);
        SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
        synchronized (sparseArray) {
            int n = this.mNextSeq;
            this.mNextSeq = n + 1;
            this.mSessionCallbackRecordMap.put(n, sessionCallbackRecord);
            try {
                this.mService.createSession(this.mClient, string2, n, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    public List<TvStreamConfig> getAvailableTvStreamConfigList(String string2) {
        try {
            List<TvStreamConfig> list = this.mService.getAvailableTvStreamConfigList(string2, this.mUserId);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public List<TvContentRating> getBlockedRatings() {
        ArrayList<TvContentRating> arrayList;
        try {
            arrayList = new ArrayList<TvContentRating>();
            Iterator<String> iterator = this.mService.getBlockedRatings(this.mUserId).iterator();
            while (iterator.hasNext()) {
                arrayList.add(TvContentRating.unflattenFromString(iterator.next()));
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        return arrayList;
    }

    public List<TvInputHardwareInfo> getHardwareList() {
        try {
            List<TvInputHardwareInfo> list = this.mService.getHardwareList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInputState(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("inputId cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            Integer n = this.mStateMap.get(string2);
            if (n != null) return n;
            throw new IllegalArgumentException("Unrecognized input ID: " + string2);
        }
    }

    public List<TvContentRatingSystemInfo> getTvContentRatingSystemList() {
        try {
            List<TvContentRatingSystemInfo> list = this.mService.getTvContentRatingSystemList(this.mUserId);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public TvInputInfo getTvInputInfo(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("inputId cannot be null");
        }
        try {
            TvInputInfo tvInputInfo = this.mService.getTvInputInfo(string2, this.mUserId);
            return tvInputInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public List<TvInputInfo> getTvInputList() {
        try {
            List<TvInputInfo> list = this.mService.getTvInputList(this.mUserId);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean isParentalControlsEnabled() {
        try {
            boolean bl = this.mService.isParentalControlsEnabled(this.mUserId);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean isRatingBlocked(TvContentRating tvContentRating) {
        if (tvContentRating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            boolean bl = this.mService.isRatingBlocked(tvContentRating.flattenToString(), this.mUserId);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean isSingleSessionActive() {
        try {
            boolean bl = this.mService.isSingleSessionActive(this.mUserId);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerCallback(TvInputCallback tvInputCallback, Handler handler) {
        if (tvInputCallback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackRecords.add(new TvInputCallbackRecord(tvInputCallback, handler));
            return;
        }
    }

    public void releaseTvInputHardware(int n, Hardware hardware) {
        try {
            this.mService.releaseTvInputHardware(n, hardware.getInterface(), this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void removeBlockedRating(TvContentRating tvContentRating) {
        if (tvContentRating == null) {
            throw new IllegalArgumentException("rating cannot be null");
        }
        try {
            this.mService.removeBlockedRating(tvContentRating.flattenToString(), this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setParentalControlsEnabled(boolean bl) {
        try {
            this.mService.setParentalControlsEnabled(bl, this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterCallback(TvInputCallback tvInputCallback) {
        if (tvInputCallback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            Iterator<TvInputCallbackRecord> iterator = this.mCallbackRecords.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getCallback() != tvInputCallback) continue;
                iterator.remove();
                break;
            }
            return;
        }
    }

    public static final class Hardware {
        private final ITvInputHardware mInterface;

        private Hardware(ITvInputHardware iTvInputHardware) {
            this.mInterface = iTvInputHardware;
        }

        private ITvInputHardware getInterface() {
            return this.mInterface;
        }

        public boolean dispatchKeyEventToHdmi(KeyEvent keyEvent) {
            try {
                boolean bl = this.mInterface.dispatchKeyEventToHdmi(keyEvent);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void overrideAudioSink(int n, String string2, int n2, int n3, int n4) {
            try {
                this.mInterface.overrideAudioSink(n, string2, n2, n3, n4);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void setStreamVolume(float f) {
            try {
                this.mInterface.setStreamVolume(f);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public boolean setSurface(Surface surface, TvStreamConfig tvStreamConfig) {
            try {
                boolean bl = this.mInterface.setSurface(surface, tvStreamConfig);
                return bl;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    public static abstract class HardwareCallback {
        public abstract void onReleased();

        public abstract void onStreamConfigChanged(TvStreamConfig[] var1);
    }

    public static final class Session {
        static final int DISPATCH_HANDLED = 1;
        static final int DISPATCH_IN_PROGRESS = -1;
        static final int DISPATCH_NOT_HANDLED = 0;
        private static final long INPUT_SESSION_NOT_RESPONDING_TIMEOUT = 2500L;
        private final List<TvTrackInfo> mAudioTracks;
        private InputChannel mChannel;
        private final InputEventHandler mHandler = new InputEventHandler(Looper.getMainLooper());
        private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
        private final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
        private String mSelectedAudioTrackId;
        private String mSelectedSubtitleTrackId;
        private String mSelectedVideoTrackId;
        private TvInputEventSender mSender;
        private final int mSeq;
        private final ITvInputManager mService;
        private final SparseArray<SessionCallbackRecord> mSessionCallbackRecordMap;
        private final List<TvTrackInfo> mSubtitleTracks;
        private IBinder mToken;
        private final int mUserId;
        private final List<TvTrackInfo> mVideoTracks;

        private Session(IBinder iBinder, InputChannel inputChannel, ITvInputManager iTvInputManager, int n, int n2, SparseArray<SessionCallbackRecord> sparseArray) {
            this.mAudioTracks = new ArrayList<TvTrackInfo>();
            this.mVideoTracks = new ArrayList<TvTrackInfo>();
            this.mSubtitleTracks = new ArrayList<TvTrackInfo>();
            this.mToken = iBinder;
            this.mChannel = inputChannel;
            this.mService = iTvInputManager;
            this.mUserId = n;
            this.mSeq = n2;
            this.mSessionCallbackRecordMap = sparseArray;
        }

        static /* synthetic */ String access$502(Session session, String string2) {
            session.mSelectedAudioTrackId = string2;
            return string2;
        }

        static /* synthetic */ String access$602(Session session, String string2) {
            session.mSelectedVideoTrackId = string2;
            return string2;
        }

        static /* synthetic */ String access$702(Session session, String string2) {
            session.mSelectedSubtitleTrackId = string2;
            return string2;
        }

        private boolean containsTrack(List<TvTrackInfo> list, String string2) {
            Iterator<TvTrackInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getId().equals(string2)) continue;
                return true;
            }
            return false;
        }

        private void flushPendingEventsLocked() {
            this.mHandler.removeMessages(3);
            int n = this.mPendingEvents.size();
            for (int i = 0; i < n; ++i) {
                int n2 = this.mPendingEvents.keyAt(i);
                Message message = this.mHandler.obtainMessage(3, n2, 0);
                message.setAsynchronous(true);
                message.sendToTarget();
            }
        }

        private PendingEvent obtainPendingEventLocked(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
            PendingEvent pendingEvent = this.mPendingEventPool.acquire();
            if (pendingEvent == null) {
                pendingEvent = new PendingEvent();
            }
            pendingEvent.mEvent = inputEvent;
            pendingEvent.mEventToken = object;
            pendingEvent.mCallback = finishedInputEventCallback;
            pendingEvent.mEventHandler = handler;
            return pendingEvent;
        }

        private void recyclePendingEventLocked(PendingEvent pendingEvent) {
            pendingEvent.recycle();
            this.mPendingEventPool.release(pendingEvent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void releaseInternal() {
            this.mToken = null;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mChannel != null) {
                    if (this.mSender != null) {
                        this.flushPendingEventsLocked();
                        this.mSender.dispose();
                        this.mSender = null;
                    }
                    this.mChannel.dispose();
                    this.mChannel = null;
                }
            }
            SparseArray<SessionCallbackRecord> sparseArray = this.mSessionCallbackRecordMap;
            synchronized (sparseArray) {
                this.mSessionCallbackRecordMap.remove(this.mSeq);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void sendInputEventAndReportResultOnMainLooper(PendingEvent pendingEvent) {
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.sendInputEventOnMainLooperLocked(pendingEvent) == -1) {
                    return;
                }
            }
            this.invokeFinishedInputEventCallback(pendingEvent, false);
        }

        private int sendInputEventOnMainLooperLocked(PendingEvent pendingEvent) {
            if (this.mChannel != null) {
                InputEvent inputEvent;
                int n;
                if (this.mSender == null) {
                    this.mSender = new TvInputEventSender(this.mChannel, this.mHandler.getLooper());
                }
                if (this.mSender.sendInputEvent(n = (inputEvent = pendingEvent.mEvent).getSequenceNumber(), inputEvent)) {
                    this.mPendingEvents.put(n, pendingEvent);
                    Message message = this.mHandler.obtainMessage(2, pendingEvent);
                    message.setAsynchronous(true);
                    this.mHandler.sendMessageDelayed(message, 2500L);
                    return -1;
                }
                Log.w(TvInputManager.TAG, "Unable to send input event to session: " + this.mToken + " dropping:" + inputEvent);
            }
            return 0;
        }

        void createOverlayView(View view, Rect rect) {
            if (view == null) {
                throw new IllegalArgumentException("view cannot be null");
            }
            if (rect == null) {
                throw new IllegalArgumentException("frame cannot be null");
            }
            if (view.getWindowToken() == null) {
                throw new IllegalStateException("view must be attached to a window");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.createOverlayView(this.mToken, view.getWindowToken(), rect, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int dispatchInputEvent(InputEvent inputEvent, Object object, FinishedInputEventCallback finishedInputEventCallback, Handler handler) {
            if (inputEvent == null) {
                throw new IllegalArgumentException("event cannot be null");
            }
            if (finishedInputEventCallback != null && handler == null) {
                throw new IllegalArgumentException("handler cannot be null");
            }
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                if (this.mChannel == null) {
                    return 0;
                }
                PendingEvent pendingEvent = this.obtainPendingEventLocked(inputEvent, object, finishedInputEventCallback, handler);
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    return this.sendInputEventOnMainLooperLocked(pendingEvent);
                }
                Message message = this.mHandler.obtainMessage(1, pendingEvent);
                message.setAsynchronous(true);
                this.mHandler.sendMessage(message);
                return -1;
            }
        }

        public void dispatchSurfaceChanged(int n, int n2, int n3) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.dispatchSurfaceChanged(this.mToken, n, n2, n3, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void finishedInputEvent(int n, boolean bl, boolean bl2) {
            PendingEvent pendingEvent;
            InputEventHandler inputEventHandler = this.mHandler;
            synchronized (inputEventHandler) {
                int n2 = this.mPendingEvents.indexOfKey(n);
                if (n2 < 0) {
                    return;
                }
                pendingEvent = this.mPendingEvents.valueAt(n2);
                this.mPendingEvents.removeAt(n2);
                if (bl2) {
                    Log.w(TvInputManager.TAG, "Timeout waiting for seesion to handle input event after 2500 ms: " + this.mToken);
                } else {
                    this.mHandler.removeMessages(2, pendingEvent);
                }
            }
            this.invokeFinishedInputEventCallback(pendingEvent, bl);
        }

        public String getSelectedTrack(int n) {
            if (n == 0) {
                return this.mSelectedAudioTrackId;
            }
            if (n == 1) {
                return this.mSelectedVideoTrackId;
            }
            if (n == 2) {
                return this.mSelectedSubtitleTrackId;
            }
            throw new IllegalArgumentException("invalid type: " + n);
        }

        IBinder getToken() {
            return this.mToken;
        }

        /*
         * Enabled aggressive block sorting
         */
        public List<TvTrackInfo> getTracks(int n) {
            if (n == 0) {
                if (this.mAudioTracks == null) return null;
                return this.mAudioTracks;
            }
            if (n == 1) {
                if (this.mVideoTracks == null) return null;
                return this.mVideoTracks;
            }
            if (n != 2) {
                throw new IllegalArgumentException("invalid type: " + n);
            }
            if (this.mSubtitleTracks != null) return this.mSubtitleTracks;
            return null;
        }

        void invokeFinishedInputEventCallback(PendingEvent pendingEvent, boolean bl) {
            pendingEvent.mHandled = bl;
            if (pendingEvent.mEventHandler.getLooper().isCurrentThread()) {
                pendingEvent.run();
                return;
            }
            Message message = Message.obtain(pendingEvent.mEventHandler, pendingEvent);
            message.setAsynchronous(true);
            message.sendToTarget();
        }

        void relayoutOverlayView(Rect rect) {
            if (rect == null) {
                throw new IllegalArgumentException("frame cannot be null");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.relayoutOverlayView(this.mToken, rect, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void release() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.releaseSession(this.mToken, this.mUserId);
                this.releaseInternal();
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        void removeOverlayView() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.removeOverlayView(this.mToken, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        void requestUnblockContent(TvContentRating tvContentRating) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            if (tvContentRating == null) {
                throw new IllegalArgumentException("unblockedRating cannot be null");
            }
            try {
                this.mService.requestUnblockContent(this.mToken, tvContentRating.flattenToString(), this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void selectTrack(int n, String string2) {
            if (n == 0) {
                if (string2 != null && !this.containsTrack(this.mAudioTracks, string2)) {
                    Log.w(TvInputManager.TAG, "Invalid audio trackId: " + string2);
                    return;
                }
            } else if (n == 1) {
                if (string2 != null && !this.containsTrack(this.mVideoTracks, string2)) {
                    Log.w(TvInputManager.TAG, "Invalid video trackId: " + string2);
                    return;
                }
            } else if (n == 2) {
                if (string2 != null && !this.containsTrack(this.mSubtitleTracks, string2)) {
                    Log.w(TvInputManager.TAG, "Invalid subtitle trackId: " + string2);
                    return;
                }
            } else {
                throw new IllegalArgumentException("invalid type: " + n);
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.selectTrack(this.mToken, n, string2, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void sendAppPrivateCommand(String string2, Bundle bundle) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.sendAppPrivateCommand(this.mToken, string2, bundle, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void setCaptionEnabled(boolean bl) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setCaptionEnabled(this.mToken, bl, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        void setMain() {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setMainSession(this.mToken, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setStreamVolume(float var1_1) {
            if (this.mToken == null) {
                Log.w("TvInputManager", "The session has been already released");
                return;
            }
            if (!(var1_1 < 0.0f) && !(var1_1 > 1.0f)) ** GOTO lbl-1000
            try {
                throw new IllegalArgumentException("volume should be between 0.0f and 1.0f");
            }
            catch (RemoteException var2_2) {
                throw new RuntimeException(var2_2);
            }
lbl-1000:
            // 1 sources

            {
                this.mService.setVolume(this.mToken, var1_1, this.mUserId);
                return;
            }
        }

        public void setSurface(Surface surface) {
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            try {
                this.mService.setSurface(this.mToken, surface, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void tune(Uri uri) {
            this.tune(uri, null);
        }

        public void tune(Uri uri, Bundle bundle) {
            if (uri == null) {
                throw new IllegalArgumentException("channelUri cannot be null");
            }
            if (this.mToken == null) {
                Log.w(TvInputManager.TAG, "The session has been already released");
                return;
            }
            this.mAudioTracks.clear();
            this.mVideoTracks.clear();
            this.mSubtitleTracks.clear();
            this.mSelectedAudioTrackId = null;
            this.mSelectedVideoTrackId = null;
            this.mSelectedSubtitleTrackId = null;
            try {
                this.mService.tune(this.mToken, uri, bundle, this.mUserId);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public static interface FinishedInputEventCallback {
            public void onFinishedInputEvent(Object var1, boolean var2);
        }

        private final class InputEventHandler
        extends Handler {
            public static final int MSG_FLUSH_INPUT_EVENT = 3;
            public static final int MSG_SEND_INPUT_EVENT = 1;
            public static final int MSG_TIMEOUT_INPUT_EVENT = 2;

            InputEventHandler(Looper looper) {
                super(looper, null, true);
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        Session.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)message.obj);
                        return;
                    }
                    case 2: {
                        Session.this.finishedInputEvent(message.arg1, false, true);
                        return;
                    }
                    case 3: 
                }
                Session.this.finishedInputEvent(message.arg1, false, false);
            }
        }

        private final class PendingEvent
        implements Runnable {
            public FinishedInputEventCallback mCallback;
            public InputEvent mEvent;
            public Handler mEventHandler;
            public Object mEventToken;
            public boolean mHandled;

            private PendingEvent() {
            }

            public void recycle() {
                this.mEvent = null;
                this.mEventToken = null;
                this.mCallback = null;
                this.mEventHandler = null;
                this.mHandled = false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                this.mCallback.onFinishedInputEvent(this.mEventToken, this.mHandled);
                Handler handler = this.mEventHandler;
                synchronized (handler) {
                    Session.this.recyclePendingEventLocked(this);
                    return;
                }
            }
        }

        private final class TvInputEventSender
        extends InputEventSender {
            public TvInputEventSender(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            @Override
            public void onInputEventFinished(int n, boolean bl) {
                Session.this.finishedInputEvent(n, bl, false);
            }
        }
    }

    public static abstract class SessionCallback {
        public void onChannelRetuned(Session session, Uri uri) {
        }

        public void onContentAllowed(Session session) {
        }

        public void onContentBlocked(Session session, TvContentRating tvContentRating) {
        }

        public void onLayoutSurface(Session session, int n, int n2, int n3, int n4) {
        }

        public void onSessionCreated(Session session) {
        }

        public void onSessionEvent(Session session, String string2, Bundle bundle) {
        }

        public void onSessionReleased(Session session) {
        }

        public void onTrackSelected(Session session, int n, String string2) {
        }

        public void onTracksChanged(Session session, List<TvTrackInfo> list) {
        }

        public void onVideoAvailable(Session session) {
        }

        public void onVideoUnavailable(Session session, int n) {
        }
    }

    private static final class SessionCallbackRecord {
        private final Handler mHandler;
        private Session mSession;
        private final SessionCallback mSessionCallback;

        public SessionCallbackRecord(SessionCallback sessionCallback, Handler handler) {
            this.mSessionCallback = sessionCallback;
            this.mHandler = handler;
        }

        public void postChannelRetuned(final Uri uri) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onChannelRetuned(SessionCallbackRecord.this.mSession, uri);
                }
            });
        }

        public void postContentAllowed() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onContentAllowed(SessionCallbackRecord.this.mSession);
                }
            });
        }

        public void postContentBlocked(final TvContentRating tvContentRating) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onContentBlocked(SessionCallbackRecord.this.mSession, tvContentRating);
                }
            });
        }

        public void postLayoutSurface(final int n, final int n2, final int n3, final int n4) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onLayoutSurface(SessionCallbackRecord.this.mSession, n, n2, n3, n4);
                }
            });
        }

        public void postSessionCreated(final Session session) {
            this.mSession = session;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionCreated(session);
                }
            });
        }

        public void postSessionEvent(final String string2, final Bundle bundle) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionEvent(SessionCallbackRecord.this.mSession, string2, bundle);
                }
            });
        }

        public void postSessionReleased() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onSessionReleased(SessionCallbackRecord.this.mSession);
                }
            });
        }

        public void postTrackSelected(final int n, final String string2) {
            this.mHandler.post(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void run() {
                    block5: {
                        block3: {
                            block4: {
                                block2: {
                                    if (n != 0) break block2;
                                    Session.access$502(SessionCallbackRecord.this.mSession, string2);
                                    break block3;
                                }
                                if (n != 1) break block4;
                                Session.access$602(SessionCallbackRecord.this.mSession, string2);
                                break block3;
                            }
                            if (n != 2) break block5;
                            Session.access$702(SessionCallbackRecord.this.mSession, string2);
                        }
                        SessionCallbackRecord.this.mSessionCallback.onTrackSelected(SessionCallbackRecord.this.mSession, n, string2);
                    }
                }
            });
        }

        public void postTracksChanged(final List<TvTrackInfo> list) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSession.mAudioTracks.clear();
                    SessionCallbackRecord.this.mSession.mVideoTracks.clear();
                    SessionCallbackRecord.this.mSession.mSubtitleTracks.clear();
                    for (TvTrackInfo tvTrackInfo : list) {
                        if (tvTrackInfo.getType() == 0) {
                            SessionCallbackRecord.this.mSession.mAudioTracks.add(tvTrackInfo);
                            continue;
                        }
                        if (tvTrackInfo.getType() == 1) {
                            SessionCallbackRecord.this.mSession.mVideoTracks.add(tvTrackInfo);
                            continue;
                        }
                        if (tvTrackInfo.getType() != 2) continue;
                        SessionCallbackRecord.this.mSession.mSubtitleTracks.add(tvTrackInfo);
                    }
                    SessionCallbackRecord.this.mSessionCallback.onTracksChanged(SessionCallbackRecord.this.mSession, list);
                }
            });
        }

        public void postVideoAvailable() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onVideoAvailable(SessionCallbackRecord.this.mSession);
                }
            });
        }

        public void postVideoUnavailable(final int n) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SessionCallbackRecord.this.mSessionCallback.onVideoUnavailable(SessionCallbackRecord.this.mSession, n);
                }
            });
        }
    }

    public static abstract class TvInputCallback {
        public void onInputAdded(String string2) {
        }

        public void onInputRemoved(String string2) {
        }

        public void onInputStateChanged(String string2, int n) {
        }

        public void onInputUpdated(String string2) {
        }
    }

    private static final class TvInputCallbackRecord {
        private final TvInputCallback mCallback;
        private final Handler mHandler;

        public TvInputCallbackRecord(TvInputCallback tvInputCallback, Handler handler) {
            this.mCallback = tvInputCallback;
            this.mHandler = handler;
        }

        public TvInputCallback getCallback() {
            return this.mCallback;
        }

        public void postInputAdded(final String string2) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputAdded(string2);
                }
            });
        }

        public void postInputRemoved(final String string2) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputRemoved(string2);
                }
            });
        }

        public void postInputStateChanged(final String string2, final int n) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputStateChanged(string2, n);
                }
            });
        }

        public void postInputUpdated(final String string2) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TvInputCallbackRecord.this.mCallback.onInputUpdated(string2);
                }
            });
        }
    }
}

