/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class TvStreamConfig
implements Parcelable {
    public static final Parcelable.Creator<TvStreamConfig> CREATOR;
    public static final int STREAM_TYPE_BUFFER_PRODUCER = 2;
    public static final int STREAM_TYPE_INDEPENDENT_VIDEO_SOURCE = 1;
    static final String TAG;
    private int mGeneration;
    private int mMaxHeight;
    private int mMaxWidth;
    private int mStreamId;
    private int mType;

    static {
        TAG = TvStreamConfig.class.getSimpleName();
        CREATOR = new Parcelable.Creator<TvStreamConfig>(){

            @Override
            public TvStreamConfig createFromParcel(Parcel parcel) {
                try {
                    TvStreamConfig tvStreamConfig = new Builder().streamId(parcel.readInt()).type(parcel.readInt()).maxWidth(parcel.readInt()).maxHeight(parcel.readInt()).generation(parcel.readInt()).build();
                    return tvStreamConfig;
                }
                catch (Exception exception) {
                    Log.e(TAG, "Exception creating TvStreamConfig from parcel", exception);
                    return null;
                }
            }

            public TvStreamConfig[] newArray(int n) {
                return new TvStreamConfig[n];
            }
        };
    }

    private TvStreamConfig() {
    }

    static /* synthetic */ int access$102(TvStreamConfig tvStreamConfig, int n) {
        tvStreamConfig.mStreamId = n;
        return n;
    }

    static /* synthetic */ int access$202(TvStreamConfig tvStreamConfig, int n) {
        tvStreamConfig.mType = n;
        return n;
    }

    static /* synthetic */ int access$302(TvStreamConfig tvStreamConfig, int n) {
        tvStreamConfig.mMaxWidth = n;
        return n;
    }

    static /* synthetic */ int access$402(TvStreamConfig tvStreamConfig, int n) {
        tvStreamConfig.mMaxHeight = n;
        return n;
    }

    static /* synthetic */ int access$502(TvStreamConfig tvStreamConfig, int n) {
        tvStreamConfig.mGeneration = n;
        return n;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getStreamId() {
        return this.mStreamId;
    }

    public int getType() {
        return this.mType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("TvStreamConfig {");
        stringBuilder.append("mStreamId=").append(this.mStreamId).append(";");
        stringBuilder.append("mType=").append(this.mType).append(";");
        stringBuilder.append("mGeneration=").append(this.mGeneration).append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mStreamId);
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mMaxWidth);
        parcel.writeInt(this.mMaxHeight);
        parcel.writeInt(this.mGeneration);
    }

    public static final class Builder {
        private Integer mGeneration;
        private Integer mMaxHeight;
        private Integer mMaxWidth;
        private Integer mStreamId;
        private Integer mType;

        public TvStreamConfig build() {
            if (this.mStreamId == null || this.mType == null || this.mMaxWidth == null || this.mMaxHeight == null || this.mGeneration == null) {
                throw new UnsupportedOperationException();
            }
            TvStreamConfig tvStreamConfig = new TvStreamConfig();
            TvStreamConfig.access$102(tvStreamConfig, this.mStreamId);
            TvStreamConfig.access$202(tvStreamConfig, this.mType);
            TvStreamConfig.access$302(tvStreamConfig, this.mMaxWidth);
            TvStreamConfig.access$402(tvStreamConfig, this.mMaxHeight);
            TvStreamConfig.access$502(tvStreamConfig, this.mGeneration);
            return tvStreamConfig;
        }

        public Builder generation(int n) {
            this.mGeneration = n;
            return this;
        }

        public Builder maxHeight(int n) {
            this.mMaxHeight = n;
            return this;
        }

        public Builder maxWidth(int n) {
            this.mMaxWidth = n;
            return this;
        }

        public Builder streamId(int n) {
            this.mStreamId = n;
            return this;
        }

        public Builder type(int n) {
            this.mType = n;
            return this;
        }
    }
}

