/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkStatsSession
extends IInterface {
    public void close() throws RemoteException;

    public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate var1, int var2) throws RemoteException;

    public NetworkStatsHistory getHistoryForUid(NetworkTemplate var1, int var2, int var3, int var4, int var5) throws RemoteException;

    public NetworkStats getSummaryForAllUid(NetworkTemplate var1, long var2, long var4, boolean var6) throws RemoteException;

    public NetworkStats getSummaryForNetwork(NetworkTemplate var1, long var2, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkStatsSession {
        private static final String DESCRIPTOR = "android.net.INetworkStatsSession";
        static final int TRANSACTION_close = 5;
        static final int TRANSACTION_getHistoryForNetwork = 2;
        static final int TRANSACTION_getHistoryForUid = 4;
        static final int TRANSACTION_getSummaryForAllUid = 3;
        static final int TRANSACTION_getSummaryForNetwork = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkStatsSession asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof INetworkStatsSession) {
                return (INetworkStatsSession)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkTemplate networkTemplate = parcel.readInt() != 0 ? NetworkTemplate.CREATOR.createFromParcel(parcel) : null;
                    NetworkStats networkStats = this.getSummaryForNetwork(networkTemplate, parcel.readLong(), parcel.readLong());
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkTemplate networkTemplate = parcel.readInt() != 0 ? NetworkTemplate.CREATOR.createFromParcel(parcel) : null;
                    NetworkStatsHistory networkStatsHistory = this.getHistoryForNetwork(networkTemplate, parcel.readInt());
                    parcel2.writeNoException();
                    if (networkStatsHistory != null) {
                        parcel2.writeInt(1);
                        networkStatsHistory.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkTemplate networkTemplate = parcel.readInt() != 0 ? NetworkTemplate.CREATOR.createFromParcel(parcel) : null;
                    long l = parcel.readLong();
                    long l2 = parcel.readLong();
                    boolean bl = parcel.readInt() != 0;
                    NetworkStats networkStats = this.getSummaryForAllUid(networkTemplate, l, l2, bl);
                    parcel2.writeNoException();
                    if (networkStats != null) {
                        parcel2.writeInt(1);
                        networkStats.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    NetworkTemplate networkTemplate = parcel.readInt() != 0 ? NetworkTemplate.CREATOR.createFromParcel(parcel) : null;
                    int n3 = parcel.readInt();
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    NetworkStatsHistory networkStatsHistory = this.getHistoryForUid(networkTemplate, n3, n4, n5, n6);
                    parcel2.writeNoException();
                    if (networkStatsHistory != null) {
                        parcel2.writeInt(1);
                        networkStatsHistory.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.close();
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements INetworkStatsSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void close() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate networkTemplate, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkTemplate != null) {
                        parcel.writeInt(1);
                        networkTemplate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStatsHistory networkStatsHistory = parcel2.readInt() != 0 ? NetworkStatsHistory.CREATOR.createFromParcel(parcel2) : null;
                    return networkStatsHistory;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStatsHistory getHistoryForUid(NetworkTemplate networkTemplate, int n, int n2, int n3, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkTemplate != null) {
                        parcel.writeInt(1);
                        networkTemplate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStatsHistory networkStatsHistory = parcel2.readInt() != 0 ? NetworkStatsHistory.CREATOR.createFromParcel(parcel2) : null;
                    return networkStatsHistory;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getSummaryForAllUid(NetworkTemplate networkTemplate, long l, long l2, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                int n;
                block6: {
                    block5: {
                        n = 1;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (networkTemplate != null) {
                                parcel2.writeInt(1);
                                networkTemplate.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeLong(l);
                            parcel2.writeLong(l2);
                            if (!bl) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    n = 0;
                }
                parcel2.writeInt(n);
                this.mRemote.transact(3, parcel2, parcel, 0);
                parcel.readException();
                NetworkStats networkStats = parcel.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel) : null;
                parcel.recycle();
                parcel2.recycle();
                return networkStats;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public NetworkStats getSummaryForNetwork(NetworkTemplate networkTemplate, long l, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (networkTemplate != null) {
                        parcel.writeInt(1);
                        networkTemplate.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    parcel.writeLong(l2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    NetworkStats networkStats = parcel2.readInt() != 0 ? NetworkStats.CREATOR.createFromParcel(parcel2) : null;
                    return networkStats;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

