/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.NetworkPolicy;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.format.Time;
import java.io.PrintWriter;

public class NetworkPolicyManager {
    private static final boolean ALLOW_PLATFORM_APP_POLICY = true;
    public static final String EXTRA_NETWORK_TEMPLATE = "android.net.NETWORK_TEMPLATE";
    public static final int POLICY_ALLOW_BACKGROUND_BATTERY_SAVE = 2;
    public static final int POLICY_NONE = 0;
    public static final int POLICY_REJECT_METERED_BACKGROUND = 1;
    public static final int RULE_ALLOW_ALL = 0;
    public static final int RULE_REJECT_METERED = 1;
    private INetworkPolicyManager mService;

    public NetworkPolicyManager(INetworkPolicyManager iNetworkPolicyManager) {
        if (iNetworkPolicyManager == null) {
            throw new IllegalArgumentException("missing INetworkPolicyManager");
        }
        this.mService = iNetworkPolicyManager;
    }

    public static long computeLastCycleBoundary(long l, NetworkPolicy networkPolicy) {
        if (networkPolicy.cycleDay == -1) {
            throw new IllegalArgumentException("Unable to compute boundary without cycleDay");
        }
        Time time = new Time(networkPolicy.cycleTimezone);
        time.set(l);
        Time time2 = new Time(time);
        time2.second = 0;
        time2.minute = 0;
        time2.hour = 0;
        NetworkPolicyManager.snapToCycleDay(time2, networkPolicy.cycleDay);
        if (Time.compare(time2, time) >= 0) {
            Time time3 = new Time(time);
            time3.second = 0;
            time3.minute = 0;
            time3.hour = 0;
            time3.monthDay = 1;
            time3.month = -1 + time3.month;
            time3.normalize(true);
            time2.set(time3);
            NetworkPolicyManager.snapToCycleDay(time2, networkPolicy.cycleDay);
        }
        return time2.toMillis(true);
    }

    public static long computeNextCycleBoundary(long l, NetworkPolicy networkPolicy) {
        if (networkPolicy.cycleDay == -1) {
            throw new IllegalArgumentException("Unable to compute boundary without cycleDay");
        }
        Time time = new Time(networkPolicy.cycleTimezone);
        time.set(l);
        Time time2 = new Time(time);
        time2.second = 0;
        time2.minute = 0;
        time2.hour = 0;
        NetworkPolicyManager.snapToCycleDay(time2, networkPolicy.cycleDay);
        if (Time.compare(time2, time) <= 0) {
            Time time3 = new Time(time);
            time3.second = 0;
            time3.minute = 0;
            time3.hour = 0;
            time3.monthDay = 1;
            time3.month = 1 + time3.month;
            time3.normalize(true);
            time2.set(time3);
            NetworkPolicyManager.snapToCycleDay(time2, networkPolicy.cycleDay);
        }
        return time2.toMillis(true);
    }

    public static void dumpPolicy(PrintWriter printWriter, int n) {
        printWriter.write("[");
        if ((n & 1) != 0) {
            printWriter.write("REJECT_METERED_BACKGROUND");
        }
        printWriter.write("]");
    }

    public static void dumpRules(PrintWriter printWriter, int n) {
        printWriter.write("[");
        if ((n & 1) != 0) {
            printWriter.write("REJECT_METERED");
        }
        printWriter.write("]");
    }

    public static NetworkPolicyManager from(Context context) {
        return (NetworkPolicyManager)context.getSystemService("netpolicy");
    }

    @Deprecated
    public static boolean isUidValidForPolicy(Context context, int n) {
        return UserHandle.isApp(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void snapToCycleDay(Time time, int n) {
        if (n > time.getActualMaximum(4)) {
            time.month = 1 + time.month;
            time.monthDay = 1;
            time.second = -1;
        } else {
            time.monthDay = n;
        }
        time.normalize(true);
    }

    public void addUidPolicy(int n, int n2) {
        try {
            this.mService.addUidPolicy(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public NetworkPolicy[] getNetworkPolicies() {
        try {
            NetworkPolicy[] networkPolicyArray = this.mService.getNetworkPolicies();
            return networkPolicyArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int[] getPowerSaveAppIdWhitelist() {
        try {
            int[] nArray = this.mService.getPowerSaveAppIdWhitelist();
            return nArray;
        }
        catch (RemoteException remoteException) {
            return new int[0];
        }
    }

    public boolean getRestrictBackground() {
        try {
            boolean bl = this.mService.getRestrictBackground();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int getUidPolicy(int n) {
        try {
            int n2 = this.mService.getUidPolicy(n);
            return n2;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public int[] getUidsWithPolicy(int n) {
        try {
            int[] nArray = this.mService.getUidsWithPolicy(n);
            return nArray;
        }
        catch (RemoteException remoteException) {
            return new int[0];
        }
    }

    public void registerListener(INetworkPolicyListener iNetworkPolicyListener) {
        try {
            this.mService.registerListener(iNetworkPolicyListener);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void removeUidPolicy(int n, int n2) {
        try {
            this.mService.removeUidPolicy(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setNetworkPolicies(NetworkPolicy[] networkPolicyArray) {
        try {
            this.mService.setNetworkPolicies(networkPolicyArray);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setRestrictBackground(boolean bl) {
        try {
            this.mService.setRestrictBackground(bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setUidPolicy(int n, int n2) {
        try {
            this.mService.setUidPolicy(n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void unregisterListener(INetworkPolicyListener iNetworkPolicyListener) {
        try {
            this.mService.unregisterListener(iNetworkPolicyListener);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

