/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkCapabilities;
import android.os.Parcel;
import android.os.Parcelable;

public class NetworkRequest
implements Parcelable {
    public static final Parcelable.Creator<NetworkRequest> CREATOR = new Parcelable.Creator<NetworkRequest>(){

        @Override
        public NetworkRequest createFromParcel(Parcel parcel) {
            return new NetworkRequest((NetworkCapabilities)parcel.readParcelable(null), parcel.readInt(), parcel.readInt());
        }

        public NetworkRequest[] newArray(int n) {
            return new NetworkRequest[n];
        }
    };
    public final int legacyType;
    public final NetworkCapabilities networkCapabilities;
    public final int requestId;

    public NetworkRequest(NetworkCapabilities networkCapabilities, int n, int n2) {
        if (networkCapabilities == null) {
            throw new NullPointerException();
        }
        this.requestId = n2;
        this.networkCapabilities = networkCapabilities;
        this.legacyType = n;
    }

    public NetworkRequest(NetworkRequest networkRequest) {
        this.networkCapabilities = new NetworkCapabilities(networkRequest.networkCapabilities);
        this.requestId = networkRequest.requestId;
        this.legacyType = networkRequest.legacyType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof NetworkRequest)) break block2;
                NetworkRequest networkRequest = (NetworkRequest)object;
                if (networkRequest.legacyType == this.legacyType && networkRequest.requestId == this.requestId && (networkRequest.networkCapabilities == null && this.networkCapabilities == null || networkRequest.networkCapabilities != null && networkRequest.networkCapabilities.equals(this.networkCapabilities))) break block3;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.requestId + 1013 * this.legacyType + 1051 * this.networkCapabilities.hashCode();
    }

    public String toString() {
        return "NetworkRequest [ id=" + this.requestId + ", legacyType=" + this.legacyType + ", " + this.networkCapabilities.toString() + " ]";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable(this.networkCapabilities, n);
        parcel.writeInt(this.legacyType);
        parcel.writeInt(this.requestId);
    }

    public static class Builder {
        private final NetworkCapabilities mNetworkCapabilities = new NetworkCapabilities();

        public Builder addCapability(int n) {
            this.mNetworkCapabilities.addCapability(n);
            return this;
        }

        public Builder addTransportType(int n) {
            this.mNetworkCapabilities.addTransportType(n);
            return this;
        }

        public NetworkRequest build() {
            return new NetworkRequest(this.mNetworkCapabilities, -1, 0);
        }

        public Builder removeCapability(int n) {
            this.mNetworkCapabilities.removeCapability(n);
            return this;
        }

        public Builder removeTransportType(int n) {
            this.mNetworkCapabilities.removeTransportType(n);
            return this;
        }

        public Builder setLinkDownstreamBandwidthKbps(int n) {
            this.mNetworkCapabilities.setLinkDownstreamBandwidthKbps(n);
            return this;
        }

        public Builder setLinkUpstreamBandwidthKbps(int n) {
            this.mNetworkCapabilities.setLinkUpstreamBandwidthKbps(n);
            return this;
        }

        public Builder setNetworkSpecifier(String string2) {
            this.mNetworkCapabilities.setNetworkSpecifier(string2);
            return this;
        }
    }
}

