/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.SparseBooleanArray;
import com.android.internal.util.ArrayUtils;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import libcore.util.EmptyArray;

public class NetworkStats
implements Parcelable {
    public static final Parcelable.Creator<NetworkStats> CREATOR;
    public static final String IFACE_ALL;
    public static final int SET_ALL = -1;
    public static final int SET_DEFAULT = 0;
    public static final int SET_FOREGROUND = 1;
    public static final int TAG_ALL = -1;
    public static final int TAG_NONE = 0;
    public static final int UID_ALL = -1;
    private int capacity;
    private long elapsedRealtime;
    private String[] iface;
    private long[] operations;
    private long[] rxBytes;
    private long[] rxPackets;
    private int[] set;
    private int size;
    private int[] tag;
    private long[] txBytes;
    private long[] txPackets;
    private int[] uid;

    static {
        IFACE_ALL = null;
        CREATOR = new Parcelable.Creator<NetworkStats>(){

            @Override
            public NetworkStats createFromParcel(Parcel parcel) {
                return new NetworkStats(parcel);
            }

            public NetworkStats[] newArray(int n) {
                return new NetworkStats[n];
            }
        };
    }

    public NetworkStats(long l, int n) {
        this.elapsedRealtime = l;
        this.size = 0;
        if (n >= 0) {
            this.capacity = n;
            this.iface = new String[n];
            this.uid = new int[n];
            this.set = new int[n];
            this.tag = new int[n];
            this.rxBytes = new long[n];
            this.rxPackets = new long[n];
            this.txBytes = new long[n];
            this.txPackets = new long[n];
            this.operations = new long[n];
            return;
        }
        this.capacity = 0;
        this.iface = EmptyArray.STRING;
        this.uid = EmptyArray.INT;
        this.set = EmptyArray.INT;
        this.tag = EmptyArray.INT;
        this.rxBytes = EmptyArray.LONG;
        this.rxPackets = EmptyArray.LONG;
        this.txBytes = EmptyArray.LONG;
        this.txPackets = EmptyArray.LONG;
        this.operations = EmptyArray.LONG;
    }

    public NetworkStats(Parcel parcel) {
        this.elapsedRealtime = parcel.readLong();
        this.size = parcel.readInt();
        this.capacity = parcel.readInt();
        this.iface = parcel.createStringArray();
        this.uid = parcel.createIntArray();
        this.set = parcel.createIntArray();
        this.tag = parcel.createIntArray();
        this.rxBytes = parcel.createLongArray();
        this.rxPackets = parcel.createLongArray();
        this.txBytes = parcel.createLongArray();
        this.txPackets = parcel.createLongArray();
        this.operations = parcel.createLongArray();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Entry getTotal(Entry entry, HashSet<String> hashSet, int n, boolean bl) {
        Entry entry2 = entry != null ? entry : new Entry();
        entry2.iface = IFACE_ALL;
        entry2.uid = n;
        entry2.set = -1;
        entry2.tag = 0;
        entry2.rxBytes = 0L;
        entry2.rxPackets = 0L;
        entry2.txBytes = 0L;
        entry2.txPackets = 0L;
        entry2.operations = 0L;
        int n2 = 0;
        while (n2 < this.size) {
            boolean bl2 = n == -1 || n == this.uid[n2];
            boolean bl3 = hashSet == null || hashSet.contains(this.iface[n2]);
            if (bl2 && bl3 && (this.tag[n2] == 0 || bl)) {
                entry2.rxBytes += this.rxBytes[n2];
                entry2.rxPackets += this.rxPackets[n2];
                entry2.txBytes += this.txBytes[n2];
                entry2.txPackets += this.txPackets[n2];
                entry2.operations += this.operations[n2];
            }
            ++n2;
        }
        return entry2;
    }

    public static String setToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case -1: {
                return "ALL";
            }
            case 0: {
                return "DEFAULT";
            }
            case 1: 
        }
        return "FOREGROUND";
    }

    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c) {
        return NetworkStats.subtract(networkStats, networkStats2, nonMonotonicObserver, c, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <C> NetworkStats subtract(NetworkStats networkStats, NetworkStats networkStats2, NonMonotonicObserver<C> nonMonotonicObserver, C c, NetworkStats networkStats3) {
        NetworkStats networkStats4;
        long l = networkStats.elapsedRealtime - networkStats2.elapsedRealtime;
        if (l < 0L) {
            if (nonMonotonicObserver != null) {
                nonMonotonicObserver.foundNonMonotonic(networkStats, -1, networkStats2, -1, c);
            }
            l = 0L;
        }
        Entry entry = new Entry();
        if (networkStats3 != null && networkStats3.capacity >= networkStats.size) {
            networkStats4 = networkStats3;
            networkStats4.size = 0;
            networkStats4.elapsedRealtime = l;
        } else {
            networkStats4 = new NetworkStats(l, networkStats.size);
        }
        int n = 0;
        while (n < networkStats.size) {
            entry.iface = networkStats.iface[n];
            entry.uid = networkStats.uid[n];
            entry.set = networkStats.set[n];
            entry.tag = networkStats.tag[n];
            int n2 = networkStats2.findIndexHinted(entry.iface, entry.uid, entry.set, entry.tag, n);
            if (n2 == -1) {
                entry.rxBytes = networkStats.rxBytes[n];
                entry.rxPackets = networkStats.rxPackets[n];
                entry.txBytes = networkStats.txBytes[n];
                entry.txPackets = networkStats.txPackets[n];
                entry.operations = networkStats.operations[n];
            } else {
                entry.rxBytes = networkStats.rxBytes[n] - networkStats2.rxBytes[n2];
                entry.rxPackets = networkStats.rxPackets[n] - networkStats2.rxPackets[n2];
                entry.txBytes = networkStats.txBytes[n] - networkStats2.txBytes[n2];
                entry.txPackets = networkStats.txPackets[n] - networkStats2.txPackets[n2];
                entry.operations = networkStats.operations[n] - networkStats2.operations[n2];
                if (entry.rxBytes < 0L || entry.rxPackets < 0L || entry.txBytes < 0L || entry.txPackets < 0L || entry.operations < 0L) {
                    if (nonMonotonicObserver != null) {
                        nonMonotonicObserver.foundNonMonotonic(networkStats, n, networkStats2, n2, c);
                    }
                    entry.rxBytes = Math.max(entry.rxBytes, 0L);
                    entry.rxPackets = Math.max(entry.rxPackets, 0L);
                    entry.txBytes = Math.max(entry.txBytes, 0L);
                    entry.txPackets = Math.max(entry.txPackets, 0L);
                    entry.operations = Math.max(entry.operations, 0L);
                }
            }
            networkStats4.addValues(entry);
            ++n;
        }
        return networkStats4;
    }

    public static String tagToString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public NetworkStats addIfaceValues(String string2, long l, long l2, long l3, long l4) {
        return this.addValues(string2, -1, 0, 0, l, l2, l3, l4, 0L);
    }

    public NetworkStats addValues(Entry entry) {
        if (this.size >= this.capacity) {
            int n = 3 * Math.max(this.size, 10) / 2;
            this.iface = Arrays.copyOf(this.iface, n);
            this.uid = Arrays.copyOf(this.uid, n);
            this.set = Arrays.copyOf(this.set, n);
            this.tag = Arrays.copyOf(this.tag, n);
            this.rxBytes = Arrays.copyOf(this.rxBytes, n);
            this.rxPackets = Arrays.copyOf(this.rxPackets, n);
            this.txBytes = Arrays.copyOf(this.txBytes, n);
            this.txPackets = Arrays.copyOf(this.txPackets, n);
            this.operations = Arrays.copyOf(this.operations, n);
            this.capacity = n;
        }
        this.iface[this.size] = entry.iface;
        this.uid[this.size] = entry.uid;
        this.set[this.size] = entry.set;
        this.tag[this.size] = entry.tag;
        this.rxBytes[this.size] = entry.rxBytes;
        this.rxPackets[this.size] = entry.rxPackets;
        this.txBytes[this.size] = entry.txBytes;
        this.txPackets[this.size] = entry.txPackets;
        this.operations[this.size] = entry.operations;
        this.size = 1 + this.size;
        return this;
    }

    public NetworkStats addValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return this.addValues(new Entry(string2, n, n2, n3, l, l2, l3, l4, l5));
    }

    public NetworkStats clone() {
        NetworkStats networkStats = new NetworkStats(this.elapsedRealtime, this.size);
        Entry entry = null;
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            networkStats.addValues(entry);
        }
        return networkStats;
    }

    public void combineAllValues(NetworkStats networkStats) {
        Entry entry = null;
        for (int i = 0; i < networkStats.size; ++i) {
            entry = networkStats.getValues(i, entry);
            this.combineValues(entry);
        }
    }

    public NetworkStats combineValues(Entry entry) {
        int n = this.findIndex(entry.iface, entry.uid, entry.set, entry.tag);
        if (n == -1) {
            this.addValues(entry);
            return this;
        }
        long[] lArray = this.rxBytes;
        lArray[n] = lArray[n] + entry.rxBytes;
        long[] lArray2 = this.rxPackets;
        lArray2[n] = lArray2[n] + entry.rxPackets;
        long[] lArray3 = this.txBytes;
        lArray3[n] = lArray3[n] + entry.txBytes;
        long[] lArray4 = this.txPackets;
        lArray4[n] = lArray4[n] + entry.txPackets;
        long[] lArray5 = this.operations;
        lArray5[n] = lArray5[n] + entry.operations;
        return this;
    }

    public NetworkStats combineValues(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
        return this.combineValues(new Entry(string2, n, n2, n3, l, l2, l3, l4, l5));
    }

    @Deprecated
    public NetworkStats combineValues(String string2, int n, int n2, long l, long l2, long l3, long l4, long l5) {
        return this.combineValues(string2, n, 0, n2, l, l2, l3, l4, l5);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(String string2, PrintWriter printWriter) {
        printWriter.print(string2);
        printWriter.print("NetworkStats: elapsedRealtime=");
        printWriter.println(this.elapsedRealtime);
        for (int i = 0; i < this.size; ++i) {
            printWriter.print(string2);
            printWriter.print("  [");
            printWriter.print(i);
            printWriter.print("]");
            printWriter.print(" iface=");
            printWriter.print(this.iface[i]);
            printWriter.print(" uid=");
            printWriter.print(this.uid[i]);
            printWriter.print(" set=");
            printWriter.print(NetworkStats.setToString(this.set[i]));
            printWriter.print(" tag=");
            printWriter.print(NetworkStats.tagToString(this.tag[i]));
            printWriter.print(" rxBytes=");
            printWriter.print(this.rxBytes[i]);
            printWriter.print(" rxPackets=");
            printWriter.print(this.rxPackets[i]);
            printWriter.print(" txBytes=");
            printWriter.print(this.txBytes[i]);
            printWriter.print(" txPackets=");
            printWriter.print(this.txPackets[i]);
            printWriter.print(" operations=");
            printWriter.println(this.operations[i]);
        }
    }

    public int findIndex(String string2, int n, int n2, int n3) {
        for (int i = 0; i < this.size; ++i) {
            if (n != this.uid[i] || n2 != this.set[i] || n3 != this.tag[i] || !Objects.equals(string2, this.iface[i])) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int findIndexHinted(String string2, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.size) {
            int n6 = n5 / 2;
            int n7 = n5 % 2 == 0 ? (n4 + n6) % this.size : (-1 + (n4 + this.size - n6)) % this.size;
            if (n == this.uid[n7] && n2 == this.set[n7] && n3 == this.tag[n7] && Objects.equals(string2, this.iface[n7])) {
                return n7;
            }
            ++n5;
        }
        return -1;
    }

    public long getElapsedRealtime() {
        return this.elapsedRealtime;
    }

    public long getElapsedRealtimeAge() {
        return SystemClock.elapsedRealtime() - this.elapsedRealtime;
    }

    public Entry getTotal(Entry entry) {
        return this.getTotal(entry, null, -1, false);
    }

    public Entry getTotal(Entry entry, int n) {
        return this.getTotal(entry, null, n, false);
    }

    public Entry getTotal(Entry entry, HashSet<String> hashSet) {
        return this.getTotal(entry, hashSet, -1, false);
    }

    public long getTotalBytes() {
        Entry entry = this.getTotal(null);
        return entry.rxBytes + entry.txBytes;
    }

    public Entry getTotalIncludingTags(Entry entry) {
        return this.getTotal(entry, null, -1, true);
    }

    public long getTotalPackets() {
        long l = 0L;
        for (int i = -1 + this.size; i >= 0; --i) {
            l += this.rxPackets[i] + this.txPackets[i];
        }
        return l;
    }

    public String[] getUniqueIfaces() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.iface) {
            if (string2 == IFACE_ALL) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public int[] getUniqueUids() {
        SparseBooleanArray sparseBooleanArray = new SparseBooleanArray();
        int[] nArray = this.uid;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            sparseBooleanArray.put(nArray[i], true);
        }
        int n2 = sparseBooleanArray.size();
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = sparseBooleanArray.keyAt(i);
        }
        return nArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Entry getValues(int n, Entry entry) {
        Entry entry2 = entry != null ? entry : new Entry();
        entry2.iface = this.iface[n];
        entry2.uid = this.uid[n];
        entry2.set = this.set[n];
        entry2.tag = this.tag[n];
        entry2.rxBytes = this.rxBytes[n];
        entry2.rxPackets = this.rxPackets[n];
        entry2.txBytes = this.txBytes[n];
        entry2.txPackets = this.txPackets[n];
        entry2.operations = this.operations[n];
        return entry2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public NetworkStats groupedByIface() {
        NetworkStats networkStats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.uid = -1;
        entry.set = -1;
        entry.tag = 0;
        entry.operations = 0L;
        int n = 0;
        while (n < this.size) {
            if (this.tag[n] == 0) {
                entry.iface = this.iface[n];
                entry.rxBytes = this.rxBytes[n];
                entry.rxPackets = this.rxPackets[n];
                entry.txBytes = this.txBytes[n];
                entry.txPackets = this.txPackets[n];
                networkStats.combineValues(entry);
            }
            ++n;
        }
        return networkStats;
    }

    /*
     * Enabled aggressive block sorting
     */
    public NetworkStats groupedByUid() {
        NetworkStats networkStats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        entry.iface = IFACE_ALL;
        entry.set = -1;
        entry.tag = 0;
        int n = 0;
        while (n < this.size) {
            if (this.tag[n] == 0) {
                entry.uid = this.uid[n];
                entry.rxBytes = this.rxBytes[n];
                entry.rxPackets = this.rxPackets[n];
                entry.txBytes = this.txBytes[n];
                entry.txPackets = this.txPackets[n];
                entry.operations = this.operations[n];
                networkStats.combineValues(entry);
            }
            ++n;
        }
        return networkStats;
    }

    public int internalSize() {
        return this.capacity;
    }

    public void setElapsedRealtime(long l) {
        this.elapsedRealtime = l;
    }

    public int size() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spliceOperationsFrom(NetworkStats networkStats) {
        int n = 0;
        while (n < this.size) {
            int n2 = networkStats.findIndex(this.iface[n], this.uid[n], this.set[n], this.tag[n]);
            this.operations[n] = n2 == -1 ? 0L : networkStats.operations[n2];
            ++n;
        }
        return;
    }

    public NetworkStats subtract(NetworkStats networkStats) {
        return NetworkStats.subtract(this, networkStats, null, null);
    }

    public String toString() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        this.dump("", new PrintWriter(charArrayWriter));
        return charArrayWriter.toString();
    }

    public NetworkStats withoutUids(int[] nArray) {
        NetworkStats networkStats = new NetworkStats(this.elapsedRealtime, 10);
        Entry entry = new Entry();
        for (int i = 0; i < this.size; ++i) {
            entry = this.getValues(i, entry);
            if (ArrayUtils.contains(nArray, entry.uid)) continue;
            networkStats.addValues(entry);
        }
        return networkStats;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.elapsedRealtime);
        parcel.writeInt(this.size);
        parcel.writeInt(this.capacity);
        parcel.writeStringArray(this.iface);
        parcel.writeIntArray(this.uid);
        parcel.writeIntArray(this.set);
        parcel.writeIntArray(this.tag);
        parcel.writeLongArray(this.rxBytes);
        parcel.writeLongArray(this.rxPackets);
        parcel.writeLongArray(this.txBytes);
        parcel.writeLongArray(this.txPackets);
        parcel.writeLongArray(this.operations);
    }

    public static class Entry {
        public String iface;
        public long operations;
        public long rxBytes;
        public long rxPackets;
        public int set;
        public int tag;
        public long txBytes;
        public long txPackets;
        public int uid;

        public Entry() {
            this(IFACE_ALL, -1, 0, 0, 0L, 0L, 0L, 0L, 0L);
        }

        public Entry(long l, long l2, long l3, long l4, long l5) {
            this(IFACE_ALL, -1, 0, 0, l, l2, l3, l4, l5);
        }

        public Entry(String string2, int n, int n2, int n3, long l, long l2, long l3, long l4, long l5) {
            this.iface = string2;
            this.uid = n;
            this.set = n2;
            this.tag = n3;
            this.rxBytes = l;
            this.rxPackets = l2;
            this.txBytes = l3;
            this.txPackets = l4;
            this.operations = l5;
        }

        public void add(Entry entry) {
            this.rxBytes += entry.rxBytes;
            this.rxPackets += entry.rxPackets;
            this.txBytes += entry.txBytes;
            this.txPackets += entry.txPackets;
            this.operations += entry.operations;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof Entry;
            boolean bl2 = false;
            if (bl) {
                Entry entry = (Entry)object;
                int n = this.uid;
                int n2 = entry.uid;
                bl2 = false;
                if (n == n2) {
                    int n3 = this.set;
                    int n4 = entry.set;
                    bl2 = false;
                    if (n3 == n4) {
                        int n5 = this.tag;
                        int n6 = entry.tag;
                        bl2 = false;
                        if (n5 == n6) {
                            long l = this.rxBytes - entry.rxBytes;
                            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                            bl2 = false;
                            if (l2 == false) {
                                long l3 = this.rxPackets - entry.rxPackets;
                                long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
                                bl2 = false;
                                if (l4 == false) {
                                    long l5 = this.txBytes - entry.txBytes;
                                    long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                                    bl2 = false;
                                    if (l6 == false) {
                                        long l7 = this.txPackets - entry.txPackets;
                                        long l8 = l7 == 0L ? 0 : (l7 < 0L ? -1 : 1);
                                        bl2 = false;
                                        if (l8 == false) {
                                            long l9 = this.operations - entry.operations;
                                            long l10 = l9 == 0L ? 0 : (l9 < 0L ? -1 : 1);
                                            bl2 = false;
                                            if (l10 == false) {
                                                boolean bl3 = this.iface.equals(entry.iface);
                                                bl2 = false;
                                                if (bl3) {
                                                    bl2 = true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bl2;
        }

        public boolean isEmpty() {
            return this.rxBytes == 0L && this.rxPackets == 0L && this.txBytes == 0L && this.txPackets == 0L && this.operations == 0L;
        }

        public boolean isNegative() {
            return this.rxBytes < 0L || this.rxPackets < 0L || this.txBytes < 0L || this.txPackets < 0L || this.operations < 0L;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("iface=").append(this.iface);
            stringBuilder.append(" uid=").append(this.uid);
            stringBuilder.append(" set=").append(NetworkStats.setToString(this.set));
            stringBuilder.append(" tag=").append(NetworkStats.tagToString(this.tag));
            stringBuilder.append(" rxBytes=").append(this.rxBytes);
            stringBuilder.append(" rxPackets=").append(this.rxPackets);
            stringBuilder.append(" txBytes=").append(this.txBytes);
            stringBuilder.append(" txPackets=").append(this.txPackets);
            stringBuilder.append(" operations=").append(this.operations);
            return stringBuilder.toString();
        }
    }

    public static interface NonMonotonicObserver<C> {
        public void foundNonMonotonic(NetworkStats var1, int var2, NetworkStats var3, int var4, C var5);
    }
}

