/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import libcore.net.UriCodec;

public abstract class Uri
implements Parcelable,
Comparable<Uri> {
    public static final Parcelable.Creator<Uri> CREATOR;
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final Uri EMPTY;
    private static final char[] HEX_DIGITS;
    private static final String LOG;
    private static final String NOT_CACHED;
    private static final int NOT_CALCULATED = -2;
    private static final int NOT_FOUND = -1;
    private static final String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
    private static final int NULL_TYPE_ID;

    static {
        LOG = Uri.class.getSimpleName();
        NOT_CACHED = new String("NOT CACHED");
        EMPTY = new HierarchicalUri(null, Part.NULL, PathPart.EMPTY, Part.NULL, Part.NULL);
        CREATOR = new Parcelable.Creator<Uri>(){

            @Override
            public Uri createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                switch (n) {
                    default: {
                        throw new IllegalArgumentException("Unknown URI type: " + n);
                    }
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return StringUri.readFrom(parcel);
                    }
                    case 2: {
                        return OpaqueUri.readFrom(parcel);
                    }
                    case 3: 
                }
                return HierarchicalUri.readFrom(parcel);
            }

            public Uri[] newArray(int n) {
                return new Uri[n];
            }
        };
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    private Uri() {
    }

    public static String decode(String string2) {
        if (string2 == null) {
            return null;
        }
        return UriCodec.decode((String)string2, (boolean)false, (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    public static String encode(String string2) {
        return Uri.encode(string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String encode(String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            for (n4 = n2; n4 < n && Uri.isAllowed(string2.charAt(n4), string3); ++n4) {
            }
            if (n4 == n) {
                if (n2 == 0) return string2;
                stringBuilder.append(string2, n2, n);
                return stringBuilder.toString();
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (n4 > n2) {
                stringBuilder.append(string2, n2, n4);
            }
            int n5 = n4;
            for (n3 = n5 + 1; n3 < n && !Uri.isAllowed(string2.charAt(n3), string3); ++n3) {
            }
            String string4 = string2.substring(n5, n3);
            byte[] byArray = string4.getBytes(DEFAULT_ENCODING);
            int n6 = byArray.length;
            for (int i = 0; i < n6; ++i) {
                try {
                    stringBuilder.append('%');
                    stringBuilder.append(HEX_DIGITS[(0xF0 & byArray[i]) >> 4]);
                    stringBuilder.append(HEX_DIGITS[0xF & byArray[i]]);
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AssertionError((Object)unsupportedEncodingException);
                }
            }
            n2 = n3;
        }
        if (stringBuilder == null) return string2;
        return stringBuilder.toString();
    }

    public static Uri fromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PathPart pathPart = PathPart.fromDecoded(file.getAbsolutePath());
        return new HierarchicalUri("file", Part.EMPTY, pathPart, Part.NULL, Part.NULL);
    }

    public static Uri fromParts(String string2, String string3, String string4) {
        if (string2 == null) {
            throw new NullPointerException("scheme");
        }
        if (string3 == null) {
            throw new NullPointerException("ssp");
        }
        return new OpaqueUri(string2, Part.fromDecoded(string3), Part.fromDecoded(string4));
    }

    private static boolean isAllowed(char c, String string2) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_-!.~'()*".indexOf(c) != -1 || string2 != null && string2.indexOf(c) != -1;
    }

    public static Uri parse(String string2) {
        return new StringUri(string2);
    }

    public static Uri withAppendedPath(Uri uri, String string2) {
        return uri.buildUpon().appendEncodedPath(string2).build();
    }

    public static void writeToParcel(Parcel parcel, Uri uri) {
        if (uri == null) {
            parcel.writeInt(0);
            return;
        }
        uri.writeToParcel(parcel, 0);
    }

    public abstract Builder buildUpon();

    public void checkFileUriExposed(String string2) {
        if ("file".equals(this.getScheme())) {
            StrictMode.onFileUriExposed(string2);
        }
    }

    @Override
    public int compareTo(Uri uri) {
        return this.toString().compareTo(uri.toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Uri)) {
            return false;
        }
        Uri uri = (Uri)object;
        return this.toString().equals(uri.toString());
    }

    public abstract String getAuthority();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBooleanQueryParameter(String string2, boolean bl) {
        String string3 = this.getQueryParameter(string2);
        if (string3 == null) {
            return bl;
        }
        String string4 = string3.toLowerCase(Locale.ROOT);
        if ("false".equals(string4)) return false;
        if ("0".equals(string4)) return false;
        return true;
    }

    public Uri getCanonicalUri() {
        String string2;
        block5: {
            block4: {
                String string3;
                if (!"file".equals(uri.getScheme())) break block4;
                try {
                    string2 = new File(uri.getPath()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    return uri;
                }
                if (!Environment.isExternalStorageEmulated() || !string2.startsWith(string3 = Environment.getLegacyExternalStorageDirectory().toString())) break block5;
                Uri uri = Uri.fromFile(new File(Environment.getExternalStorageDirectory().toString(), string2.substring(1 + string3.length())));
            }
            return uri;
        }
        return Uri.fromFile(new File(string2));
    }

    public abstract String getEncodedAuthority();

    public abstract String getEncodedFragment();

    public abstract String getEncodedPath();

    public abstract String getEncodedQuery();

    public abstract String getEncodedSchemeSpecificPart();

    public abstract String getEncodedUserInfo();

    public abstract String getFragment();

    public abstract String getHost();

    public abstract String getLastPathSegment();

    public abstract String getPath();

    public abstract List<String> getPathSegments();

    public abstract int getPort();

    public abstract String getQuery();

    /*
     * Enabled aggressive block sorting
     */
    public String getQueryParameter(String string2) {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (string2 == null) {
            throw new NullPointerException("key");
        }
        String string3 = this.getEncodedQuery();
        if (string3 != null) {
            String string4 = Uri.encode(string2, null);
            int n = string3.length();
            int n2 = 0;
            while (true) {
                int n3;
                int n4 = (n3 = string3.indexOf(38, n2)) != -1 ? n3 : n;
                int n5 = string3.indexOf(61, n2);
                if (n5 > n4 || n5 == -1) {
                    n5 = n4;
                }
                if (n5 - n2 == string4.length() && string3.regionMatches(n2, string4, 0, string4.length())) {
                    if (n5 == n4) {
                        return "";
                    }
                    return UriCodec.decode((String)string3.substring(n5 + 1, n4), (boolean)true, (Charset)StandardCharsets.UTF_8, (boolean)false);
                }
                if (n3 == -1) break;
                n2 = n3 + 1;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Set<String> getQueryParameterNames() {
        int n;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        String string2 = this.getEncodedQuery();
        if (string2 == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n2 = 0;
        do {
            int n3;
            n = (n3 = string2.indexOf(38, n2)) == -1 ? string2.length() : n3;
            int n4 = string2.indexOf(61, n2);
            if (n4 > n || n4 == -1) {
                n4 = n;
            }
            linkedHashSet.add(Uri.decode(string2.substring(n2, n4)));
        } while ((n2 = n + 1) < string2.length());
        return Collections.unmodifiableSet(linkedHashSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getQueryParameters(String string2) {
        int n;
        ArrayList<String> arrayList;
        String string3;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException(NOT_HIERARCHICAL);
        }
        if (string2 == null) {
            throw new NullPointerException("key");
        }
        String string4 = this.getEncodedQuery();
        if (string4 == null) {
            return Collections.emptyList();
        }
        try {
            string3 = URLEncoder.encode(string2, DEFAULT_ENCODING);
            arrayList = new ArrayList<String>();
            n = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        while (true) {
            int n2;
            int n3 = (n2 = string4.indexOf(38, n)) != -1 ? n2 : string4.length();
            int n4 = string4.indexOf(61, n);
            if (n4 > n3 || n4 == -1) {
                n4 = n3;
            }
            if (n4 - n == string3.length() && string4.regionMatches(n, string3, 0, string3.length())) {
                if (n4 == n3) {
                    arrayList.add("");
                } else {
                    arrayList.add(Uri.decode(string4.substring(n4 + 1, n3)));
                }
            }
            if (n2 == -1) {
                return Collections.unmodifiableList(arrayList);
            }
            n = n2 + 1;
        }
    }

    public abstract String getScheme();

    public abstract String getSchemeSpecificPart();

    public abstract String getUserInfo();

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isAbsolute() {
        return !this.isRelative();
    }

    public abstract boolean isHierarchical();

    public boolean isOpaque() {
        return !this.isHierarchical();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isPathPrefixMatch(Uri uri) {
        if (Objects.equals(this.getScheme(), uri.getScheme()) && Objects.equals(this.getAuthority(), uri.getAuthority())) {
            List<String> list = this.getPathSegments();
            List<String> list2 = uri.getPathSegments();
            int n = list2.size();
            if (list.size() >= n) {
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return true;
                    }
                    if (!Objects.equals(list.get(n2), list2.get(n2))) break;
                    ++n2;
                }
            }
        }
        return false;
    }

    public abstract boolean isRelative();

    /*
     * Enabled aggressive block sorting
     */
    public Uri normalizeScheme() {
        String string2;
        String string3 = this.getScheme();
        if (string3 == null || string3.equals(string2 = string3.toLowerCase(Locale.ROOT))) {
            return this;
        }
        return this.buildUpon().scheme(string2).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toSafeString() {
        StringBuilder stringBuilder;
        block5: {
            String string2;
            block6: {
                String string3;
                block4: {
                    string3 = this.getScheme();
                    string2 = this.getSchemeSpecificPart();
                    if (string3 == null || !string3.equalsIgnoreCase("tel") && !string3.equalsIgnoreCase("sip") && !string3.equalsIgnoreCase("sms") && !string3.equalsIgnoreCase("smsto") && !string3.equalsIgnoreCase("mailto")) break block4;
                    stringBuilder = new StringBuilder(64);
                    stringBuilder.append(string3);
                    stringBuilder.append(':');
                    if (string2 == null) break block5;
                    break block6;
                }
                StringBuilder stringBuilder2 = new StringBuilder(64);
                if (string3 != null) {
                    stringBuilder2.append(string3);
                    stringBuilder2.append(':');
                }
                if (string2 != null) {
                    stringBuilder2.append(string2);
                }
                return stringBuilder2.toString();
            }
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '-' || c == '@' || c == '.') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('x');
            }
        }
        return stringBuilder.toString();
    }

    public abstract String toString();

    private static abstract class AbstractHierarchicalUri
    extends Uri {
        private volatile String host = Uri.access$300();
        private volatile int port = -2;
        private Part userInfo;

        private AbstractHierarchicalUri() {
        }

        private Part getUserInfoPart() {
            if (this.userInfo == null) {
                Part part;
                this.userInfo = part = Part.fromEncoded(this.parseUserInfo());
                return part;
            }
            return this.userInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String parseHost() {
            String string2;
            String string3 = this.getEncodedAuthority();
            if (string3 == null) {
                return null;
            }
            int n = string3.indexOf(64);
            int n2 = string3.indexOf(58, n);
            if (n2 == -1) {
                string2 = string3.substring(n + 1);
                return AbstractHierarchicalUri.decode(string2);
            }
            string2 = string3.substring(n + 1, n2);
            return AbstractHierarchicalUri.decode(string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int parsePort() {
            String string2 = this.getEncodedAuthority();
            if (string2 == null) {
                return -1;
            }
            int n = string2.indexOf(58, string2.indexOf(64));
            if (n == -1) return -1;
            String string3 = AbstractHierarchicalUri.decode(string2.substring(n + 1));
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Log.w(LOG, "Error parsing port string.", numberFormatException);
                return -1;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private String parseUserInfo() {
            int n;
            String string2 = this.getEncodedAuthority();
            if (string2 == null || (n = string2.indexOf(64)) == -1) {
                return null;
            }
            return string2.substring(0, n);
        }

        @Override
        public final String getEncodedUserInfo() {
            return this.getUserInfoPart().getEncoded();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String getHost() {
            String string2;
            boolean bl = this.host != NOT_CACHED;
            if (bl) {
                return this.host;
            }
            this.host = string2 = this.parseHost();
            return string2;
        }

        @Override
        public String getLastPathSegment() {
            List<String> list = this.getPathSegments();
            int n = list.size();
            if (n == 0) {
                return null;
            }
            return list.get(n - 1);
        }

        @Override
        public int getPort() {
            if (this.port == -2) {
                int n;
                this.port = n = this.parsePort();
                return n;
            }
            return this.port;
        }

        @Override
        public String getUserInfo() {
            return this.getUserInfoPart().getDecoded();
        }
    }

    static abstract class AbstractPart {
        volatile String decoded;
        volatile String encoded;

        AbstractPart(String string2, String string3) {
            this.encoded = string2;
            this.decoded = string3;
        }

        /*
         * Enabled aggressive block sorting
         */
        final String getDecoded() {
            String string2;
            boolean bl = this.decoded != NOT_CACHED;
            if (bl) {
                return this.decoded;
            }
            this.decoded = string2 = Uri.decode(this.encoded);
            return string2;
        }

        abstract String getEncoded();

        /*
         * Enabled aggressive block sorting
         */
        final void writeTo(Parcel parcel) {
            boolean bl = this.encoded != NOT_CACHED;
            boolean bl2 = this.decoded != NOT_CACHED;
            if (bl && bl2) {
                parcel.writeInt(0);
                parcel.writeString(this.encoded);
                parcel.writeString(this.decoded);
                return;
            }
            if (bl) {
                parcel.writeInt(1);
                parcel.writeString(this.encoded);
                return;
            }
            if (bl2) {
                parcel.writeInt(2);
                parcel.writeString(this.decoded);
                return;
            }
            throw new IllegalArgumentException("Neither encoded nor decoded");
        }

        static class Representation {
            static final int BOTH = 0;
            static final int DECODED = 2;
            static final int ENCODED = 1;

            Representation() {
            }
        }
    }

    public static final class Builder {
        private Part authority;
        private Part fragment;
        private Part opaquePart;
        private PathPart path;
        private Part query;
        private String scheme;

        private boolean hasSchemeOrAuthority() {
            return this.scheme != null || this.authority != null && this.authority != Part.NULL;
        }

        public Builder appendEncodedPath(String string2) {
            return this.path(PathPart.appendEncodedSegment(this.path, string2));
        }

        public Builder appendPath(String string2) {
            return this.path(PathPart.appendDecodedSegment(this.path, string2));
        }

        public Builder appendQueryParameter(String string2, String string3) {
            this.opaquePart = null;
            String string4 = Uri.encode(string2, null) + "=" + Uri.encode(string3, null);
            if (this.query == null) {
                this.query = Part.fromEncoded(string4);
                return this;
            }
            String string5 = this.query.getEncoded();
            if (string5 == null || string5.length() == 0) {
                this.query = Part.fromEncoded(string4);
                return this;
            }
            this.query = Part.fromEncoded(string5 + "&" + string4);
            return this;
        }

        Builder authority(Part part) {
            this.opaquePart = null;
            this.authority = part;
            return this;
        }

        public Builder authority(String string2) {
            return this.authority(Part.fromDecoded(string2));
        }

        /*
         * Enabled aggressive block sorting
         */
        public Uri build() {
            if (this.opaquePart != null) {
                if (this.scheme != null) return new OpaqueUri(this.scheme, this.opaquePart, this.fragment);
                throw new UnsupportedOperationException("An opaque URI must have a scheme.");
            }
            PathPart pathPart = this.path;
            if (pathPart != null && pathPart != PathPart.NULL) {
                if (!this.hasSchemeOrAuthority()) return new HierarchicalUri(this.scheme, this.authority, pathPart, this.query, this.fragment);
                pathPart = PathPart.makeAbsolute(pathPart);
                return new HierarchicalUri(this.scheme, this.authority, pathPart, this.query, this.fragment);
            }
            pathPart = PathPart.EMPTY;
            return new HierarchicalUri(this.scheme, this.authority, pathPart, this.query, this.fragment);
        }

        public Builder clearQuery() {
            return this.query((Part)null);
        }

        public Builder encodedAuthority(String string2) {
            return this.authority(Part.fromEncoded(string2));
        }

        public Builder encodedFragment(String string2) {
            return this.fragment(Part.fromEncoded(string2));
        }

        public Builder encodedOpaquePart(String string2) {
            return this.opaquePart(Part.fromEncoded(string2));
        }

        public Builder encodedPath(String string2) {
            return this.path(PathPart.fromEncoded(string2));
        }

        public Builder encodedQuery(String string2) {
            return this.query(Part.fromEncoded(string2));
        }

        Builder fragment(Part part) {
            this.fragment = part;
            return this;
        }

        public Builder fragment(String string2) {
            return this.fragment(Part.fromDecoded(string2));
        }

        Builder opaquePart(Part part) {
            this.opaquePart = part;
            return this;
        }

        public Builder opaquePart(String string2) {
            return this.opaquePart(Part.fromDecoded(string2));
        }

        Builder path(PathPart pathPart) {
            this.opaquePart = null;
            this.path = pathPart;
            return this;
        }

        public Builder path(String string2) {
            return this.path(PathPart.fromDecoded(string2));
        }

        Builder query(Part part) {
            this.opaquePart = null;
            this.query = part;
            return this;
        }

        public Builder query(String string2) {
            return this.query(Part.fromDecoded(string2));
        }

        public Builder scheme(String string2) {
            this.scheme = string2;
            return this;
        }

        public String toString() {
            return this.build().toString();
        }
    }

    private static class HierarchicalUri
    extends AbstractHierarchicalUri {
        static final int TYPE_ID = 3;
        private final Part authority;
        private final Part fragment;
        private final PathPart path;
        private final Part query;
        private final String scheme;
        private Part ssp;
        private volatile String uriString = Uri.access$300();

        private HierarchicalUri(String string2, Part part, PathPart pathPart, Part part2, Part part3) {
            this.scheme = string2;
            this.authority = Part.nonNull(part);
            if (pathPart == null) {
                pathPart = PathPart.NULL;
            }
            this.path = pathPart;
            this.query = Part.nonNull(part2);
            this.fragment = Part.nonNull(part3);
        }

        private void appendSspTo(StringBuilder stringBuilder) {
            String string2;
            String string3 = this.authority.getEncoded();
            if (string3 != null) {
                stringBuilder.append("//").append(string3);
            }
            if ((string2 = this.path.getEncoded()) != null) {
                stringBuilder.append(string2);
            }
            if (!this.query.isEmpty()) {
                stringBuilder.append('?').append(this.query.getEncoded());
            }
        }

        private Part getSsp() {
            if (this.ssp == null) {
                Part part;
                this.ssp = part = Part.fromEncoded(this.makeSchemeSpecificPart());
                return part;
            }
            return this.ssp;
        }

        private String makeSchemeSpecificPart() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendSspTo(stringBuilder);
            return stringBuilder.toString();
        }

        private String makeUriString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.scheme != null) {
                stringBuilder.append(this.scheme).append(':');
            }
            this.appendSspTo(stringBuilder);
            if (!this.fragment.isEmpty()) {
                stringBuilder.append('#').append(this.fragment.getEncoded());
            }
            return stringBuilder.toString();
        }

        static Uri readFrom(Parcel parcel) {
            return new HierarchicalUri(parcel.readString(), Part.readFrom(parcel), PathPart.readFrom(parcel), Part.readFrom(parcel), Part.readFrom(parcel));
        }

        @Override
        public Builder buildUpon() {
            return new Builder().scheme(this.scheme).authority(this.authority).path(this.path).query(this.query).fragment(this.fragment);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return this.authority.getDecoded();
        }

        @Override
        public String getEncodedAuthority() {
            return this.authority.getEncoded();
        }

        @Override
        public String getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return this.path.getEncoded();
        }

        @Override
        public String getEncodedQuery() {
            return this.query.getEncoded();
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        @Override
        public String getFragment() {
            return this.fragment.getDecoded();
        }

        @Override
        public String getPath() {
            return this.path.getDecoded();
        }

        @Override
        public List<String> getPathSegments() {
            return this.path.getPathSegments();
        }

        @Override
        public String getQuery() {
            return this.query.getDecoded();
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        @Override
        public boolean isHierarchical() {
            return true;
        }

        @Override
        public boolean isRelative() {
            return this.scheme == null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString() {
            String string2;
            boolean bl = this.uriString != NOT_CACHED;
            if (bl) {
                return this.uriString;
            }
            this.uriString = string2 = this.makeUriString();
            return string2;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(3);
            parcel.writeString(this.scheme);
            this.authority.writeTo(parcel);
            this.path.writeTo(parcel);
            this.query.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }
    }

    private static class OpaqueUri
    extends Uri {
        static final int TYPE_ID = 2;
        private volatile String cachedString = Uri.access$300();
        private final Part fragment;
        private final String scheme;
        private final Part ssp;

        private OpaqueUri(String string2, Part part, Part part2) {
            this.scheme = string2;
            this.ssp = part;
            if (part2 == null) {
                part2 = Part.NULL;
            }
            this.fragment = part2;
        }

        static Uri readFrom(Parcel parcel) {
            return new OpaqueUri(parcel.readString(), Part.readFrom(parcel), Part.readFrom(parcel));
        }

        @Override
        public Builder buildUpon() {
            return new Builder().scheme(this.scheme).opaquePart(this.ssp).fragment(this.fragment);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return null;
        }

        @Override
        public String getEncodedAuthority() {
            return null;
        }

        @Override
        public String getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return null;
        }

        @Override
        public String getEncodedQuery() {
            return null;
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.ssp.getEncoded();
        }

        @Override
        public String getEncodedUserInfo() {
            return null;
        }

        @Override
        public String getFragment() {
            return this.fragment.getDecoded();
        }

        @Override
        public String getHost() {
            return null;
        }

        @Override
        public String getLastPathSegment() {
            return null;
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public List<String> getPathSegments() {
            return Collections.emptyList();
        }

        @Override
        public int getPort() {
            return -1;
        }

        @Override
        public String getQuery() {
            return null;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.ssp.getDecoded();
        }

        @Override
        public String getUserInfo() {
            return null;
        }

        @Override
        public boolean isHierarchical() {
            return false;
        }

        @Override
        public boolean isRelative() {
            return this.scheme == null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toString() {
            String string2;
            boolean bl = this.cachedString != NOT_CACHED;
            if (bl) {
                return this.cachedString;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.scheme).append(':');
            stringBuilder.append(this.getEncodedSchemeSpecificPart());
            if (!this.fragment.isEmpty()) {
                stringBuilder.append('#').append(this.fragment.getEncoded());
            }
            this.cachedString = string2 = stringBuilder.toString();
            return string2;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(2);
            parcel.writeString(this.scheme);
            this.ssp.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }
    }

    static class Part
    extends AbstractPart {
        static final Part EMPTY;
        static final Part NULL;

        static {
            NULL = new EmptyPart(null);
            EMPTY = new EmptyPart("");
        }

        private Part(String string2, String string3) {
            super(string2, string3);
        }

        static Part from(String string2, String string3) {
            if (string2 == null) {
                return NULL;
            }
            if (string2.length() == 0) {
                return EMPTY;
            }
            if (string3 == null) {
                return NULL;
            }
            if (string3.length() == 0) {
                return EMPTY;
            }
            return new Part(string2, string3);
        }

        static Part fromDecoded(String string2) {
            return Part.from(NOT_CACHED, string2);
        }

        static Part fromEncoded(String string2) {
            return Part.from(string2, NOT_CACHED);
        }

        static Part nonNull(Part part) {
            if (part == null) {
                part = NULL;
            }
            return part;
        }

        static Part readFrom(Parcel parcel) {
            int n = parcel.readInt();
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Unknown representation: " + n);
                }
                case 0: {
                    return Part.from(parcel.readString(), parcel.readString());
                }
                case 1: {
                    return Part.fromEncoded(parcel.readString());
                }
                case 2: 
            }
            return Part.fromDecoded(parcel.readString());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String getEncoded() {
            String string2;
            boolean bl = this.encoded != NOT_CACHED;
            if (bl) {
                return this.encoded;
            }
            this.encoded = string2 = Uri.encode(this.decoded);
            return string2;
        }

        boolean isEmpty() {
            return false;
        }

        private static class EmptyPart
        extends Part {
            public EmptyPart(String string2) {
                super(string2, string2);
            }

            @Override
            boolean isEmpty() {
                return true;
            }
        }
    }

    static class PathPart
    extends AbstractPart {
        static final PathPart EMPTY;
        static final PathPart NULL;
        private PathSegments pathSegments;

        static {
            NULL = new PathPart(null, null);
            EMPTY = new PathPart("", "");
        }

        private PathPart(String string2, String string3) {
            super(string2, string3);
        }

        static PathPart appendDecodedSegment(PathPart pathPart, String string2) {
            return PathPart.appendEncodedSegment(pathPart, Uri.encode(string2));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static PathPart appendEncodedSegment(PathPart pathPart, String string2) {
            String string3;
            int n;
            if (pathPart == null) {
                return PathPart.fromEncoded("/" + string2);
            }
            String string4 = pathPart.getEncoded();
            if (string4 == null) {
                string4 = "";
            }
            if ((n = string4.length()) == 0) {
                string3 = "/" + string2;
                return PathPart.fromEncoded(string3);
            }
            if (string4.charAt(n - 1) == '/') {
                string3 = string4 + string2;
                return PathPart.fromEncoded(string3);
            }
            string3 = string4 + "/" + string2;
            return PathPart.fromEncoded(string3);
        }

        static PathPart from(String string2, String string3) {
            if (string2 == null) {
                return NULL;
            }
            if (string2.length() == 0) {
                return EMPTY;
            }
            return new PathPart(string2, string3);
        }

        static PathPart fromDecoded(String string2) {
            return PathPart.from(NOT_CACHED, string2);
        }

        static PathPart fromEncoded(String string2) {
            return PathPart.from(string2, NOT_CACHED);
        }

        /*
         * Enabled aggressive block sorting
         */
        static PathPart makeAbsolute(PathPart pathPart) {
            String string2;
            boolean bl = true;
            boolean bl2 = pathPart.encoded != NOT_CACHED ? bl : false;
            String string3 = bl2 ? pathPart.encoded : pathPart.decoded;
            if (string3 == null) return pathPart;
            if (string3.length() == 0) return pathPart;
            if (string3.startsWith("/")) {
                return pathPart;
            }
            String string4 = bl2 ? "/" + pathPart.encoded : NOT_CACHED;
            if (pathPart.decoded == NOT_CACHED) {
                bl = false;
            }
            if (bl) {
                string2 = "/" + pathPart.decoded;
                return new PathPart(string4, string2);
            }
            string2 = NOT_CACHED;
            return new PathPart(string4, string2);
        }

        static PathPart readFrom(Parcel parcel) {
            int n = parcel.readInt();
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Bad representation: " + n);
                }
                case 0: {
                    return PathPart.from(parcel.readString(), parcel.readString());
                }
                case 1: {
                    return PathPart.fromEncoded(parcel.readString());
                }
                case 2: 
            }
            return PathPart.fromDecoded(parcel.readString());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String getEncoded() {
            String string2;
            boolean bl = this.encoded != NOT_CACHED;
            if (bl) {
                return this.encoded;
            }
            this.encoded = string2 = Uri.encode(this.decoded, "/");
            return string2;
        }

        PathSegments getPathSegments() {
            PathSegments pathSegments;
            int n;
            if (this.pathSegments != null) {
                return this.pathSegments;
            }
            String string2 = this.getEncoded();
            if (string2 == null) {
                PathSegments pathSegments2;
                this.pathSegments = pathSegments2 = PathSegments.EMPTY;
                return pathSegments2;
            }
            PathSegmentsBuilder pathSegmentsBuilder = new PathSegmentsBuilder();
            int n2 = 0;
            while ((n = string2.indexOf(47, n2)) > -1) {
                if (n2 < n) {
                    pathSegmentsBuilder.add(Uri.decode(string2.substring(n2, n)));
                }
                n2 = n + 1;
            }
            if (n2 < string2.length()) {
                pathSegmentsBuilder.add(Uri.decode(string2.substring(n2)));
            }
            this.pathSegments = pathSegments = pathSegmentsBuilder.build();
            return pathSegments;
        }
    }

    static class PathSegments
    extends AbstractList<String>
    implements RandomAccess {
        static final PathSegments EMPTY = new PathSegments(null, 0);
        final String[] segments;
        final int size;

        PathSegments(String[] stringArray, int n) {
            this.segments = stringArray;
            this.size = n;
        }

        @Override
        public String get(int n) {
            if (n >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.segments[n];
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class PathSegmentsBuilder {
        String[] segments;
        int size = 0;

        PathSegmentsBuilder() {
        }

        /*
         * Enabled aggressive block sorting
         */
        void add(String string2) {
            if (this.segments == null) {
                this.segments = new String[4];
            } else if (1 + this.size == this.segments.length) {
                String[] stringArray = new String[2 * this.segments.length];
                System.arraycopy(this.segments, 0, stringArray, 0, this.segments.length);
                this.segments = stringArray;
            }
            String[] stringArray = this.segments;
            int n = this.size;
            this.size = n + 1;
            stringArray[n] = string2;
        }

        PathSegments build() {
            if (this.segments == null) {
                return PathSegments.EMPTY;
            }
            try {
                PathSegments pathSegments = new PathSegments(this.segments, this.size);
                return pathSegments;
            }
            finally {
                this.segments = null;
            }
        }
    }

    private static class StringUri
    extends AbstractHierarchicalUri {
        static final int TYPE_ID = 1;
        private Part authority;
        private volatile int cachedFsi = -2;
        private volatile int cachedSsi = -2;
        private Part fragment;
        private PathPart path;
        private Part query;
        private volatile String scheme = Uri.access$300();
        private Part ssp;
        private final String uriString;

        private StringUri(String string2) {
            if (string2 == null) {
                throw new NullPointerException("uriString");
            }
            this.uriString = string2;
        }

        private int findFragmentSeparator() {
            if (this.cachedFsi == -2) {
                int n;
                this.cachedFsi = n = this.uriString.indexOf(35, this.findSchemeSeparator());
                return n;
            }
            return this.cachedFsi;
        }

        private int findSchemeSeparator() {
            if (this.cachedSsi == -2) {
                int n;
                this.cachedSsi = n = this.uriString.indexOf(58);
                return n;
            }
            return this.cachedSsi;
        }

        private Part getAuthorityPart() {
            if (this.authority == null) {
                Part part;
                this.authority = part = Part.fromEncoded(StringUri.parseAuthority(this.uriString, this.findSchemeSeparator()));
                return part;
            }
            return this.authority;
        }

        private Part getFragmentPart() {
            if (this.fragment == null) {
                Part part;
                this.fragment = part = Part.fromEncoded(this.parseFragment());
                return part;
            }
            return this.fragment;
        }

        private PathPart getPathPart() {
            if (this.path == null) {
                PathPart pathPart;
                this.path = pathPart = PathPart.fromEncoded(this.parsePath());
                return pathPart;
            }
            return this.path;
        }

        private Part getQueryPart() {
            if (this.query == null) {
                Part part;
                this.query = part = Part.fromEncoded(this.parseQuery());
                return part;
            }
            return this.query;
        }

        private Part getSsp() {
            if (this.ssp == null) {
                Part part;
                this.ssp = part = Part.fromEncoded(this.parseSsp());
                return part;
            }
            return this.ssp;
        }

        static String parseAuthority(String string2, int n) {
            int n2 = string2.length();
            if (n2 > n + 2 && string2.charAt(n + 1) == '/' && string2.charAt(n + 2) == '/') {
                int n3;
                block3: for (n3 = n + 3; n3 < n2; ++n3) {
                    switch (string2.charAt(n3)) {
                        default: {
                            continue block3;
                        }
                        case '#': 
                        case '/': 
                        case '?': {
                            break block3;
                        }
                    }
                }
                return string2.substring(n + 3, n3);
            }
            return null;
        }

        private String parseFragment() {
            int n = this.findFragmentSeparator();
            if (n == -1) {
                return null;
            }
            return this.uriString.substring(n + 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private String parsePath() {
            String string2 = this.uriString;
            int n = this.findSchemeSeparator();
            if (n <= -1) return StringUri.parsePath(string2, n);
            if (n + 1 == string2.length()) {
                return null;
            }
            boolean bl = false;
            if (bl) return null;
            if (string2.charAt(n + 1) == '/') return StringUri.parsePath(string2, n);
            return null;
        }

        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * Enabled aggressive block sorting
         */
        static String parsePath(String string2, int n) {
            int n2;
            int n3;
            int n4 = string2.length();
            if (n4 <= n + 2 || string2.charAt(n + 1) != '/' || string2.charAt(n + 2) != '/') {
                n3 = n + 1;
            } else {
                block7: for (n3 = n + 3; n3 < n4; ++n3) {
                    switch (string2.charAt(n3)) {
                        default: {
                            continue block7;
                        }
                        case '#': 
                        case '?': {
                            return "";
                        }
                        case '/': {
                            break block7;
                        }
                    }
                }
            }
            block8: for (n2 = n3; n2 < n4; ++n2) {
                switch (string2.charAt(n2)) {
                    default: {
                        continue block8;
                    }
                    case '#': 
                    case '?': {
                        return string2.substring(n3, n2);
                    }
                }
            }
            return string2.substring(n3, n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private String parseQuery() {
            int n;
            int n2;
            block5: {
                block4: {
                    n2 = this.uriString.indexOf(63, this.findSchemeSeparator());
                    if (n2 == -1) break block4;
                    n = this.findFragmentSeparator();
                    if (n == -1) {
                        return this.uriString.substring(n2 + 1);
                    }
                    if (n >= n2) break block5;
                }
                return null;
            }
            return this.uriString.substring(n2 + 1, n);
        }

        private String parseScheme() {
            int n = this.findSchemeSeparator();
            if (n == -1) {
                return null;
            }
            return this.uriString.substring(0, n);
        }

        private String parseSsp() {
            int n = this.findSchemeSeparator();
            int n2 = this.findFragmentSeparator();
            if (n2 == -1) {
                return this.uriString.substring(n + 1);
            }
            return this.uriString.substring(n + 1, n2);
        }

        static Uri readFrom(Parcel parcel) {
            return new StringUri(parcel.readString());
        }

        @Override
        public Builder buildUpon() {
            if (this.isHierarchical()) {
                return new Builder().scheme(this.getScheme()).authority(this.getAuthorityPart()).path(this.getPathPart()).query(this.getQueryPart()).fragment(this.getFragmentPart());
            }
            return new Builder().scheme(this.getScheme()).opaquePart(this.getSsp()).fragment(this.getFragmentPart());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public String getAuthority() {
            return this.getAuthorityPart().getDecoded();
        }

        @Override
        public String getEncodedAuthority() {
            return this.getAuthorityPart().getEncoded();
        }

        @Override
        public String getEncodedFragment() {
            return this.getFragmentPart().getEncoded();
        }

        @Override
        public String getEncodedPath() {
            return this.getPathPart().getEncoded();
        }

        @Override
        public String getEncodedQuery() {
            return this.getQueryPart().getEncoded();
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        @Override
        public String getFragment() {
            return this.getFragmentPart().getDecoded();
        }

        @Override
        public String getPath() {
            return this.getPathPart().getDecoded();
        }

        @Override
        public List<String> getPathSegments() {
            return this.getPathPart().getPathSegments();
        }

        @Override
        public String getQuery() {
            return this.getQueryPart().getDecoded();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String getScheme() {
            String string2;
            boolean bl = this.scheme != NOT_CACHED;
            if (bl) {
                return this.scheme;
            }
            this.scheme = string2 = this.parseScheme();
            return string2;
        }

        @Override
        public String getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isHierarchical() {
            block5: {
                block4: {
                    int n = this.findSchemeSeparator();
                    if (n == -1) break block4;
                    if (this.uriString.length() == n + 1) {
                        return false;
                    }
                    if (this.uriString.charAt(n + 1) != '/') break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isRelative() {
            return this.findSchemeSeparator() == -1;
        }

        @Override
        public String toString() {
            return this.uriString;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(1);
            parcel.writeString(this.uriString);
        }
    }
}

