/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.ErrorStrings;
import android.net.http.HttpConnection;
import android.net.http.HttpsConnection;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.os.SystemClock;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

abstract class Connection {
    private static final int DONE = 3;
    private static final int DRAIN = 2;
    private static final String HTTP_CONNECTION = "http.connection";
    private static final int MAX_PIPE = 3;
    private static final int MIN_PIPE = 2;
    private static final int READ = 1;
    private static final int RETRY_REQUEST_LIMIT = 2;
    private static final int SEND = 0;
    static final int SOCKET_TIMEOUT = 60000;
    private static int STATE_CANCEL_REQUESTED;
    private static int STATE_NORMAL;
    private static final String[] states;
    private int mActive = STATE_NORMAL;
    private byte[] mBuf;
    private boolean mCanPersist;
    protected SslCertificate mCertificate = null;
    Context mContext;
    HttpHost mHost;
    protected AndroidHttpClientConnection mHttpClientConnection = null;
    private HttpContext mHttpContext;
    RequestFeeder mRequestFeeder;

    static {
        states = new String[]{"SEND", "READ", "DRAIN", "DONE"};
        STATE_NORMAL = 0;
        STATE_CANCEL_REQUESTED = 1;
    }

    protected Connection(Context context, HttpHost httpHost, RequestFeeder requestFeeder) {
        this.mContext = context;
        this.mHost = httpHost;
        this.mRequestFeeder = requestFeeder;
        this.mCanPersist = false;
        this.mHttpContext = new BasicHttpContext(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clearPipe(LinkedList<Request> linkedList) {
        boolean bl = true;
        RequestFeeder requestFeeder = this.mRequestFeeder;
        synchronized (requestFeeder) {
            while (!linkedList.isEmpty()) {
                Request request = linkedList.removeLast();
                this.mRequestFeeder.requeueRequest(request);
                bl = false;
            }
            if (!bl) return bl;
            if (this.mRequestFeeder.haveRequest(this.mHost)) return false;
            return true;
        }
    }

    static Connection getConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        if (httpHost.getSchemeName().equals("http")) {
            return new HttpConnection(context, httpHost, requestFeeder);
        }
        return new HttpsConnection(context, httpHost, httpHost2, requestFeeder);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean httpFailure(Request request, int n, Exception exception) {
        int n2;
        boolean bl = true;
        request.mFailCount = n2 = 1 + request.mFailCount;
        if (n2 >= 2) {
            Throwable throwable;
            bl = false;
            String string2 = n < 0 ? ErrorStrings.getString(n, this.mContext) : ((throwable = exception.getCause()) != null ? throwable.toString() : exception.getMessage());
            request.mEventHandler.error(n, string2);
            request.complete();
        }
        this.closeConnection();
        this.mHttpContext.removeAttribute(HTTP_CONNECTION);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean keepAlive(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n, HttpContext httpContext) {
        boolean bl = true;
        org.apache.http.HttpConnection httpConnection = (org.apache.http.HttpConnection)httpContext.getAttribute(HTTP_CONNECTION);
        if (httpConnection != null && !httpConnection.isOpen()) {
            return false;
        }
        if (httpEntity != null && httpEntity.getContentLength() < 0L) {
            if (!httpEntity.isChunked()) return false;
            if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) return false;
        }
        if (n == bl) return false;
        if (n == 2) {
            return bl;
        }
        if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) return false;
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openHttpConnection(Request request) {
        int n;
        boolean bl = true;
        SystemClock.uptimeMillis();
        try {
            this.mCertificate = null;
            this.mHttpClientConnection = this.openConnection(request);
            if (this.mHttpClientConnection == null) {
                request.mFailCount = 2;
                return false;
            }
            this.mHttpClientConnection.setSocketTimeout(60000);
            this.mHttpContext.setAttribute(HTTP_CONNECTION, this.mHttpClientConnection);
            n = 0;
            Object var7_4 = null;
        }
        catch (UnknownHostException unknownHostException) {
            n = -2;
            UnknownHostException unknownHostException2 = unknownHostException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = -6;
            request.mFailCount = 2;
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
        }
        catch (SSLConnectionClosedByUserException sSLConnectionClosedByUserException) {
            request.mFailCount = 2;
            return false;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            request.mFailCount = 2;
            n = -11;
            SSLHandshakeException sSLHandshakeException2 = sSLHandshakeException;
        }
        catch (IOException iOException) {
            n = -6;
            IOException iOException2 = iOException;
        }
        if (n == 0) {
            return bl;
        }
        if (request.mFailCount < 2) {
            this.mRequestFeeder.requeueRequest(request);
            request.mFailCount = 1 + request.mFailCount;
        } else {
            void var7_9;
            this.httpFailure(request, n, (Exception)var7_9);
        }
        if (n != 0) return false;
        return bl;
    }

    void cancel() {
        this.mActive = STATE_CANCEL_REQUESTED;
        this.closeConnection();
    }

    abstract void closeConnection();

    byte[] getBuf() {
        if (this.mBuf == null) {
            this.mBuf = new byte[8192];
        }
        return this.mBuf;
    }

    boolean getCanPersist() {
        return this.mCanPersist;
    }

    SslCertificate getCertificate() {
        return this.mCertificate;
    }

    HttpHost getHost() {
        return this.mHost;
    }

    HttpContext getHttpContext() {
        return this.mHttpContext;
    }

    abstract String getScheme();

    abstract AndroidHttpClientConnection openConnection(Request var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processRequests(Request request) {
        int n = 0;
        Exception exception = null;
        LinkedList<Request> linkedList = new LinkedList<Request>();
        int n2 = 2;
        int n3 = 3;
        int n4 = 0;
        block14: while (n4 != 3) {
            if (this.mActive == STATE_CANCEL_REQUESTED) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                this.mActive = STATE_NORMAL;
            }
            switch (n4) {
                default: {
                    continue block14;
                }
                case 0: {
                    Request request2;
                    if (linkedList.size() == n3) {
                        n4 = 1;
                        continue block14;
                    }
                    if (request == null) {
                        request2 = this.mRequestFeeder.getRequest(this.mHost);
                    } else {
                        request2 = request;
                        request = null;
                    }
                    if (request2 == null) {
                        n4 = 2;
                        continue block14;
                    }
                    request2.setConnection(this);
                    if (request2.mCancelled) {
                        request2.complete();
                        continue block14;
                    }
                    if (!(this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen() || this.openHttpConnection(request2))) {
                        return;
                    }
                    request2.mEventHandler.certificate(this.mCertificate);
                    try {
                        request2.sendRequest(this.mHttpClientConnection);
                    }
                    catch (HttpException httpException) {
                        exception = httpException;
                        n = -1;
                    }
                    catch (IOException iOException) {
                        exception = iOException;
                        n = -7;
                    }
                    catch (IllegalStateException illegalStateException) {
                        exception = illegalStateException;
                        n = -7;
                    }
                    if (exception != null) {
                        if (this.httpFailure(request2, n, exception) && !request2.mCancelled) {
                            linkedList.addLast(request2);
                        }
                        if (this.clearPipe(linkedList)) {
                            return;
                        }
                        n4 = 0;
                        n2 = n3 = 1;
                        exception = null;
                        continue block14;
                    }
                    linkedList.addLast(request2);
                    if (this.mCanPersist) continue block14;
                    n4 = 1;
                    continue block14;
                }
                case 1: 
                case 2: 
            }
            boolean bl = !this.mRequestFeeder.haveRequest(this.mHost);
            int n5 = linkedList.size();
            if (n4 != 2 && n5 < n2 && !bl && this.mCanPersist) {
                n4 = 0;
                continue;
            }
            if (n5 == 0) {
                if (bl) {
                    return;
                }
                n4 = 0;
                continue;
            }
            Request request3 = (Request)linkedList.removeFirst();
            try {
                request3.readResponse(this.mHttpClientConnection);
            }
            catch (ParseException parseException) {
                exception = parseException;
                n = -7;
            }
            catch (IOException iOException) {
                exception = iOException;
                n = -7;
            }
            catch (IllegalStateException illegalStateException) {
                exception = illegalStateException;
                n = -7;
            }
            if (exception != null) {
                if (this.httpFailure(request3, n, exception) && !request3.mCancelled) {
                    request3.reset();
                    linkedList.addFirst(request3);
                }
                exception = null;
                this.mCanPersist = false;
            }
            if (this.mCanPersist) continue;
            this.closeConnection();
            this.mHttpContext.removeAttribute(HTTP_CONNECTION);
            this.clearPipe(linkedList);
            n2 = n3 = 1;
            n4 = 0;
        }
        return;
    }

    void setCanPersist(HttpEntity httpEntity, ProtocolVersion protocolVersion, int n) {
        this.mCanPersist = this.keepAlive(httpEntity, protocolVersion, n, this.mHttpContext);
    }

    void setCanPersist(boolean bl) {
        this.mCanPersist = bl;
    }

    public String toString() {
        synchronized (this) {
            String string2 = this.mHost.toString();
            return string2;
        }
    }
}

