/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.AndroidHttpClientConnection;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.RequestContent;

class Request {
    private static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "content-length";
    private static final String HOST_HEADER = "Host";
    private static RequestContent requestContentProcessor = new RequestContent();
    private int mBodyLength;
    private InputStream mBodyProvider;
    volatile boolean mCancelled = false;
    private final Object mClientResource = new Object();
    private Connection mConnection;
    EventHandler mEventHandler;
    int mFailCount = 0;
    HttpHost mHost;
    BasicHttpRequest mHttpRequest;
    private boolean mLoadingPaused = false;
    String mPath;
    HttpHost mProxyHost;
    private int mReceivedBytes = 0;

    /*
     * Enabled aggressive block sorting
     */
    Request(String string2, HttpHost httpHost, HttpHost httpHost2, String string3, InputStream inputStream, int n, EventHandler eventHandler, Map<String, String> map) {
        this.mEventHandler = eventHandler;
        this.mHost = httpHost;
        this.mProxyHost = httpHost2;
        this.mPath = string3;
        this.mBodyProvider = inputStream;
        this.mBodyLength = n;
        if (inputStream == null && !"POST".equalsIgnoreCase(string2)) {
            this.mHttpRequest = new BasicHttpRequest(string2, this.getUri());
        } else {
            this.mHttpRequest = new BasicHttpEntityEnclosingRequest(string2, this.getUri());
            if (inputStream != null) {
                this.setBodyProvider(inputStream, n);
            }
        }
        this.addHeader(HOST_HEADER, this.getHostPort());
        this.addHeader(ACCEPT_ENCODING_HEADER, "gzip");
        this.addHeaders(map);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean canResponseHaveBody(HttpRequest httpRequest, int n) {
        return !"HEAD".equalsIgnoreCase(httpRequest.getRequestLine().getMethod()) && n >= 200 && n != 204 && n != 304;
    }

    private void setBodyProvider(InputStream inputStream, int n) {
        if (!inputStream.markSupported()) {
            throw new IllegalArgumentException("bodyProvider must support mark()");
        }
        inputStream.mark(Integer.MAX_VALUE);
        ((BasicHttpEntityEnclosingRequest)this.mHttpRequest).setEntity(new InputStreamEntity(inputStream, n));
    }

    void addHeader(String string2, String string3) {
        if (string2 == null) {
            HttpLog.e("Null http header name");
            throw new NullPointerException("Null http header name");
        }
        if (string3 == null || string3.length() == 0) {
            String string4 = "Null or empty value for header \"" + string2 + "\"";
            HttpLog.e(string4);
            throw new RuntimeException(string4);
        }
        this.mHttpRequest.addHeader(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    void addHeaders(Map<String, String> map) {
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    void cancel() {
        synchronized (this) {
            this.mLoadingPaused = false;
            this.notify();
            this.mCancelled = true;
            if (this.mConnection != null) {
                this.mConnection.cancel();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void complete() {
        Object object = this.mClientResource;
        synchronized (object) {
            this.mClientResource.notifyAll();
            return;
        }
    }

    void error(int n, int n2) {
        this.mEventHandler.error(n, this.mConnection.mContext.getText(n2).toString());
    }

    EventHandler getEventHandler() {
        return this.mEventHandler;
    }

    String getHostPort() {
        String string2 = this.mHost.getSchemeName();
        int n = this.mHost.getPort();
        if (n != 80 && string2.equals("http") || n != 443 && string2.equals("https")) {
            return this.mHost.toHostString();
        }
        return this.mHost.getHostName();
    }

    String getUri() {
        if (this.mProxyHost == null || this.mHost.getSchemeName().equals("https")) {
            return this.mPath;
        }
        return this.mHost.getSchemeName() + "://" + this.getHostPort() + this.mPath;
    }

    public void handleSslErrorResponse(boolean bl) {
        HttpsConnection httpsConnection = (HttpsConnection)this.mConnection;
        if (httpsConnection != null) {
            httpsConnection.restartConnection(bl);
        }
    }

    /*
     * Exception decompiling
     */
    void readResponse(AndroidHttpClientConnection var1_1) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [19 : 284->286)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reset() {
        this.mHttpRequest.removeHeaders(CONTENT_LENGTH_HEADER);
        if (this.mBodyProvider != null) {
            try {
                this.mBodyProvider.reset();
            }
            catch (IOException iOException) {}
            this.setBodyProvider(this.mBodyProvider, this.mBodyLength);
        }
        if (this.mReceivedBytes > 0) {
            this.mFailCount = 0;
            HttpLog.v("*** Request.reset() to range:" + this.mReceivedBytes);
            this.mHttpRequest.setHeader("Range", "bytes=" + this.mReceivedBytes + "-");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void sendRequest(AndroidHttpClientConnection androidHttpClientConnection) throws HttpException, IOException {
        block3: {
            block2: {
                if (this.mCancelled) break block2;
                requestContentProcessor.process(this.mHttpRequest, this.mConnection.getHttpContext());
                androidHttpClientConnection.sendRequestHeader(this.mHttpRequest);
                if (this.mHttpRequest instanceof HttpEntityEnclosingRequest) break block3;
            }
            return;
        }
        androidHttpClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)((Object)this.mHttpRequest));
    }

    void setConnection(Connection connection) {
        this.mConnection = connection;
    }

    void setLoadingPaused(boolean bl) {
        synchronized (this) {
            this.mLoadingPaused = bl;
            if (!this.mLoadingPaused) {
                this.notify();
            }
            return;
        }
    }

    public String toString() {
        return this.mPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitUntilComplete() {
        Object object = this.mClientResource;
        synchronized (object) {
            try {
                this.mClientResource.wait();
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }
}

