/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;

public class ScanResult
implements Parcelable {
    public static final int AUTHENTICATION_ERROR = 128;
    public static final int AUTO_JOIN_DISABLED = 32;
    public static final int AUTO_ROAM_DISABLED = 16;
    public static final Parcelable.Creator<ScanResult> CREATOR = new Parcelable.Creator<ScanResult>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ScanResult createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            WifiSsid wifiSsid = null;
            if (n == 1) {
                wifiSsid = WifiSsid.CREATOR.createFromParcel(parcel);
            }
            ScanResult scanResult = new ScanResult(wifiSsid, parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readLong(), parcel.readInt(), parcel.readInt());
            scanResult.seen = parcel.readLong();
            scanResult.autoJoinStatus = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            scanResult.untrusted = bl;
            scanResult.numConnection = parcel.readInt();
            scanResult.numUsage = parcel.readInt();
            scanResult.numIpConfigFailures = parcel.readInt();
            scanResult.isAutoJoinCandidate = parcel.readInt();
            int n2 = parcel.readInt();
            if (n2 != 0) {
                scanResult.informationElements = new InformationElement[n2];
                for (int i = 0; i < n2; ++i) {
                    scanResult.informationElements[i] = new InformationElement();
                    scanResult.informationElements[i].id = parcel.readInt();
                    int n3 = parcel.readInt();
                    scanResult.informationElements[i].bytes = new byte[n3];
                    parcel.readByteArray(scanResult.informationElements[i].bytes);
                }
            }
            return scanResult;
        }

        public ScanResult[] newArray(int n) {
            return new ScanResult[n];
        }
    };
    public static final int ENABLED = 0;
    public static final int UNSPECIFIED = -1;
    public String BSSID;
    public String SSID;
    public int autoJoinStatus;
    public long blackListTimestamp;
    public String capabilities;
    public int distanceCm;
    public int distanceSdCm;
    public int frequency;
    public InformationElement[] informationElements;
    public int isAutoJoinCandidate;
    public int level;
    public int numConnection;
    public int numIpConfigFailures;
    public int numUsage;
    public long seen;
    public long timestamp;
    public boolean untrusted;
    public WifiSsid wifiSsid;

    public ScanResult() {
    }

    public ScanResult(ScanResult scanResult) {
        if (scanResult != null) {
            this.wifiSsid = scanResult.wifiSsid;
            this.SSID = scanResult.SSID;
            this.BSSID = scanResult.BSSID;
            this.capabilities = scanResult.capabilities;
            this.level = scanResult.level;
            this.frequency = scanResult.frequency;
            this.timestamp = scanResult.timestamp;
            this.distanceCm = scanResult.distanceCm;
            this.distanceSdCm = scanResult.distanceSdCm;
            this.seen = scanResult.seen;
            this.autoJoinStatus = scanResult.autoJoinStatus;
            this.untrusted = scanResult.untrusted;
            this.numConnection = scanResult.numConnection;
            this.numUsage = scanResult.numUsage;
            this.numIpConfigFailures = scanResult.numIpConfigFailures;
            this.isAutoJoinCandidate = scanResult.isAutoJoinCandidate;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScanResult(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l) {
        this.wifiSsid = wifiSsid;
        String string4 = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.SSID = string4;
        this.BSSID = string2;
        this.capabilities = string3;
        this.level = n;
        this.frequency = n2;
        this.timestamp = l;
        this.distanceCm = -1;
        this.distanceSdCm = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ScanResult(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l, int n3, int n4) {
        this.wifiSsid = wifiSsid;
        String string4 = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.SSID = string4;
        this.BSSID = string2;
        this.capabilities = string3;
        this.level = n;
        this.frequency = n2;
        this.timestamp = l;
        this.distanceCm = n3;
        this.distanceSdCm = n4;
    }

    public static boolean is24GHz(int n) {
        return n > 2400 && n < 2500;
    }

    public static boolean is5GHz(int n) {
        return n > 4900 && n < 5900;
    }

    public void averageRssi(int n, long l, int n2) {
        if (this.seen == 0L) {
            this.seen = System.currentTimeMillis();
        }
        long l2 = this.seen - l;
        if (l > 0L && l2 > 0L && l2 < (long)(n2 / 2)) {
            double d = 0.5 - (double)l2 / (double)n2;
            this.level = (int)((double)this.level * (1.0 - d) + d * (double)n);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.frequency);
    }

    public boolean is5GHz() {
        return ScanResult.is5GHz(this.frequency);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAutoJoinStatus(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n == 0) {
            this.blackListTimestamp = 0L;
        } else if (n > this.autoJoinStatus) {
            this.blackListTimestamp = System.currentTimeMillis();
        }
        this.autoJoinStatus = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "<none>";
        StringBuffer stringBuffer2 = stringBuffer.append("SSID: ");
        Object object = this.wifiSsid == null ? "<unknown ssid>" : this.wifiSsid;
        StringBuffer stringBuffer3 = stringBuffer2.append(object).append(", BSSID: ");
        String string3 = this.BSSID == null ? string2 : this.BSSID;
        StringBuffer stringBuffer4 = stringBuffer3.append(string3).append(", capabilities: ");
        if (this.capabilities != null) {
            string2 = this.capabilities;
        }
        stringBuffer4.append(string2).append(", level: ").append(this.level).append(", frequency: ").append(this.frequency).append(", timestamp: ").append(this.timestamp);
        StringBuffer stringBuffer5 = stringBuffer.append(", distance: ");
        Object object2 = this.distanceCm != -1 ? Integer.valueOf(this.distanceCm) : "?";
        stringBuffer5.append(object2).append("(cm)");
        StringBuffer stringBuffer6 = stringBuffer.append(", distanceSd: ");
        Object object3 = this.distanceSdCm != -1 ? Integer.valueOf(this.distanceSdCm) : "?";
        stringBuffer6.append(object3).append("(cm)");
        if (this.autoJoinStatus != 0) {
            stringBuffer.append(", status: ").append(this.autoJoinStatus);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        if (this.wifiSsid != null) {
            parcel.writeInt(n2);
            this.wifiSsid.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString(this.BSSID);
        parcel.writeString(this.capabilities);
        parcel.writeInt(this.level);
        parcel.writeInt(this.frequency);
        parcel.writeLong(this.timestamp);
        parcel.writeInt(this.distanceCm);
        parcel.writeInt(this.distanceSdCm);
        parcel.writeLong(this.seen);
        parcel.writeInt(this.autoJoinStatus);
        if (!this.untrusted) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeInt(this.numConnection);
        parcel.writeInt(this.numUsage);
        parcel.writeInt(this.numIpConfigFailures);
        parcel.writeInt(this.isAutoJoinCandidate);
        if (this.informationElements != null) {
            parcel.writeInt(this.informationElements.length);
            for (int i = 0; i < this.informationElements.length; ++i) {
                parcel.writeInt(this.informationElements[i].id);
                parcel.writeInt(this.informationElements[i].bytes.length);
                parcel.writeByteArray(this.informationElements[i].bytes);
            }
            return;
        } else {
            parcel.writeInt(0);
        }
    }

    public static class InformationElement {
        public byte[] bytes;
        public int id;

        public InformationElement() {
        }

        public InformationElement(InformationElement informationElement) {
            this.id = informationElement.id;
            this.bytes = (byte[])informationElement.bytes.clone();
        }
    }
}

