/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiNetworkConnectionStatistics;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.HashMap;

public class WifiConnectionStatistics
implements Parcelable {
    public static final Parcelable.Creator<WifiConnectionStatistics> CREATOR = new Parcelable.Creator<WifiConnectionStatistics>(){

        @Override
        public WifiConnectionStatistics createFromParcel(Parcel parcel) {
            WifiConnectionStatistics wifiConnectionStatistics = new WifiConnectionStatistics();
            wifiConnectionStatistics.num24GhzConnected = parcel.readInt();
            wifiConnectionStatistics.num5GhzConnected = parcel.readInt();
            wifiConnectionStatistics.numAutoJoinAttempt = parcel.readInt();
            wifiConnectionStatistics.numAutoRoamAttempt = parcel.readInt();
            wifiConnectionStatistics.numWifiManagerJoinAttempt = parcel.readInt();
            int n = parcel.readInt();
            while (true) {
                int n2 = n - 1;
                if (n <= 0) break;
                String string2 = parcel.readString();
                WifiNetworkConnectionStatistics wifiNetworkConnectionStatistics = new WifiNetworkConnectionStatistics(parcel.readInt(), parcel.readInt());
                wifiConnectionStatistics.untrustedNetworkHistory.put(string2, wifiNetworkConnectionStatistics);
                n = n2;
            }
            return wifiConnectionStatistics;
        }

        public WifiConnectionStatistics[] newArray(int n) {
            return new WifiConnectionStatistics[n];
        }
    };
    private static final String TAG = "WifiConnnectionStatistics";
    public int num24GhzConnected;
    public int num5GhzConnected;
    public int numAutoJoinAttempt;
    public int numAutoRoamAttempt;
    public int numWifiManagerJoinAttempt;
    public HashMap<String, WifiNetworkConnectionStatistics> untrustedNetworkHistory = new HashMap();

    public WifiConnectionStatistics() {
    }

    public WifiConnectionStatistics(WifiConnectionStatistics wifiConnectionStatistics) {
        if (wifiConnectionStatistics != null) {
            this.untrustedNetworkHistory.putAll(wifiConnectionStatistics.untrustedNetworkHistory);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void incrementOrAddUntrusted(String string2, int n, int n2) {
        WifiNetworkConnectionStatistics wifiNetworkConnectionStatistics;
        block9: {
            block8: {
                if (TextUtils.isEmpty(string2)) break block8;
                if (this.untrustedNetworkHistory.containsKey(string2)) {
                    wifiNetworkConnectionStatistics = this.untrustedNetworkHistory.get(string2);
                    if (wifiNetworkConnectionStatistics != null) {
                        wifiNetworkConnectionStatistics.numConnection = n + wifiNetworkConnectionStatistics.numConnection;
                        wifiNetworkConnectionStatistics.numUsage = n2 + wifiNetworkConnectionStatistics.numUsage;
                    }
                } else {
                    wifiNetworkConnectionStatistics = new WifiNetworkConnectionStatistics(n, n2);
                }
                if (wifiNetworkConnectionStatistics != null) break block9;
            }
            return;
        }
        this.untrustedNetworkHistory.put(string2, wifiNetworkConnectionStatistics);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connected on: 2.4Ghz=").append(this.num24GhzConnected);
        stringBuilder.append(" 5Ghz=").append(this.num5GhzConnected).append("\n");
        stringBuilder.append(" join=").append(this.numWifiManagerJoinAttempt);
        stringBuilder.append("\\").append(this.numAutoJoinAttempt).append("\n");
        stringBuilder.append(" roam=").append(this.numAutoRoamAttempt).append("\n");
        for (String string2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics wifiNetworkConnectionStatistics = this.untrustedNetworkHistory.get(string2);
            if (wifiNetworkConnectionStatistics == null) continue;
            stringBuilder.append(string2).append(" ").append(wifiNetworkConnectionStatistics.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.num24GhzConnected);
        parcel.writeInt(this.num5GhzConnected);
        parcel.writeInt(this.numAutoJoinAttempt);
        parcel.writeInt(this.numAutoRoamAttempt);
        parcel.writeInt(this.numWifiManagerJoinAttempt);
        parcel.writeInt(this.untrustedNetworkHistory.size());
        for (String string2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics wifiNetworkConnectionStatistics = this.untrustedNetworkHistory.get(string2);
            parcel.writeString(string2);
            parcel.writeInt(wifiNetworkConnectionStatistics.numConnection);
            parcel.writeInt(wifiNetworkConnectionStatistics.numUsage);
        }
    }
}

