/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;

public class WifiSsid
implements Parcelable {
    public static final Parcelable.Creator<WifiSsid> CREATOR = new Parcelable.Creator<WifiSsid>(){

        @Override
        public WifiSsid createFromParcel(Parcel parcel) {
            WifiSsid wifiSsid = new WifiSsid();
            int n = parcel.readInt();
            byte[] byArray = new byte[n];
            parcel.readByteArray(byArray);
            wifiSsid.octets.write(byArray, 0, n);
            return wifiSsid;
        }

        public WifiSsid[] newArray(int n) {
            return new WifiSsid[n];
        }
    };
    private static final int HEX_RADIX = 16;
    public static final String NONE = "<unknown ssid>";
    private static final String TAG = "WifiSsid";
    public final ByteArrayOutputStream octets = new ByteArrayOutputStream(32);

    private WifiSsid() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertToBytes(String string2) {
        int n = 0;
        block15: while (n < string2.length()) {
            char c = string2.charAt(n);
            switch (c) {
                default: {
                    this.octets.write(c);
                    ++n;
                    continue block15;
                }
                case '\\': 
            }
            switch (string2.charAt(++n)) {
                default: {
                    continue block15;
                }
                case '\"': {
                    this.octets.write(34);
                    ++n;
                    continue block15;
                }
                case '\\': {
                    this.octets.write(92);
                    ++n;
                    continue block15;
                }
                case 'n': {
                    this.octets.write(10);
                    ++n;
                    continue block15;
                }
                case 'r': {
                    this.octets.write(13);
                    ++n;
                    continue block15;
                }
                case 't': {
                    this.octets.write(9);
                    ++n;
                    continue block15;
                }
                case 'e': {
                    this.octets.write(27);
                    ++n;
                    continue block15;
                }
                case 'x': {
                    int n2;
                    int n3 = ++n + 2;
                    try {
                        int n4;
                        n2 = n4 = Integer.parseInt(string2.substring(n, n3), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = -1;
                    }
                    if (n2 < 0) {
                        int n5 = Character.digit(string2.charAt(n), 16);
                        if (n5 < 0) continue block15;
                        this.octets.write(n5);
                        ++n;
                        continue block15;
                    }
                    this.octets.write(n2);
                    n += 2;
                    continue block15;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
            }
            int n6 = -48 + string2.charAt(n);
            if (string2.charAt(++n) >= '0' && string2.charAt(n) <= '7') {
                n6 = -48 + (n6 * 8 + string2.charAt(n));
                ++n;
            }
            if (string2.charAt(n) >= '0' && string2.charAt(n) <= '7') {
                n6 = -48 + (n6 * 8 + string2.charAt(n));
                ++n;
            }
            this.octets.write(n6);
        }
        return;
    }

    public static WifiSsid createFromAsciiEncoded(String string2) {
        WifiSsid wifiSsid = new WifiSsid();
        wifiSsid.convertToBytes(string2);
        return wifiSsid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WifiSsid createFromHex(String string2) {
        WifiSsid wifiSsid = new WifiSsid();
        if (string2 != null) {
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                string2 = string2.substring(2);
            }
            for (int i = 0; i < -1 + string2.length(); i += 2) {
                int n;
                int n2 = i + 2;
                try {
                    int n3;
                    n = n3 = Integer.parseInt(string2.substring(i, n2), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
                wifiSsid.octets.write(n);
            }
        }
        return wifiSsid;
    }

    private boolean isArrayAllZeroes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getHexString() {
        String string2 = "0x";
        byte[] byArray = this.getOctets();
        for (int i = 0; i < this.octets.size(); ++i) {
            StringBuilder stringBuilder = new StringBuilder().append(string2);
            Locale locale = Locale.US;
            Object[] objectArray = new Object[]{byArray[i]};
            string2 = stringBuilder.append(String.format(locale, "%02x", objectArray)).toString();
        }
        return string2;
    }

    public byte[] getOctets() {
        return this.octets.toByteArray();
    }

    public boolean isHidden() {
        return this.isArrayAllZeroes(this.octets.toByteArray());
    }

    public String toString() {
        byte[] byArray = this.octets.toByteArray();
        if (this.octets.size() <= 0 || this.isArrayAllZeroes(byArray)) {
            return "";
        }
        CharsetDecoder charsetDecoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer charBuffer = CharBuffer.allocate(32);
        CoderResult coderResult = charsetDecoder.decode(ByteBuffer.wrap(byArray), charBuffer, true);
        charBuffer.flip();
        if (coderResult.isError()) {
            return NONE;
        }
        return charBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.octets.size());
        parcel.writeByteArray(this.octets.toByteArray());
    }
}

