/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.CardEmulation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class ApduServiceInfo
implements Parcelable {
    public static final Parcelable.Creator<ApduServiceInfo> CREATOR = new Parcelable.Creator<ApduServiceInfo>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ApduServiceInfo createFromParcel(Parcel parcel) {
            boolean bl;
            ResolveInfo resolveInfo = ResolveInfo.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            boolean bl2 = parcel.readInt() != 0;
            ArrayList<AidGroup> arrayList = new ArrayList<AidGroup>();
            if (parcel.readInt() > 0) {
                parcel.readTypedList(arrayList, AidGroup.CREATOR);
            }
            ArrayList<AidGroup> arrayList2 = new ArrayList<AidGroup>();
            if (parcel.readInt() > 0) {
                parcel.readTypedList(arrayList2, AidGroup.CREATOR);
            }
            if (parcel.readInt() != 0) {
                bl = true;
                return new ApduServiceInfo(resolveInfo, bl2, string2, arrayList, arrayList2, bl, parcel.readInt(), parcel.readInt());
            }
            bl = false;
            return new ApduServiceInfo(resolveInfo, bl2, string2, arrayList, arrayList2, bl, parcel.readInt(), parcel.readInt());
        }

        public ApduServiceInfo[] newArray(int n) {
            return new ApduServiceInfo[n];
        }
    };
    static final String TAG = "ApduServiceInfo";
    final int mBannerResourceId;
    final String mDescription;
    final HashMap<String, AidGroup> mDynamicAidGroups;
    final boolean mOnHost;
    final boolean mRequiresDeviceUnlock;
    final ResolveInfo mService;
    final HashMap<String, AidGroup> mStaticAidGroups;
    final int mUid;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApduServiceInfo(PackageManager var1_1, ResolveInfo var2_2, boolean var3_3) throws XmlPullParserException, IOException {
        super();
        var4_4 = var2_2.serviceInfo;
        var5_5 = null;
        if (!var3_3) ** GOTO lbl-1000
        try {
            try {
                var5_5 = var4_4.loadXmlMetaData(var1_1, "android.nfc.cardemulation.host_apdu_service");
                if (var5_5 == null) {
                    throw new XmlPullParserException("No android.nfc.cardemulation.host_apdu_service meta-data");
                }
                ** GOTO lbl20
            }
            catch (PackageManager.NameNotFoundException var7_6) {
                throw new XmlPullParserException("Unable to create context for: " + var4_4.packageName);
            }
        }
        catch (Throwable var6_7) {
            if (var5_5 != null) {
                var5_5.close();
            }
            throw var6_7;
        }
lbl-1000:
        // 1 sources

        {
            var5_5 = var4_4.loadXmlMetaData(var1_1, "android.nfc.cardemulation.off_host_apdu_service");
            if (var5_5 == null) {
                throw new XmlPullParserException("No android.nfc.cardemulation.off_host_apdu_service meta-data");
            }
lbl20:
            // 3 sources

            var8_8 = var5_5.getEventType();
            while (var8_8 != 2 && var8_8 != 1) {
                var8_8 = var5_5.next();
            }
            var9_9 = var5_5.getName();
            if (var3_3 && !"host-apdu-service".equals(var9_9)) {
                throw new XmlPullParserException("Meta-data does not start with <host-apdu-service> tag");
            }
            if (!var3_3 && !"offhost-apdu-service".equals(var9_9)) {
                throw new XmlPullParserException("Meta-data does not start with <offhost-apdu-service> tag");
            }
            var10_10 = var1_1.getResourcesForApplication(var4_4.applicationInfo);
            var11_11 = Xml.asAttributeSet(var5_5);
            if (var3_3) {
                var12_12 = var10_10.obtainAttributes(var11_11, R.styleable.HostApduService);
                this.mService = var2_2;
                this.mDescription = var12_12.getString(0);
                this.mRequiresDeviceUnlock = var12_12.getBoolean(1, false);
                this.mBannerResourceId = var12_12.getResourceId(2, -1);
                var12_12.recycle();
            } else {
                var31_13 = var10_10.obtainAttributes(var11_11, R.styleable.OffHostApduService);
                this.mService = var2_2;
                this.mDescription = var31_13.getString(0);
                this.mRequiresDeviceUnlock = false;
                this.mBannerResourceId = var31_13.getResourceId(1, -1);
                var31_13.recycle();
            }
            this.mStaticAidGroups = new HashMap<K, V>();
            this.mDynamicAidGroups = new HashMap<K, V>();
            this.mOnHost = var3_3;
            var13_14 = var5_5.getDepth();
            var14_15 = null;
            block6: while (true) {
                block30: {
                    block28: {
                        block29: {
                            if ((var15_16 = var5_5.next()) == 3 && var5_5.getDepth() <= var13_14 || var15_16 == 1) break block28;
                            var16_17 = var5_5.getName();
                            if (var15_16 == 2 && "aid-group".equals(var16_17) && var14_15 == null) {
                                var17_18 = var10_10.obtainAttributes(var11_11, R.styleable.AidGroup);
                                var18_19 = var17_18.getString(1);
                                var19_20 = var17_18.getString(0);
                                if (!"payment".equals(var18_19)) {
                                    var18_19 = "other";
                                }
                                if ((var14_15 = this.mStaticAidGroups.get(var18_19)) != null) {
                                    if (!"other".equals(var18_19)) {
                                        Log.e("ApduServiceInfo", "Not allowing multiple aid-groups in the " + var18_19 + " category");
                                        var14_15 = null;
                                    }
lbl64:
                                    // 4 sources

                                    while (true) {
                                        var17_18.recycle();
                                        continue block6;
                                        break;
                                    }
                                }
                                var14_15 = new AidGroup(var18_19, var19_20);
                                ** continue;
                            }
                            if (var15_16 != 3 || !"aid-group".equals(var16_17) || var14_15 == null) break block29;
                            if (var14_15.aids.size() > 0) {
                                if (!this.mStaticAidGroups.containsKey(var14_15.category)) {
                                    this.mStaticAidGroups.put(var14_15.category, var14_15);
                                }
                                break block30;
                            } else {
                                Log.e("ApduServiceInfo", "Not adding <aid-group> with empty or invalid AIDs");
                            }
                            break block30;
                        }
                        if (var15_16 == 2 && "aid-filter".equals(var16_17) && var14_15 != null) {
                            var23_21 = var10_10.obtainAttributes(var11_11, R.styleable.AidFilter);
                            var24_22 = var23_21.getString(0).toUpperCase();
                            if (CardEmulation.isValidAid(var24_22) && !var14_15.aids.contains(var24_22)) {
                                var14_15.aids.add(var24_22);
                            } else {
                                Log.e("ApduServiceInfo", "Ignoring invalid or duplicate aid: " + var24_22);
                            }
                            var23_21.recycle();
                            continue;
                        }
                        if (var15_16 != 2 || !"aid-prefix-filter".equals(var16_17) || var14_15 == null) continue;
                        var27_23 = var10_10.obtainAttributes(var11_11, R.styleable.AidFilter);
                        var28_24 = var27_23.getString(0).toUpperCase().concat("*");
                        if (CardEmulation.isValidAid(var28_24) && !var14_15.aids.contains(var28_24)) {
                            var14_15.aids.add(var28_24);
                        } else {
                            Log.e("ApduServiceInfo", "Ignoring invalid or duplicate aid: " + var28_24);
                        }
                        var27_23.recycle();
                        continue;
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    this.mUid = var4_4.applicationInfo.uid;
                    return;
                }
                var14_15 = null;
            }
        }
    }

    public ApduServiceInfo(ResolveInfo resolveInfo, boolean bl, String string2, ArrayList<AidGroup> arrayList, ArrayList<AidGroup> arrayList2, boolean bl2, int n, int n2) {
        this.mService = resolveInfo;
        this.mDescription = string2;
        this.mStaticAidGroups = new HashMap();
        this.mDynamicAidGroups = new HashMap();
        this.mOnHost = bl;
        this.mRequiresDeviceUnlock = bl2;
        for (AidGroup aidGroup : arrayList) {
            this.mStaticAidGroups.put(aidGroup.category, aidGroup);
        }
        for (AidGroup aidGroup : arrayList2) {
            this.mDynamicAidGroups.put(aidGroup.category, aidGroup);
        }
        this.mBannerResourceId = n;
        this.mUid = n2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println("    " + this.getComponent() + " (Description: " + this.getDescription() + ")");
        printWriter.println("    Static AID groups:");
        for (AidGroup aidGroup : this.mStaticAidGroups.values()) {
            printWriter.println("        Category: " + aidGroup.category);
            for (String string2 : aidGroup.aids) {
                printWriter.println("            AID: " + string2);
            }
        }
        printWriter.println("    Dynamic AID groups:");
        for (AidGroup aidGroup : this.mDynamicAidGroups.values()) {
            printWriter.println("        Category: " + aidGroup.category);
            for (String string3 : aidGroup.aids) {
                printWriter.println("            AID: " + string3);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ApduServiceInfo)) {
            return false;
        }
        return ((ApduServiceInfo)object).getComponent().equals(this.getComponent());
    }

    public ArrayList<AidGroup> getAidGroups() {
        ArrayList<AidGroup> arrayList = new ArrayList<AidGroup>();
        Iterator<Map.Entry<String, AidGroup>> iterator = this.mDynamicAidGroups.entrySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getValue());
        }
        for (Map.Entry<String, AidGroup> entry : this.mStaticAidGroups.entrySet()) {
            if (this.mDynamicAidGroups.containsKey(entry.getKey())) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public ArrayList<String> getAids() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<AidGroup> iterator = this.getAidGroups().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next().aids);
        }
        return arrayList;
    }

    public String getCategoryForAid(String string2) {
        for (AidGroup aidGroup : this.getAidGroups()) {
            if (!aidGroup.aids.contains(string2.toUpperCase())) continue;
            return aidGroup.category;
        }
        return null;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public AidGroup getDynamicAidGroupForCategory(String string2) {
        return this.mDynamicAidGroups.get(string2);
    }

    public int getUid() {
        return this.mUid;
    }

    public boolean hasCategory(String string2) {
        return this.mStaticAidGroups.containsKey(string2) || this.mDynamicAidGroups.containsKey(string2);
    }

    public int hashCode() {
        return this.getComponent().hashCode();
    }

    public boolean isOnHost() {
        return this.mOnHost;
    }

    public Drawable loadBanner(PackageManager packageManager) {
        try {
            Drawable drawable2 = packageManager.getResourcesForApplication(this.mService.serviceInfo.packageName).getDrawable(this.mBannerResourceId);
            return drawable2;
        }
        catch (Resources.NotFoundException notFoundException) {
            Log.e(TAG, "Could not load banner.");
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(TAG, "Could not load banner.");
            return null;
        }
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mService.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return this.mService.loadLabel(packageManager);
    }

    public boolean removeDynamicAidGroupForCategory(String string2) {
        return this.mDynamicAidGroups.remove(string2) != null;
    }

    public boolean requiresUnlock() {
        return this.mRequiresDeviceUnlock;
    }

    public void setOrReplaceDynamicAidGroup(AidGroup aidGroup) {
        this.mDynamicAidGroups.put(aidGroup.getCategory(), aidGroup);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ApduService: ");
        stringBuilder.append(this.getComponent());
        stringBuilder.append(", description: " + this.mDescription);
        stringBuilder.append(", Static AID Groups: ");
        Iterator<AidGroup> iterator = this.mStaticAidGroups.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
        }
        stringBuilder.append(", Dynamic AID Groups: ");
        Iterator<AidGroup> iterator2 = this.mDynamicAidGroups.values().iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append(iterator2.next().toString());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        this.mService.writeToParcel(parcel, n);
        parcel.writeString(this.mDescription);
        int n3 = this.mOnHost ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeInt(this.mStaticAidGroups.size());
        if (this.mStaticAidGroups.size() > 0) {
            parcel.writeTypedList(new ArrayList<AidGroup>(this.mStaticAidGroups.values()));
        }
        parcel.writeInt(this.mDynamicAidGroups.size());
        if (this.mDynamicAidGroups.size() > 0) {
            parcel.writeTypedList(new ArrayList<AidGroup>(this.mDynamicAidGroups.values()));
        }
        if (!this.mRequiresDeviceUnlock) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeInt(this.mBannerResourceId);
        parcel.writeInt(this.mUid);
    }
}

