/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public class ConditionVariable {
    private volatile boolean mCondition;

    public ConditionVariable() {
        this.mCondition = false;
    }

    public ConditionVariable(boolean bl) {
        this.mCondition = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void block() {
        synchronized (this) {
            boolean bl;
            while (!(bl = this.mCondition)) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean block(long l) {
        if (l == 0L) {
            this.block();
            return true;
        }
        synchronized (this) {
            boolean bl;
            long l2 = System.currentTimeMillis();
            long l3 = l2 + l;
            while (!(bl = this.mCondition)) {
                if (l2 >= l3) return this.mCondition;
                long l4 = l3 - l2;
                try {
                    this.wait(l4);
                }
                catch (InterruptedException interruptedException) {}
                l2 = System.currentTimeMillis();
            }
            return this.mCondition;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            this.mCondition = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        synchronized (this) {
            boolean bl = this.mCondition;
            this.mCondition = true;
            if (!bl) {
                this.notifyAll();
            }
            return;
        }
    }
}

