/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class FileUtils {
    private static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");
    public static final int S_IRGRP = 32;
    public static final int S_IROTH = 4;
    public static final int S_IRUSR = 256;
    public static final int S_IRWXG = 56;
    public static final int S_IRWXO = 7;
    public static final int S_IRWXU = 448;
    public static final int S_IWGRP = 16;
    public static final int S_IWOTH = 2;
    public static final int S_IWUSR = 128;
    public static final int S_IXGRP = 8;
    public static final int S_IXOTH = 1;
    public static final int S_IXUSR = 64;
    private static final String TAG = "FileUtils";

    /*
     * Enabled aggressive block sorting
     */
    public static String buildValidExtFilename(String string2) {
        if (TextUtils.isEmpty(string2) || ".".equals(string2) || "..".equals(string2)) {
            return "(invalid)";
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (FileUtils.isValidExtFilenameChar(c)) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append('_');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String buildValidFatFilename(String string2) {
        if (TextUtils.isEmpty(string2) || ".".equals(string2) || "..".equals(string2)) {
            return "(invalid)";
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            if (FileUtils.isValidFatFilenameChar(c)) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append('_');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static long checksumCrc32(File var0) throws FileNotFoundException, IOException {
        block12: {
            var1_1 = new CRC32();
            var2_2 = null;
            var3_3 = new CheckedInputStream(new FileInputStream(var0), var1_1);
            var6_4 = new byte[128];
            while (var3_3.read(var6_4) >= 0) {
            }
            var7_5 = var1_1.getValue();
            if (var3_3 == null) break block12;
            try {
                var3_3.close();
            }
            catch (IOException var9_9) {
                return var7_5;
            }
        }
        return var7_5;
        catch (Throwable var4_6) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var2_2 != null) {
                    var2_2.close();
                }
lbl20:
                // 4 sources

                throw var4_7;
            }
        }
        {
            catch (IOException var5_10) {
                ** continue;
            }
        }
        catch (Throwable var4_8) {
            var2_2 = var3_3;
            ** continue;
        }
    }

    public static boolean contains(File file, File file2) {
        String string2;
        if (file2 == null) {
            return false;
        }
        String string3 = file.getAbsolutePath();
        if (string3.equals(string2 = file2.getAbsolutePath())) {
            return true;
        }
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        return string2.startsWith(string3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File file, File file2) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            boolean bl = FileUtils.copyToFile(fileInputStream, file2);
            return bl;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyToFile(InputStream var0, File var1_1) {
        if (var1_1.exists()) {
            var1_1.delete();
        }
        var3_2 = new FileOutputStream(var1_1);
        {
            catch (IOException var2_8) {
                return false;
            }
            try {
                var6_3 = new byte[4096];
                while ((var7_4 = var0.read(var6_3)) >= 0) {
                    var3_2.write(var6_3, 0, var7_4);
                }
            }
            catch (Throwable var4_5) {}
            {
                var3_2.flush();
            }
            var3_2.getFD().sync();
lbl-1000:
            // 1 sources

            {
                while (true) {
                    var3_2.close();
                    return true;
                }
            }
lbl-1000:
            // 1 sources

            {
                while (true) {
                    var3_2.close();
                    throw var4_5;
                }
                catch (IOException var5_6) {}
            }
            ** continue;
        }
        {
            var3_2.flush();
        }
        {
            var3_2.getFD().sync();
            ** continue;
        }
    }

    public static boolean deleteContents(File file) {
        File[] fileArray = file.listFiles();
        boolean bl = true;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    bl &= FileUtils.deleteContents(file2);
                }
                if (file2.delete()) continue;
                Log.w(TAG, "Failed to delete " + file2);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean deleteOlderFiles(File file, int n, long l) {
        if (n < 0) throw new IllegalArgumentException("Constraints must be positive or 0");
        if (l < 0L) {
            throw new IllegalArgumentException("Constraints must be positive or 0");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return false;
        }
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return (int)(file2.lastModified() - file.lastModified());
            }
        });
        boolean bl = false;
        int n2 = n;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            if (System.currentTimeMillis() - file2.lastModified() > l && file2.delete()) {
                Log.d(TAG, "Deleted old file " + file2);
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public static int getUid(String string2) {
        try {
            int n = Os.stat((String)string2).st_uid;
            return n;
        }
        catch (ErrnoException errnoException) {
            return -1;
        }
    }

    public static boolean isFilenameSafe(File file) {
        return SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    public static boolean isValidExtFilename(String string2) {
        return string2 != null && string2.equals(FileUtils.buildValidExtFilename(string2));
    }

    private static boolean isValidExtFilenameChar(char c) {
        switch (c) {
            default: {
                return true;
            }
            case '\u0000': 
            case '/': 
        }
        return false;
    }

    public static boolean isValidFatFilename(String string2) {
        return string2 != null && string2.equals(FileUtils.buildValidFatFilename(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isValidFatFilenameChar(char c) {
        if (c >= '\u0000' && c <= '\u001f') {
            return false;
        }
        switch (c) {
            case '\"': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '\\': 
            case '|': 
            case '\u007f': {
                return false;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static String readTextFile(File var0, int var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static File rewriteAfterRename(File file, File file2, File file3) {
        if (file3 == null || !FileUtils.contains(file, file3)) {
            return null;
        }
        return new File(file2, file3.getAbsolutePath().substring(file.getAbsolutePath().length()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String rewriteAfterRename(File file, File file2, String string2) {
        File file3;
        if (string2 == null || (file3 = FileUtils.rewriteAfterRename(file, file2, new File(string2))) == null) {
            return null;
        }
        return file3.getAbsolutePath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] rewriteAfterRename(File file, File file2, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = FileUtils.rewriteAfterRename(file, file2, stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    public static int setPermissions(File file, int n, int n2, int n3) {
        return FileUtils.setPermissions(file.getAbsolutePath(), n, n2, n3);
    }

    public static int setPermissions(FileDescriptor fileDescriptor, int n, int n2, int n3) {
        block4: {
            try {
                Os.fchmod(fileDescriptor, n);
                if (n2 < 0 && n3 < 0) break block4;
            }
            catch (ErrnoException errnoException) {
                Slog.w(TAG, "Failed to fchmod(): " + errnoException);
                return errnoException.errno;
            }
            try {
                Os.fchown(fileDescriptor, n2, n3);
            }
            catch (ErrnoException errnoException) {
                Slog.w(TAG, "Failed to fchown(): " + errnoException);
                return errnoException.errno;
            }
        }
        return 0;
    }

    public static int setPermissions(String string2, int n, int n2, int n3) {
        block4: {
            try {
                Os.chmod(string2, n);
                if (n2 < 0 && n3 < 0) break block4;
            }
            catch (ErrnoException errnoException) {
                Slog.w(TAG, "Failed to chmod(" + string2 + "): " + errnoException);
                return errnoException.errno;
            }
            try {
                Os.chown(string2, n2, n3);
            }
            catch (ErrnoException errnoException) {
                Slog.w(TAG, "Failed to chown(" + string2 + "): " + errnoException);
                return errnoException.errno;
            }
        }
        return 0;
    }

    public static void stringToFile(String string2, String string3) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        try {
            fileWriter.write(string3);
            return;
        }
        finally {
            fileWriter.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sync(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) return true;
        try {
            fileOutputStream.getFD().sync();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

