/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.WorkSource;
import android.util.Log;
import java.util.List;

public final class PowerManager {
    public static final int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static final String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";
    public static final String ACTION_POWER_SAVE_MODE_CHANGING = "android.os.action.POWER_SAVE_MODE_CHANGING";
    public static int AUTO_BRIGHTNESS_MAX = 0;
    public static final int BRIGHTNESS_DEFAULT = -1;
    public static final int BRIGHTNESS_OFF = 0;
    public static final int BRIGHTNESS_ON = 255;
    public static final int DOZE_WAKE_LOCK = 64;
    public static final String EXTRA_POWER_SAVE_MODE = "mode";
    @Deprecated
    public static final int FULL_WAKE_LOCK = 26;
    public static final int GO_TO_SLEEP_FLAG_NO_DOZE = 1;
    public static final int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static final int GO_TO_SLEEP_REASON_DEVICE_ADMIN = 1;
    public static final int GO_TO_SLEEP_REASON_HDMI = 5;
    public static final int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static final int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static final int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static final int ON_AFTER_RELEASE = 0x20000000;
    public static final int PARTIAL_WAKE_LOCK = 1;
    public static final int POLICY_AUTOBRIGHTNESS = 1;
    public static final int POLICY_IMMEDIATE = 8;
    public static final int POLICY_POWERSAVER = 2;
    public static final int POLICY_SUPERIPS = 4;
    public static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static final String REBOOT_RECOVERY = "recovery";
    public static final int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1;
    @Deprecated
    public static final int SCREEN_BRIGHT_WAKE_LOCK = 10;
    @Deprecated
    public static final int SCREEN_DIM_WAKE_LOCK = 6;
    private static final String TAG = "PowerManager";
    public static final int UNIMPORTANT_FOR_LOGGING = 0x40000000;
    public static final int USER_ACTIVITY_EVENT_BUTTON = 1;
    public static final int USER_ACTIVITY_EVENT_OTHER = 0;
    public static final int USER_ACTIVITY_EVENT_TOUCH = 2;
    public static final int USER_ACTIVITY_FLAG_INDIRECT = 2;
    public static final int USER_ACTIVITY_FLAG_NO_CHANGE_LIGHTS = 1;
    public static final int WAKE_LOCK_LEVEL_MASK = 65535;
    final Context mContext;
    final Handler mHandler;
    final IPowerManager mService;

    static {
        AUTO_BRIGHTNESS_MAX = 255;
    }

    public PowerManager(Context context, IPowerManager iPowerManager, Handler handler) {
        this.mContext = context;
        this.mService = iPowerManager;
        this.mHandler = handler;
    }

    public static boolean useTwilightAdjustmentFeature() {
        return SystemProperties.getBoolean("persist.power.usetwilightadj", false);
    }

    public static void validateWakeLockParameters(int n, String string2) {
        switch (0xFFFF & n) {
            default: {
                throw new IllegalArgumentException("Must specify a valid wake lock level.");
            }
            case 1: 
            case 6: 
            case 10: 
            case 26: 
            case 32: 
            case 64: 
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The tag must not be null.");
        }
    }

    public void disableBacklightPowerSaving() {
        try {
            this.mService.disableBacklightPowerSaving();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void enableBacklightPowerSaving(int n) {
        try {
            this.mService.enableBacklightPowerSaving(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void forceReleaseSuspiciousWakelocks(String string2, long l) {
        try {
            this.mService.forceReleaseSuspiciousWakelocks(string2, l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int getDefaultScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694797);
    }

    String getFocusAppPackageName() {
        try {
            String string2 = ActivityManagerNative.getDefault().getFocusAppPackageName();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getMaximumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694796);
    }

    public int getMinimumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694795);
    }

    public List<String> getSuspiciousWakelocks(long l) {
        try {
            List<String> list = this.mService.getSuspiciousWakelocks(l);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void goToSleep(long l) {
        this.goToSleep(l, 0, 0);
    }

    public void goToSleep(long l, int n, int n2) {
        try {
            this.mService.goToSleep(l, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean isInteractive() {
        try {
            boolean bl = this.mService.isInteractive();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isPowerSaveMode() {
        try {
            boolean bl = this.mService.isPowerSaveMode();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    public boolean isScreenOn() {
        return this.isInteractive();
    }

    public boolean isWakeLockLevelSupported(int n) {
        try {
            boolean bl = this.mService.isWakeLockLevelSupported(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void nap(long l) {
        try {
            this.mService.nap(l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public WakeLock newWakeLock(int n, String string2) {
        PowerManager.validateWakeLockParameters(n, string2);
        return new WakeLock(n, string2, this.mContext.getOpPackageName());
    }

    public void notifyLidSwitchState(int n) {
        try {
            this.mService.notifyLidSwitchState(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void reboot(String string2) {
        try {
            this.mService.reboot(false, string2, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void resetAutoBrightnessAdj() {
        try {
            this.mService.resetAutoBrightnessAdj();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setBacklightBrightness(int n) {
        try {
            this.mService.setTemporaryScreenBrightnessSettingOverride(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean setPowerSaveMode(boolean bl) {
        try {
            boolean bl2 = this.mService.setPowerSaveMode(bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void userActivity(long l, int n, int n2) {
        try {
            this.mService.userActivity(l, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void userActivity(long l, boolean bl) {
        int n = bl ? 1 : 0;
        this.userActivity(l, 0, n);
    }

    public void wakeUp(long l) {
        try {
            this.mService.wakeUp(l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final class WakeLock {
        private int mCount;
        private int mFlags;
        private boolean mHeld;
        private String mHistoryTag;
        private final String mPackageName;
        private boolean mRefCounted = true;
        private final Runnable mReleaser = new Runnable(){

            @Override
            public void run() {
                WakeLock.this.release();
            }
        };
        private String mTag;
        private final IBinder mToken;
        private final String mTraceName;
        private WorkSource mWorkSource;

        WakeLock(int n, String string2, String string3) {
            this.mFlags = n;
            this.mTag = string2;
            this.mPackageName = string3;
            this.mToken = new Binder();
            this.mTraceName = "WakeLock (" + this.mTag + ")";
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void acquireLocked() {
            block4: {
                block3: {
                    if (!this.mRefCounted) break block3;
                    int n = this.mCount;
                    this.mCount = n + 1;
                    if (n != 0) break block4;
                }
                PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                try {
                    PowerManager.this.mService.acquireWakeLock(this.mToken, this.mFlags, this.mTag, this.mPackageName, this.mWorkSource, this.mHistoryTag);
                }
                catch (RemoteException remoteException) {}
                this.mHeld = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire(long l) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                PowerManager.this.mHandler.postDelayed(this.mReleaser, l);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf(PowerManager.TAG, "WakeLock finalized while still held: " + this.mTag);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                    try {
                        PowerManager.this.mService.releaseWakeLock(this.mToken, 0);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        public void release() {
            this.release(0);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release(int n) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                block10: {
                    block9: {
                        int n2;
                        if (!this.mRefCounted) break block9;
                        this.mCount = n2 = -1 + this.mCount;
                        if (n2 != 0) break block10;
                    }
                    PowerManager.this.mHandler.removeCallbacks(this.mReleaser);
                    if (this.mHeld) {
                        Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                        try {
                            PowerManager.this.mService.releaseWakeLock(this.mToken, n);
                        }
                        catch (RemoteException remoteException) {}
                        this.mHeld = false;
                    }
                }
                if (this.mCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
                return;
            }
        }

        public void setHistoryTag(String string2) {
            this.mHistoryTag = string2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setReferenceCounted(boolean bl) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.mRefCounted = bl;
                return;
            }
        }

        public void setTag(String string2) {
            this.mTag = string2;
        }

        public void setUnimportantForLogging(boolean bl) {
            if (bl) {
                this.mFlags = 0x40000000 | this.mFlags;
                return;
            }
            this.mFlags = 0xBFFFFFFF & this.mFlags;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setWorkSource(WorkSource workSource) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean bl;
                boolean bl2;
                if (workSource != null && workSource.size() == 0) {
                    workSource = null;
                }
                if (workSource == null) {
                    bl2 = this.mWorkSource != null;
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    bl2 = true;
                    this.mWorkSource = new WorkSource(workSource);
                } else {
                    bl2 = this.mWorkSource.diff(workSource);
                    if (bl2) {
                        this.mWorkSource.set(workSource);
                    }
                }
                if (bl2 && (bl = this.mHeld)) {
                    try {
                        PowerManager.this.mService.updateWakeLockWorkSource(this.mToken, this.mWorkSource, this.mHistoryTag);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mCount + "}";
            }
        }
    }
}

