/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public abstract class RemoteCallback
implements Parcelable {
    public static final Parcelable.Creator<RemoteCallback> CREATOR = new Parcelable.Creator<RemoteCallback>(){

        @Override
        public RemoteCallback createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder != null) {
                return new RemoteCallbackProxy(IRemoteCallback.Stub.asInterface(iBinder));
            }
            return null;
        }

        public RemoteCallback[] newArray(int n) {
            return new RemoteCallback[n];
        }
    };
    final Handler mHandler;
    final IRemoteCallback mTarget;

    public RemoteCallback(Handler handler) {
        this.mHandler = handler;
        this.mTarget = new LocalCallback();
    }

    RemoteCallback(IRemoteCallback iRemoteCallback) {
        this.mHandler = null;
        this.mTarget = iRemoteCallback;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            boolean bl = this.mTarget.asBinder().equals(((RemoteCallback)object).mTarget.asBinder());
            return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    protected abstract void onResult(Bundle var1);

    public void sendResult(Bundle bundle) throws RemoteException {
        this.mTarget.sendResult(bundle);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStrongBinder(this.mTarget.asBinder());
    }

    class DeliverResult
    implements Runnable {
        final Bundle mResult;

        DeliverResult(Bundle bundle) {
            this.mResult = bundle;
        }

        @Override
        public void run() {
            RemoteCallback.this.onResult(this.mResult);
        }
    }

    class LocalCallback
    extends IRemoteCallback.Stub {
        LocalCallback() {
        }

        @Override
        public void sendResult(Bundle bundle) {
            RemoteCallback.this.mHandler.post(new DeliverResult(bundle));
        }
    }

    static class RemoteCallbackProxy
    extends RemoteCallback {
        RemoteCallbackProxy(IRemoteCallback iRemoteCallback) {
            super(iRemoteCallback);
        }

        @Override
        protected void onResult(Bundle bundle) {
        }
    }
}

