/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemClock;
import android.os.SystemProperties;
import com.google.android.collect.Maps;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public class SystemService {
    private static Object sPropertyLock;
    private static HashMap<String, State> sStates;

    static {
        sStates = Maps.newHashMap();
        sPropertyLock = new Object();
        SystemProperties.addChangeCallback(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = sPropertyLock;
                synchronized (object) {
                    sPropertyLock.notifyAll();
                    return;
                }
            }
        });
    }

    public static State getState(String string2) {
        String string3 = SystemProperties.get("init.svc." + string2);
        State state = sStates.get(string3);
        if (state != null) {
            return state;
        }
        return State.STOPPED;
    }

    public static boolean isRunning(String string2) {
        return State.RUNNING.equals((Object)SystemService.getState(string2));
    }

    public static boolean isStopped(String string2) {
        return State.STOPPED.equals((Object)SystemService.getState(string2));
    }

    public static void restart(String string2) {
        SystemProperties.set("ctl.restart", string2);
    }

    public static void start(String string2) {
        SystemProperties.set("ctl.start", string2);
    }

    public static void stop(String string2) {
        SystemProperties.set("ctl.stop", string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForAnyStopped(String ... stringArray) {
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                for (String string2 : stringArray) {
                    if (!State.STOPPED.equals((Object)SystemService.getState(string2))) continue;
                    return;
                }
                try {
                    sPropertyLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitForState(String string2, State state, long l) throws TimeoutException {
        long l2 = l + SystemClock.elapsedRealtime();
        while (true) {
            Object object = sPropertyLock;
            synchronized (object) {
                State state2 = SystemService.getState(string2);
                if (state.equals((Object)state2)) {
                    return;
                }
                if (SystemClock.elapsedRealtime() >= l2) {
                    throw new TimeoutException("Service " + string2 + " currently " + (Object)((Object)state2) + "; waited " + l + "ms for " + (Object)((Object)state));
                }
                try {
                    sPropertyLock.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State RESTARTING;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State STOPPED;
        public static final /* enum */ State STOPPING;

        static {
            RUNNING = new State("running");
            STOPPING = new State("stopping");
            STOPPED = new State("stopped");
            RESTARTING = new State("restarting");
            State[] stateArray = new State[]{RUNNING, STOPPING, STOPPED, RESTARTING};
            $VALUES = stateArray;
        }

        private State(String string3) {
            sStates.put(string3, this);
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

