/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Fragment;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import com.android.internal.R;

public abstract class PreferenceFragment
extends Fragment
implements PreferenceManager.OnPreferenceTreeClickListener {
    private static final int FIRST_REQUEST_CODE = 100;
    private static final int MSG_BIND_PREFERENCES = 1;
    private static final String PREFERENCES_TAG = "android:preferences";
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
            }
            PreferenceFragment.this.bindPreferences();
        }
    };
    private boolean mHavePrefs;
    private boolean mInitDone;
    private int mLayoutResId = 17367225;
    private ListView mList;
    private View.OnKeyListener mListOnKeyListener;
    private PreferenceManager mPreferenceManager;
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            PreferenceFragment.this.mList.focusableViewAvailable(PreferenceFragment.this.mList);
        }
    };

    public PreferenceFragment() {
        this.mListOnKeyListener = new View.OnKeyListener(){

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                Object object = PreferenceFragment.this.mList.getSelectedItem();
                if (object instanceof Preference) {
                    View view2 = PreferenceFragment.this.mList.getSelectedView();
                    return ((Preference)object).onKey(view2, n, keyEvent);
                }
                return false;
            }
        };
    }

    private void bindPreferences() {
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            preferenceScreen.bind(this.getListView());
        }
        this.onBindPreferences();
    }

    private void ensureList() {
        if (this.mList != null) {
            return;
        }
        View view = this.getView();
        if (view == null) {
            throw new IllegalStateException("Content view not yet created");
        }
        View view2 = view.findViewById(16908298);
        if (!(view2 instanceof ListView)) {
            throw new RuntimeException("Content has view with id attribute 'android.R.id.list' that is not a ListView class");
        }
        this.mList = (ListView)view2;
        if (this.mList == null) {
            throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
        }
        this.mList.setOnKeyListener(this.mListOnKeyListener);
        this.mHandler.post(this.mRequestFocus);
    }

    private void postBindPreferences() {
        if (this.mHandler.hasMessages(1)) {
            return;
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void requirePreferenceManager() {
        if (this.mPreferenceManager == null) {
            throw new RuntimeException("This should be called after super.onCreate.");
        }
    }

    public void addPreferencesFromIntent(Intent intent) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromIntent(intent, this.getPreferenceScreen()));
    }

    public void addPreferencesFromResource(int n) {
        this.requirePreferenceManager();
        this.setPreferenceScreen(this.mPreferenceManager.inflateFromResource(this.getActivity(), n, this.getPreferenceScreen()));
    }

    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(charSequence);
    }

    public ListView getListView() {
        this.ensureList();
        return this.mList;
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceManager.getPreferenceScreen();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean hasListView() {
        block6: {
            block5: {
                if (this.mList != null) break block5;
                View view = this.getView();
                if (view == null) {
                    return false;
                }
                View view2 = view.findViewById(16908298);
                if (!(view2 instanceof ListView)) {
                    return false;
                }
                this.mList = (ListView)view2;
                if (this.mList == null) break block6;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onActivityCreated(Bundle bundle) {
        PreferenceScreen preferenceScreen;
        Bundle bundle2;
        super.onActivityCreated(bundle);
        if (this.mHavePrefs) {
            this.bindPreferences();
        }
        this.mInitDone = true;
        if (bundle != null && (bundle2 = bundle.getBundle(PREFERENCES_TAG)) != null && (preferenceScreen = this.getPreferenceScreen()) != null) {
            preferenceScreen.restoreHierarchyState(bundle2);
        }
    }

    @Override
    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        this.mPreferenceManager.dispatchActivityResult(n, n2, intent);
    }

    protected void onBindPreferences() {
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mPreferenceManager = new PreferenceManager(this.getActivity(), 100);
        this.mPreferenceManager.setFragment(this);
    }

    @Override
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        TypedArray typedArray = this.getActivity().obtainStyledAttributes(null, R.styleable.PreferenceFragment, 16843814, 0);
        this.mLayoutResId = typedArray.getResourceId(0, this.mLayoutResId);
        typedArray.recycle();
        return layoutInflater.inflate(this.mLayoutResId, viewGroup, false);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mPreferenceManager.dispatchActivityDestroy();
    }

    @Override
    public void onDestroyView() {
        this.mList = null;
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mHandler.removeMessages(1);
        super.onDestroyView();
    }

    @Override
    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        if (preference.getFragment() != null && this.getActivity() instanceof OnPreferenceStartFragmentCallback) {
            return ((OnPreferenceStartFragmentCallback)((Object)this.getActivity())).onPreferenceStartFragment(this, preference);
        }
        return false;
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        PreferenceScreen preferenceScreen = this.getPreferenceScreen();
        if (preferenceScreen != null) {
            Bundle bundle2 = new Bundle();
            preferenceScreen.saveHierarchyState(bundle2);
            bundle.putBundle(PREFERENCES_TAG, bundle2);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        this.mPreferenceManager.setOnPreferenceTreeClickListener(this);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.mPreferenceManager.dispatchActivityStop();
        this.mPreferenceManager.setOnPreferenceTreeClickListener(null);
    }

    protected void onUnbindPreferences() {
    }

    public void setPreferenceScreen(PreferenceScreen preferenceScreen) {
        if (this.mPreferenceManager.setPreferences(preferenceScreen) && preferenceScreen != null) {
            this.onUnbindPreferences();
            this.mHavePrefs = true;
            if (this.mInitDone) {
                this.postBindPreferences();
            }
        }
    }

    public static interface OnPreferenceStartFragmentCallback {
        public boolean onPreferenceStartFragment(PreferenceFragment var1, Preference var2);
    }
}

