/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public final class PrintDocumentInfo
implements Parcelable {
    public static final int CONTENT_TYPE_DOCUMENT = 0;
    public static final int CONTENT_TYPE_PHOTO = 1;
    public static final int CONTENT_TYPE_UNKNOWN = -1;
    public static final Parcelable.Creator<PrintDocumentInfo> CREATOR = new Parcelable.Creator<PrintDocumentInfo>(){

        @Override
        public PrintDocumentInfo createFromParcel(Parcel parcel) {
            return new PrintDocumentInfo(parcel);
        }

        public PrintDocumentInfo[] newArray(int n) {
            return new PrintDocumentInfo[n];
        }
    };
    public static final int PAGE_COUNT_UNKNOWN = -1;
    private int mContentType;
    private long mDataSize;
    private String mName;
    private int mPageCount;

    private PrintDocumentInfo() {
    }

    private PrintDocumentInfo(Parcel parcel) {
        this.mName = parcel.readString();
        this.mPageCount = parcel.readInt();
        this.mContentType = parcel.readInt();
        this.mDataSize = parcel.readLong();
    }

    private PrintDocumentInfo(PrintDocumentInfo printDocumentInfo) {
        this.mName = printDocumentInfo.mName;
        this.mPageCount = printDocumentInfo.mPageCount;
        this.mContentType = printDocumentInfo.mContentType;
        this.mDataSize = printDocumentInfo.mDataSize;
    }

    static /* synthetic */ String access$102(PrintDocumentInfo printDocumentInfo, String string2) {
        printDocumentInfo.mName = string2;
        return string2;
    }

    static /* synthetic */ int access$202(PrintDocumentInfo printDocumentInfo, int n) {
        printDocumentInfo.mPageCount = n;
        return n;
    }

    static /* synthetic */ int access$302(PrintDocumentInfo printDocumentInfo, int n) {
        printDocumentInfo.mContentType = n;
        return n;
    }

    private String contentTyepToString(int n) {
        switch (n) {
            default: {
                return "CONTENT_TYPE_UNKNOWN";
            }
            case 0: {
                return "CONTENT_TYPE_DOCUMENT";
            }
            case 1: 
        }
        return "CONTENT_TYPE_PHOTO";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block9: {
            block8: {
                if (this == object) break block8;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                PrintDocumentInfo printDocumentInfo = (PrintDocumentInfo)object;
                if (!TextUtils.equals(this.mName, printDocumentInfo.mName)) {
                    return false;
                }
                if (this.mContentType != printDocumentInfo.mContentType) {
                    return false;
                }
                if (this.mPageCount != printDocumentInfo.mPageCount) {
                    return false;
                }
                if (this.mDataSize != printDocumentInfo.mDataSize) break block9;
            }
            return true;
        }
        return false;
    }

    public int getContentType() {
        return this.mContentType;
    }

    public long getDataSize() {
        return this.mDataSize;
    }

    public String getName() {
        return this.mName;
    }

    public int getPageCount() {
        return this.mPageCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        if (this.mName != null) {
            n = this.mName.hashCode();
            return 31 * (31 * (31 * (31 * (n + 31) + this.mContentType) + this.mPageCount) + (int)this.mDataSize) + (int)this.mDataSize >> 32;
        }
        n = 0;
        return 31 * (31 * (31 * (31 * (n + 31) + this.mContentType) + this.mPageCount) + (int)this.mDataSize) + (int)this.mDataSize >> 32;
    }

    public void setDataSize(long l) {
        this.mDataSize = l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PrintDocumentInfo{");
        stringBuilder.append("name=").append(this.mName);
        stringBuilder.append(", pageCount=").append(this.mPageCount);
        stringBuilder.append(", contentType=").append(this.contentTyepToString(this.mContentType));
        stringBuilder.append(", dataSize=").append(this.mDataSize);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mName);
        parcel.writeInt(this.mPageCount);
        parcel.writeInt(this.mContentType);
        parcel.writeLong(this.mDataSize);
    }

    public static final class Builder {
        private final PrintDocumentInfo mPrototype;

        public Builder(String string2) {
            if (TextUtils.isEmpty(string2)) {
                throw new IllegalArgumentException("name cannot be empty");
            }
            this.mPrototype = new PrintDocumentInfo();
            PrintDocumentInfo.access$102(this.mPrototype, string2);
        }

        public PrintDocumentInfo build() {
            if (this.mPrototype.mPageCount == 0) {
                PrintDocumentInfo.access$202(this.mPrototype, -1);
            }
            return new PrintDocumentInfo(this.mPrototype);
        }

        public Builder setContentType(int n) {
            PrintDocumentInfo.access$302(this.mPrototype, n);
            return this;
        }

        public Builder setPageCount(int n) {
            if (n < 0 && n != -1) {
                throw new IllegalArgumentException("pageCount must be greater than or equal to zero or DocumentInfo#PAGE_COUNT_UNKNOWN");
            }
            PrintDocumentInfo.access$202(this.mPrototype, n);
            return this;
        }
    }
}

