/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.BaseColumns;
import android.provider.BrowserContract;
import android.util.Log;
import android.webkit.WebIconDatabase;

public class Browser {
    public static final Uri BOOKMARKS_URI = Uri.parse("content://browser/bookmarks");
    public static final String EXTRA_APPLICATION_ID = "com.android.browser.application_id";
    public static final String EXTRA_CREATE_NEW_TAB = "create_new_tab";
    public static final String EXTRA_HEADERS = "com.android.browser.headers";
    public static final String EXTRA_SHARE_FAVICON = "share_favicon";
    public static final String EXTRA_SHARE_SCREENSHOT = "share_screenshot";
    public static final String[] HISTORY_PROJECTION = new String[]{"_id", "url", "visits", "date", "bookmark", "title", "favicon", "thumbnail", "touch_icon", "user_entered"};
    public static final int HISTORY_PROJECTION_BOOKMARK_INDEX = 4;
    public static final int HISTORY_PROJECTION_DATE_INDEX = 3;
    public static final int HISTORY_PROJECTION_FAVICON_INDEX = 6;
    public static final int HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int HISTORY_PROJECTION_THUMBNAIL_INDEX = 7;
    public static final int HISTORY_PROJECTION_TITLE_INDEX = 5;
    public static final int HISTORY_PROJECTION_TOUCH_ICON_INDEX = 8;
    public static final int HISTORY_PROJECTION_URL_INDEX = 1;
    public static final int HISTORY_PROJECTION_VISITS_INDEX = 2;
    public static final String INITIAL_ZOOM_LEVEL = "browser.initialZoomLevel";
    private static final String LOGTAG = "browser";
    private static final int MAX_HISTORY_COUNT = 250;
    public static final String[] SEARCHES_PROJECTION;
    public static final int SEARCHES_PROJECTION_DATE_INDEX = 2;
    public static final int SEARCHES_PROJECTION_SEARCH_INDEX = 1;
    public static final Uri SEARCHES_URI;
    public static final String[] TRUNCATE_HISTORY_PROJECTION;
    public static final int TRUNCATE_HISTORY_PROJECTION_ID_INDEX = 0;
    public static final int TRUNCATE_N_OLDEST = 5;

    static {
        TRUNCATE_HISTORY_PROJECTION = new String[]{"_id", "date"};
        SEARCHES_URI = Uri.parse("content://browser/searches");
        SEARCHES_PROJECTION = new String[]{"_id", "search", "date"};
    }

    private static final void addOrUrlEquals(StringBuilder stringBuilder) {
        stringBuilder.append(" OR url = ");
    }

    public static final void addSearchUrl(ContentResolver contentResolver, String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("search", string2);
        contentValues.put("date", System.currentTimeMillis());
        contentResolver.insert(BrowserContract.Searches.CONTENT_URI, contentValues);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean canClearHistory(ContentResolver contentResolver) {
        boolean bl;
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, null, null, null);
            int n = cursor.getCount();
            bl = n > 0;
            return bl;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e(LOGTAG, "canClearHistory", illegalStateException);
            bl = false;
            if (cursor == null) return bl;
            cursor.close();
            return false;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public static final void clearHistory(ContentResolver contentResolver) {
        Browser.deleteHistoryWhere(contentResolver, null);
    }

    public static final void clearSearches(ContentResolver contentResolver) {
        try {
            contentResolver.delete(BrowserContract.Searches.CONTENT_URI, null, null);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e(LOGTAG, "clearSearches", illegalStateException);
            return;
        }
    }

    public static final void deleteFromHistory(ContentResolver contentResolver, String string2) {
        contentResolver.delete(BrowserContract.History.CONTENT_URI, "url=?", new String[]{string2});
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void deleteHistoryTimeFrame(ContentResolver contentResolver, long l, long l2) {
        String string2;
        if (-1L == l) {
            if (-1L == l2) {
                Browser.clearHistory(contentResolver);
                return;
            }
            string2 = "date" + " < " + Long.toString(l2);
        } else {
            string2 = -1L == l2 ? "date" + " >= " + Long.toString(l) : "date" + " >= " + Long.toString(l) + " AND " + "date" + " < " + Long.toString(l2);
        }
        Browser.deleteHistoryWhere(contentResolver, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void deleteHistoryWhere(ContentResolver contentResolver, String string2) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(BrowserContract.History.CONTENT_URI, new String[]{"url"}, string2, null, null);
            if (!cursor.moveToFirst()) return;
            contentResolver.delete(BrowserContract.History.CONTENT_URI, string2, null);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e(LOGTAG, "deleteHistoryWhere", illegalStateException);
            return;
        }
        finally {
            if (cursor == null) return;
            cursor.close();
        }
    }

    public static final Cursor getAllBookmarks(ContentResolver contentResolver) throws IllegalStateException {
        return contentResolver.query(BrowserContract.Bookmarks.CONTENT_URI, new String[]{"url"}, "folder = 0", null, null);
    }

    public static final Cursor getAllVisitedUrls(ContentResolver contentResolver) throws IllegalStateException {
        return contentResolver.query(BrowserContract.Combined.CONTENT_URI, new String[]{"url"}, null, null, "created ASC");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String[] getVisitedHistory(ContentResolver contentResolver) {
        String[] stringArray;
        block12: {
            Cursor cursor = null;
            try {
                String[] stringArray2 = new String[]{"url"};
                cursor = contentResolver.query(BrowserContract.History.CONTENT_URI, stringArray2, "visits > 0", null, null);
                if (cursor == null) {
                    String[] stringArray3 = new String[]{};
                    return stringArray3;
                }
                stringArray = new String[cursor.getCount()];
                int n = 0;
                while (cursor.moveToNext()) {
                    stringArray[n] = cursor.getString(0);
                    ++n;
                }
                if (cursor == null) break block12;
            }
            catch (IllegalStateException illegalStateException) {
                Log.e(LOGTAG, "getVisitedHistory", illegalStateException);
                stringArray = new String[]{};
                return stringArray;
            }
            finally {
                if (cursor == null) return stringArray;
                cursor.close();
                return stringArray;
            }
            cursor.close();
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Cursor getVisitedLike(ContentResolver contentResolver, String string2) {
        StringBuilder stringBuilder;
        boolean bl = false;
        String string3 = string2;
        if (string3.startsWith("http://")) {
            string3 = string3.substring(7);
        } else {
            boolean bl2 = string3.startsWith("https://");
            bl = false;
            if (bl2) {
                string3 = string3.substring(8);
                bl = true;
            }
        }
        if (string3.startsWith("www.")) {
            string3 = string3.substring(4);
        }
        if (bl) {
            stringBuilder = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(stringBuilder, "https://" + string3);
            Browser.addOrUrlEquals(stringBuilder);
            DatabaseUtils.appendEscapedSQLString(stringBuilder, "https://www." + string3);
            return contentResolver.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, stringBuilder.toString(), null, null);
        } else {
            stringBuilder = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(stringBuilder, string3);
            Browser.addOrUrlEquals(stringBuilder);
            String string4 = "www." + string3;
            DatabaseUtils.appendEscapedSQLString(stringBuilder, string4);
            Browser.addOrUrlEquals(stringBuilder);
            DatabaseUtils.appendEscapedSQLString(stringBuilder, "http://" + string3);
            Browser.addOrUrlEquals(stringBuilder);
            DatabaseUtils.appendEscapedSQLString(stringBuilder, "http://" + string4);
        }
        return contentResolver.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, stringBuilder.toString(), null, null);
    }

    public static final void requestAllIcons(ContentResolver contentResolver, String string2, WebIconDatabase.IconListener iconListener) {
    }

    public static final void saveBookmark(Context context, String string2, String string3) {
        Intent intent = new Intent("android.intent.action.INSERT", BOOKMARKS_URI);
        intent.putExtra("title", string2);
        intent.putExtra("url", string3);
        context.startActivity(intent);
    }

    public static final void sendString(Context context, String string2) {
        Browser.sendString(context, string2, context.getString(17040532));
    }

    public static final void sendString(Context context, String string2, String string3) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", string2);
        try {
            Intent intent2 = Intent.createChooser(intent, string3);
            intent2.setFlags(0x10008000);
            context.startActivity(intent2);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void truncateHistory(ContentResolver contentResolver) {
        Cursor cursor;
        block6: {
            cursor = null;
            try {
                cursor = contentResolver.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "url", "date"}, null, null, "date ASC");
                if (!cursor.moveToFirst() || cursor.getCount() < 250) break block6;
            }
            catch (IllegalStateException illegalStateException) {
                Log.e(LOGTAG, "truncateHistory", illegalStateException);
                return;
            }
            for (int i = 0; i < 5; ++i) {
                contentResolver.delete(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, cursor.getLong(0)), null, null);
                boolean bl = cursor.moveToNext();
                if (!bl) break;
            }
        }
        if (cursor == null) return;
        cursor.close();
        return;
        finally {
            if (cursor == null) return;
            cursor.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void updateVisitedHistory(ContentResolver contentResolver, String string2, boolean bl) {
        long l = System.currentTimeMillis();
        Cursor cursor = null;
        try {
            cursor = Browser.getVisitedLike(contentResolver, string2);
            if (cursor.moveToFirst()) {
                ContentValues contentValues2 = new ContentValues();
                if (bl) {
                    contentValues2.put("visits", 1 + cursor.getInt(1));
                } else {
                    contentValues2.put("user_entered", 1);
                }
                contentValues2.put("date", l);
                contentResolver.update(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, cursor.getLong(0)), contentValues2, null, null);
            } else {
                int n;
                int n2;
                Browser.truncateHistory(contentResolver);
                ContentValues contentValues = new ContentValues();
                if (bl) {
                    n2 = 1;
                    n = 0;
                } else {
                    n = 1;
                    n2 = 0;
                }
                contentValues.put("url", string2);
                contentValues.put("visits", n2);
                contentValues.put("date", l);
                contentValues.put("title", string2);
                contentValues.put("created", 0);
                contentValues.put("user_entered", n);
                contentResolver.insert(BrowserContract.History.CONTENT_URI, contentValues);
            }
            if (cursor == null) return;
        }
        catch (IllegalStateException illegalStateException) {
            Log.e(LOGTAG, "updateVisitedHistory", illegalStateException);
            if (cursor == null) return;
            cursor.close();
            return;
        }
        catch (Throwable throwable) {
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
        return;
    }

    public static class BookmarkColumns
    implements BaseColumns {
        public static final String BOOKMARK = "bookmark";
        public static final String CREATED = "created";
        public static final String DATE = "date";
        public static final String FAVICON = "favicon";
        public static final String THUMBNAIL = "thumbnail";
        public static final String TITLE = "title";
        public static final String TOUCH_ICON = "touch_icon";
        public static final String URL = "url";
        public static final String USER_ENTERED = "user_entered";
        public static final String VISITS = "visits";
    }

    public static class SearchColumns
    implements BaseColumns {
        public static final String DATE = "date";
        public static final String SEARCH = "search";
        @Deprecated
        public static final String URL = "url";
    }
}

