/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramFragment
extends Program {
    ProgramFragment(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public static class Builder
    extends Program.BaseProgramBuilder {
        public Builder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramFragment create() {
            this.mRS.validate();
            long[] lArray = new long[2 * (this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount)];
            String[] stringArray = new String[this.mTextureCount];
            int n = 0;
            for (int i = 0; i < this.mInputCount; ++i) {
                int n2 = n + 1;
                lArray[n] = Program.ProgramParam.INPUT.mID;
                n = n2 + 1;
                lArray[n2] = this.mInputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mOutputCount; ++i) {
                int n3 = n + 1;
                lArray[n] = Program.ProgramParam.OUTPUT.mID;
                n = n3 + 1;
                lArray[n3] = this.mOutputs[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mConstantCount; ++i) {
                int n4 = n + 1;
                lArray[n] = Program.ProgramParam.CONSTANT.mID;
                n = n4 + 1;
                lArray[n4] = this.mConstants[i].getID(this.mRS);
            }
            for (int i = 0; i < this.mTextureCount; ++i) {
                int n5 = n + 1;
                lArray[n] = Program.ProgramParam.TEXTURE_TYPE.mID;
                n = n5 + 1;
                lArray[n5] = this.mTextureTypes[i].mID;
                stringArray[i] = this.mTextureNames[i];
            }
            ProgramFragment programFragment = new ProgramFragment(this.mRS.nProgramFragmentCreate(this.mShader, stringArray, lArray), this.mRS);
            this.initProgram(programFragment);
            return programFragment;
        }
    }
}

