/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.util.SparseArray;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    private final SparseArray<FieldID> mFIDs;
    private final SparseArray<KernelID> mKIDs = new SparseArray();

    Script(long l, RenderScript renderScript) {
        super(l, renderScript);
        this.mFIDs = new SparseArray();
    }

    public void bindAllocation(Allocation allocation, int n) {
        this.mRS.validate();
        this.mRS.validateObject(allocation);
        if (allocation != null) {
            Type type;
            if (this.mRS.getApplicationContext().getApplicationInfo().targetSdkVersion >= 20 && ((type = allocation.mType).hasMipmaps() || type.hasFaces() || type.getY() != 0 || type.getZ() != 0)) {
                throw new RSIllegalArgumentException("API 20+ only allows simple 1D allocations to be used with bind.");
            }
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), allocation.getID(this.mRS), n);
            return;
        }
        this.mRS.nScriptBindAllocation(this.getID(this.mRS), 0L, n);
    }

    protected FieldID createFieldID(int n, Element element) {
        FieldID fieldID = this.mFIDs.get(n);
        if (fieldID != null) {
            return fieldID;
        }
        long l = this.mRS.nScriptFieldIDCreate(this.getID(this.mRS), n);
        if (l == 0L) {
            throw new RSDriverException("Failed to create FieldID");
        }
        FieldID fieldID2 = new FieldID(l, this.mRS, this, n);
        this.mFIDs.put(n, fieldID2);
        return fieldID2;
    }

    protected KernelID createKernelID(int n, int n2, Element element, Element element2) {
        KernelID kernelID = this.mKIDs.get(n);
        if (kernelID != null) {
            return kernelID;
        }
        long l = this.mRS.nScriptKernelIDCreate(this.getID(this.mRS), n, n2);
        if (l == 0L) {
            throw new RSDriverException("Failed to create KernelID");
        }
        KernelID kernelID2 = new KernelID(l, this.mRS, this, n, n2);
        this.mKIDs.put(n, kernelID2);
        return kernelID2;
    }

    protected void forEach(int n, Allocation allocation, Allocation allocation2, FieldPacker fieldPacker) {
        this.mRS.validate();
        this.mRS.validateObject(allocation);
        this.mRS.validateObject(allocation2);
        if (allocation == null && allocation2 == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        long l = 0L;
        if (allocation != null) {
            l = allocation.getID(this.mRS);
        }
        long l2 = 0L;
        if (allocation2 != null) {
            l2 = allocation2.getID(this.mRS);
        }
        byte[] byArray = null;
        if (fieldPacker != null) {
            byArray = fieldPacker.getData();
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), n, l, l2, byArray);
    }

    protected void forEach(int n, Allocation allocation, Allocation allocation2, FieldPacker fieldPacker, LaunchOptions launchOptions) {
        this.mRS.validate();
        this.mRS.validateObject(allocation);
        this.mRS.validateObject(allocation2);
        if (allocation == null && allocation2 == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (launchOptions == null) {
            this.forEach(n, allocation, allocation2, fieldPacker);
            return;
        }
        long l = 0L;
        if (allocation != null) {
            l = allocation.getID(this.mRS);
        }
        long l2 = 0L;
        if (allocation2 != null) {
            l2 = allocation2.getID(this.mRS);
        }
        byte[] byArray = null;
        if (fieldPacker != null) {
            byArray = fieldPacker.getData();
        }
        this.mRS.nScriptForEachClipped(this.getID(this.mRS), n, l, l2, byArray, launchOptions.xstart, launchOptions.xend, launchOptions.ystart, launchOptions.yend, launchOptions.zstart, launchOptions.zend);
    }

    protected void forEach(int n, Allocation[] allocationArray, Allocation allocation, FieldPacker fieldPacker) {
        this.forEach(n, allocationArray, allocation, fieldPacker, new LaunchOptions());
    }

    protected void forEach(int n, Allocation[] allocationArray, Allocation allocation, FieldPacker fieldPacker, LaunchOptions launchOptions) {
        int n2;
        this.mRS.validate();
        int n3 = allocationArray.length;
        for (int i = 0; i < n3; ++i) {
            Allocation allocation2 = allocationArray[i];
            this.mRS.validateObject(allocation2);
        }
        this.mRS.validateObject(allocation);
        if (allocationArray == null && allocation == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (launchOptions == null) {
            this.forEach(n, allocationArray, allocation, fieldPacker);
            return;
        }
        long[] lArray = new long[allocationArray.length];
        for (int i = 0; i < (n2 = allocationArray.length); ++i) {
            lArray[i] = allocationArray[i].getID(this.mRS);
        }
        long l = 0L;
        if (allocation != null) {
            l = allocation.getID(this.mRS);
        }
        byte[] byArray = null;
        if (fieldPacker != null) {
            byArray = fieldPacker.getData();
        }
        this.mRS.nScriptForEachMultiClipped(this.getID(this.mRS), n, lArray, l, byArray, launchOptions.xstart, launchOptions.xend, launchOptions.ystart, launchOptions.yend, launchOptions.zstart, launchOptions.zend);
    }

    public boolean getVarB(int n) {
        return this.mRS.nScriptGetVarI(this.getID(this.mRS), n) > 0;
    }

    public double getVarD(int n) {
        return this.mRS.nScriptGetVarD(this.getID(this.mRS), n);
    }

    public float getVarF(int n) {
        return this.mRS.nScriptGetVarF(this.getID(this.mRS), n);
    }

    public int getVarI(int n) {
        return this.mRS.nScriptGetVarI(this.getID(this.mRS), n);
    }

    public long getVarJ(int n) {
        return this.mRS.nScriptGetVarJ(this.getID(this.mRS), n);
    }

    public void getVarV(int n, FieldPacker fieldPacker) {
        this.mRS.nScriptGetVarV(this.getID(this.mRS), n, fieldPacker.getData());
    }

    protected void invoke(int n) {
        this.mRS.nScriptInvoke(this.getID(this.mRS), n);
    }

    protected void invoke(int n, FieldPacker fieldPacker) {
        if (fieldPacker != null) {
            this.mRS.nScriptInvokeV(this.getID(this.mRS), n, fieldPacker.getData());
            return;
        }
        this.mRS.nScriptInvoke(this.getID(this.mRS), n);
    }

    public void setTimeZone(String string2) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(this.mRS), string2.getBytes("UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public void setVar(int n, double d) {
        this.mRS.nScriptSetVarD(this.getID(this.mRS), n, d);
    }

    public void setVar(int n, float f) {
        this.mRS.nScriptSetVarF(this.getID(this.mRS), n, f);
    }

    public void setVar(int n, int n2) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), n, n2);
    }

    public void setVar(int n, long l) {
        this.mRS.nScriptSetVarJ(this.getID(this.mRS), n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVar(int n, BaseObj baseObj) {
        this.mRS.validate();
        this.mRS.validateObject(baseObj);
        RenderScript renderScript = this.mRS;
        long l = this.getID(this.mRS);
        long l2 = baseObj == null ? 0L : baseObj.getID(this.mRS);
        renderScript.nScriptSetVarObj(l, n, l2);
    }

    public void setVar(int n, FieldPacker fieldPacker) {
        this.mRS.nScriptSetVarV(this.getID(this.mRS), n, fieldPacker.getData());
    }

    public void setVar(int n, FieldPacker fieldPacker, Element element, int[] nArray) {
        this.mRS.nScriptSetVarVE(this.getID(this.mRS), n, fieldPacker.getData(), element.getID(this.mRS), nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setVar(int n, boolean bl) {
        RenderScript renderScript = this.mRS;
        long l = this.getID(this.mRS);
        int n2 = bl ? 1 : 0;
        renderScript.nScriptSetVarI(l, n, n2);
    }

    public static class Builder {
        RenderScript mRS;

        Builder(RenderScript renderScript) {
            this.mRS = renderScript;
        }
    }

    public static class FieldBase {
        protected Allocation mAllocation;
        protected Element mElement;

        protected FieldBase() {
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        protected void init(RenderScript renderScript, int n) {
            this.mAllocation = Allocation.createSized(renderScript, this.mElement, n, 1);
        }

        protected void init(RenderScript renderScript, int n, int n2) {
            this.mAllocation = Allocation.createSized(renderScript, this.mElement, n, n2 | 1);
        }

        public void updateAllocation() {
        }
    }

    public static final class FieldID
    extends BaseObj {
        Script mScript;
        int mSlot;

        FieldID(long l, RenderScript renderScript, Script script, int n) {
            super(l, renderScript);
            this.mScript = script;
            this.mSlot = n;
        }
    }

    public static final class KernelID
    extends BaseObj {
        Script mScript;
        int mSig;
        int mSlot;

        KernelID(long l, RenderScript renderScript, Script script, int n, int n2) {
            super(l, renderScript);
            this.mScript = script;
            this.mSlot = n;
            this.mSig = n2;
        }
    }

    public static final class LaunchOptions {
        private int strategy;
        private int xend = 0;
        private int xstart = 0;
        private int yend = 0;
        private int ystart = 0;
        private int zend = 0;
        private int zstart = 0;

        public int getXEnd() {
            return this.xend;
        }

        public int getXStart() {
            return this.xstart;
        }

        public int getYEnd() {
            return this.yend;
        }

        public int getYStart() {
            return this.ystart;
        }

        public int getZEnd() {
            return this.zend;
        }

        public int getZStart() {
            return this.zstart;
        }

        public LaunchOptions setX(int n, int n2) {
            if (n < 0 || n2 <= n) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.xstart = n;
            this.xend = n2;
            return this;
        }

        public LaunchOptions setY(int n, int n2) {
            if (n < 0 || n2 <= n) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.ystart = n;
            this.yend = n2;
            return this;
        }

        public LaunchOptions setZ(int n, int n2) {
            if (n < 0 || n2 <= n) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.zstart = n;
            this.zend = n2;
            return this;
        }
    }
}

