/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RenderScript;

public class Type
extends BaseObj {
    boolean mDimFaces;
    boolean mDimMipmaps;
    int mDimX;
    int mDimY;
    int mDimYuv;
    int mDimZ;
    Element mElement;
    int mElementCount;

    Type(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    public static Type createX(RenderScript renderScript, Element element, int n) {
        if (n < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        Type type = new Type(renderScript.nTypeCreate(element.getID(renderScript), n, 0, 0, false, false, 0), renderScript);
        type.mElement = element;
        type.mDimX = n;
        type.calcElementCount();
        return type;
    }

    public static Type createXY(RenderScript renderScript, Element element, int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        Type type = new Type(renderScript.nTypeCreate(element.getID(renderScript), n, n2, 0, false, false, 0), renderScript);
        type.mElement = element;
        type.mDimX = n;
        type.mDimY = n2;
        type.calcElementCount();
        return type;
    }

    public static Type createXYZ(RenderScript renderScript, Element element, int n, int n2, int n3) {
        if (n < 1 || n2 < 1 || n3 < 1) {
            throw new RSInvalidStateException("Dimension must be >= 1.");
        }
        Type type = new Type(renderScript.nTypeCreate(element.getID(renderScript), n, n2, n3, false, false, 0), renderScript);
        type.mElement = element;
        type.mDimX = n;
        type.mDimY = n2;
        type.mDimZ = n3;
        type.calcElementCount();
        return type;
    }

    void calcElementCount() {
        boolean bl = this.hasMipmaps();
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getZ();
        int n4 = 1;
        if (this.hasFaces()) {
            n4 = 6;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = n4 * (n3 * (n * n2));
        while (bl && (n > 1 || n2 > 1 || n3 > 1)) {
            if (n > 1) {
                n >>= 1;
            }
            if (n2 > 1) {
                n2 >>= 1;
            }
            if (n3 > 1) {
                n3 >>= 1;
            }
            n5 += n4 * (n3 * (n * n2));
        }
        this.mElementCount = n5;
    }

    public int getCount() {
        return this.mElementCount;
    }

    public Element getElement() {
        return this.mElement;
    }

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getYuv() {
        return this.mDimYuv;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public boolean hasFaces() {
        return this.mDimFaces;
    }

    public boolean hasMipmaps() {
        return this.mDimMipmaps;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void updateFromNative() {
        int n = 1;
        long[] lArray = new long[6];
        this.mRS.nTypeGetNativeData(this.getID(this.mRS), lArray);
        this.mDimX = (int)lArray[0];
        this.mDimY = (int)lArray[n];
        this.mDimZ = (int)lArray[2];
        int n2 = lArray[3] == 1L ? n : 0;
        this.mDimMipmaps = n2;
        if (lArray[4] != 1L) {
            n = 0;
        }
        this.mDimFaces = n;
        long l = lArray[5];
        if (l != 0L) {
            this.mElement = new Element(l, this.mRS);
            this.mElement.updateFromNative();
        }
        this.calcElementCount();
    }

    public static class Builder {
        boolean mDimFaces;
        boolean mDimMipmaps;
        int mDimX = 1;
        int mDimY;
        int mDimZ;
        Element mElement;
        RenderScript mRS;
        int mYuv;

        public Builder(RenderScript renderScript, Element element) {
            element.checkValid();
            this.mRS = renderScript;
            this.mElement = element;
        }

        public Type create() {
            if (this.mDimZ > 0) {
                if (this.mDimX < 1 || this.mDimY < 1) {
                    throw new RSInvalidStateException("Both X and Y dimension required when Z is present.");
                }
                if (this.mDimFaces) {
                    throw new RSInvalidStateException("Cube maps not supported with 3D types.");
                }
            }
            if (this.mDimY > 0 && this.mDimX < 1) {
                throw new RSInvalidStateException("X dimension required when Y is present.");
            }
            if (this.mDimFaces && this.mDimY < 1) {
                throw new RSInvalidStateException("Cube maps require 2D Types.");
            }
            if (this.mYuv != 0 && (this.mDimZ != 0 || this.mDimFaces || this.mDimMipmaps)) {
                throw new RSInvalidStateException("YUV only supports basic 2D.");
            }
            Type type = new Type(this.mRS.nTypeCreate(this.mElement.getID(this.mRS), this.mDimX, this.mDimY, this.mDimZ, this.mDimMipmaps, this.mDimFaces, this.mYuv), this.mRS);
            type.mElement = this.mElement;
            type.mDimX = this.mDimX;
            type.mDimY = this.mDimY;
            type.mDimZ = this.mDimZ;
            type.mDimMipmaps = this.mDimMipmaps;
            type.mDimFaces = this.mDimFaces;
            type.mDimYuv = this.mYuv;
            type.calcElementCount();
            return type;
        }

        public Builder setFaces(boolean bl) {
            this.mDimFaces = bl;
            return this;
        }

        public Builder setMipmaps(boolean bl) {
            this.mDimMipmaps = bl;
            return this;
        }

        public Builder setX(int n) {
            if (n < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension X are not valid.");
            }
            this.mDimX = n;
            return this;
        }

        public Builder setY(int n) {
            if (n < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension Y are not valid.");
            }
            this.mDimY = n;
            return this;
        }

        public Builder setYuvFormat(int n) {
            switch (n) {
                default: {
                    throw new RSIllegalArgumentException("Only ImageFormat.NV21, .YV12, and .YUV_420_888 are supported..");
                }
                case 17: 
                case 35: 
                case 842094169: 
            }
            this.mYuv = n;
            return this;
        }

        public Builder setZ(int n) {
            if (n < 1) {
                throw new RSIllegalArgumentException("Values of less than 1 for Dimension Z are not valid.");
            }
            this.mDimZ = n;
            return this;
        }
    }

    public static final class CubemapFace
    extends Enum<CubemapFace> {
        private static final /* synthetic */ CubemapFace[] $VALUES;
        public static final /* enum */ CubemapFace NEGATIVE_X;
        public static final /* enum */ CubemapFace NEGATIVE_Y;
        public static final /* enum */ CubemapFace NEGATIVE_Z;
        public static final /* enum */ CubemapFace POSITIVE_X;
        public static final /* enum */ CubemapFace POSITIVE_Y;
        public static final /* enum */ CubemapFace POSITIVE_Z;
        @Deprecated
        public static final /* enum */ CubemapFace POSITVE_X;
        @Deprecated
        public static final /* enum */ CubemapFace POSITVE_Y;
        @Deprecated
        public static final /* enum */ CubemapFace POSITVE_Z;
        int mID;

        static {
            POSITIVE_X = new CubemapFace(0);
            NEGATIVE_X = new CubemapFace(1);
            POSITIVE_Y = new CubemapFace(2);
            NEGATIVE_Y = new CubemapFace(3);
            POSITIVE_Z = new CubemapFace(4);
            NEGATIVE_Z = new CubemapFace(5);
            POSITVE_X = new CubemapFace(0);
            POSITVE_Y = new CubemapFace(2);
            POSITVE_Z = new CubemapFace(4);
            CubemapFace[] cubemapFaceArray = new CubemapFace[]{POSITIVE_X, NEGATIVE_X, POSITIVE_Y, NEGATIVE_Y, POSITIVE_Z, NEGATIVE_Z, POSITVE_X, POSITVE_Y, POSITVE_Z};
            $VALUES = cubemapFaceArray;
        }

        private CubemapFace(int n2) {
            this.mID = n2;
        }

        public static CubemapFace valueOf(String string2) {
            return Enum.valueOf(CubemapFace.class, string2);
        }

        public static CubemapFace[] values() {
            return (CubemapFace[])$VALUES.clone();
        }
    }
}

