/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.util.Slog;

public final class Sandman {
    private static final ComponentName SOMNAMBULATOR_COMPONENT = new ComponentName("com.android.systemui", "com.android.systemui.Somnambulator");
    private static final String TAG = "Sandman";

    private Sandman() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isScreenSaverActivatedOnDock(Context context) {
        int n;
        if (context.getResources().getBoolean(17956949)) {
            n = 1;
            return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_activate_on_dock", n, -2) != 0;
        }
        n = 0;
        return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_activate_on_dock", n, -2) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isScreenSaverEnabled(Context context) {
        int n;
        if (context.getResources().getBoolean(17956948)) {
            n = 1;
            return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_enabled", n, -2) != 0;
        }
        n = 0;
        return Settings.Secure.getIntForUser(context.getContentResolver(), "screensaver_enabled", n, -2) != 0;
    }

    public static boolean shouldStartDockApp(Context context, Intent intent) {
        ComponentName componentName = intent.resolveActivity(context.getPackageManager());
        return componentName != null && !componentName.equals(SOMNAMBULATOR_COMPONENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startDream(Context context, boolean bl) {
        try {
            IDreamManager iDreamManager = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
            if (iDreamManager == null || iDreamManager.isDreaming()) return;
            if (bl) {
                Slog.i(TAG, "Activating dream while docked.");
                ((PowerManager)context.getSystemService("power")).wakeUp(SystemClock.uptimeMillis());
            } else {
                Slog.i(TAG, "Activating dream by user request.");
            }
            iDreamManager.dream();
            return;
        }
        catch (RemoteException remoteException) {
            Slog.e(TAG, "Could not start dream when docked.", remoteException);
        }
    }

    public static void startDreamByUserRequest(Context context) {
        Sandman.startDream(context, false);
    }

    public static void startDreamWhenDockedIfAppropriate(Context context) {
        if (!Sandman.isScreenSaverEnabled(context) || !Sandman.isScreenSaverActivatedOnDock(context)) {
            Slog.i(TAG, "Dreams currently disabled for docks.");
            return;
        }
        Sandman.startDream(context, true);
    }
}

