/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Log;
import android.util.TypedValue;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.R;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseSurfaceHolder;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class WallpaperService
extends Service {
    static final boolean DEBUG = false;
    private static final int DO_ATTACH = 10;
    private static final int DO_DETACH = 20;
    private static final int DO_SET_DESIRED_SIZE = 30;
    private static final int DO_SET_DISPLAY_PADDING = 40;
    private static final int MSG_TOUCH_EVENT = 10040;
    private static final int MSG_UPDATE_SURFACE = 10000;
    private static final int MSG_VISIBILITY_CHANGED = 10010;
    private static final int MSG_WALLPAPER_COMMAND = 10025;
    private static final int MSG_WALLPAPER_OFFSETS = 10020;
    private static final int MSG_WINDOW_MOVED = 10035;
    private static final int MSG_WINDOW_RESIZED = 10030;
    public static final String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static final String SERVICE_META_DATA = "android.service.wallpaper";
    static final String TAG = "WallpaperService";
    private final ArrayList<Engine> mActiveEngines = new ArrayList();

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.print("State of wallpaper ");
        printWriter.print(this);
        printWriter.println(":");
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            Engine engine = this.mActiveEngines.get(i);
            printWriter.print("  Engine ");
            printWriter.print(engine);
            printWriter.println(":");
            engine.dump("    ", fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    public abstract Engine onCreateEngine();

    @Override
    public void onDestroy() {
        super.onDestroy();
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            this.mActiveEngines.get(i).detach();
        }
        this.mActiveEngines.clear();
    }

    public class Engine {
        HandlerCaller mCaller;
        final Configuration mConfiguration;
        IWallpaperConnection mConnection;
        final Rect mContentInsets;
        boolean mCreated;
        int mCurHeight;
        int mCurWidth;
        int mCurWindowFlags = this.mWindowFlags;
        int mCurWindowPrivateFlags = this.mWindowPrivateFlags;
        boolean mDestroyed;
        final Rect mDispatchedContentInsets;
        final Rect mDispatchedOverscanInsets;
        final Rect mDispatchedStableInsets;
        boolean mDrawingAllowed;
        final Rect mFinalStableInsets;
        final Rect mFinalSystemInsets;
        boolean mFixedSizeAllowed;
        int mFormat;
        int mHeight;
        IWallpaperEngineWrapper mIWallpaperEngine;
        boolean mInitializing = true;
        InputChannel mInputChannel;
        WallpaperInputEventReceiver mInputEventReceiver;
        private boolean mIsCircularEmulator;
        boolean mIsCreating;
        private boolean mIsEmulator;
        final WindowManager.LayoutParams mLayout;
        final Object mLock;
        boolean mOffsetMessageEnqueued;
        boolean mOffsetsChanged;
        TypedValue mOutsetBottom;
        final Rect mOverscanInsets;
        MotionEvent mPendingMove;
        boolean mPendingSync;
        float mPendingXOffset;
        float mPendingXOffsetStep;
        float mPendingYOffset;
        float mPendingYOffsetStep;
        final BroadcastReceiver mReceiver;
        boolean mReportedVisible;
        boolean mScreenOn = true;
        IWindowSession mSession;
        final Rect mStableInsets;
        boolean mSurfaceCreated;
        final BaseSurfaceHolder mSurfaceHolder;
        int mType;
        boolean mVisible;
        final Rect mVisibleInsets = new Rect();
        private WallpaperConnectInfo mWallpaperConnectInfo = null;
        int mWidth;
        final Rect mWinFrame = new Rect();
        final BaseIWindow mWindow;
        int mWindowFlags = 16;
        private boolean mWindowIsRound;
        int mWindowPrivateFlags = 4;
        IBinder mWindowToken;

        public Engine() {
            this.mOverscanInsets = new Rect();
            this.mContentInsets = new Rect();
            this.mStableInsets = new Rect();
            this.mDispatchedOverscanInsets = new Rect();
            this.mDispatchedContentInsets = new Rect();
            this.mDispatchedStableInsets = new Rect();
            this.mFinalSystemInsets = new Rect();
            this.mFinalStableInsets = new Rect();
            this.mConfiguration = new Configuration();
            this.mLayout = new WindowManager.LayoutParams();
            this.mLock = new Object();
            this.mReceiver = new BroadcastReceiver(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onReceive(Context context, Intent intent) {
                    if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                        Engine.this.mScreenOn = true;
                        Engine.this.reportVisibility();
                        return;
                    } else {
                        if (!"android.intent.action.SCREEN_OFF".equals(intent.getAction())) return;
                        Engine.this.mScreenOn = false;
                        Engine.this.reportVisibility();
                        return;
                    }
                }
            };
            this.mSurfaceHolder = new BaseSurfaceHolder(){
                {
                    this.mRequestedFormat = 2;
                }

                @Override
                public boolean isCreating() {
                    return Engine.this.mIsCreating;
                }

                @Override
                public boolean onAllowLockCanvas() {
                    return Engine.this.mDrawingAllowed;
                }

                @Override
                public void onRelayoutContainer() {
                    Message message = Engine.this.mCaller.obtainMessage(10000);
                    Engine.this.mCaller.sendMessage(message);
                }

                @Override
                public void onUpdateSurface() {
                    Message message = Engine.this.mCaller.obtainMessage(10000);
                    Engine.this.mCaller.sendMessage(message);
                }

                @Override
                public void setFixedSize(int n, int n2) {
                    if (!Engine.this.mFixedSizeAllowed) {
                        throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
                    }
                    super.setFixedSize(n, n2);
                }

                @Override
                public void setKeepScreenOn(boolean bl) {
                    throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
                }
            };
            this.mWindow = new BaseIWindow(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void dispatchAppVisibility(boolean bl) {
                    if (!Engine.this.mIWallpaperEngine.mIsPreview) {
                        HandlerCaller handlerCaller = Engine.this.mCaller;
                        int n = bl ? 1 : 0;
                        Message message = handlerCaller.obtainMessageI(10010, n);
                        Engine.this.mCaller.sendMessage(message);
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
                    Object object = Engine.this.mLock;
                    synchronized (object) {
                        WallpaperCommand wallpaperCommand = new WallpaperCommand();
                        wallpaperCommand.action = string2;
                        wallpaperCommand.x = n;
                        wallpaperCommand.y = n2;
                        wallpaperCommand.z = n3;
                        wallpaperCommand.extras = bundle;
                        wallpaperCommand.sync = bl;
                        Message message = Engine.this.mCaller.obtainMessage(10025);
                        message.obj = wallpaperCommand;
                        Engine.this.mCaller.sendMessage(message);
                        return;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
                    Object object = Engine.this.mLock;
                    synchronized (object) {
                        Engine.this.mPendingXOffset = f;
                        Engine.this.mPendingYOffset = f2;
                        Engine.this.mPendingXOffsetStep = f3;
                        Engine.this.mPendingYOffsetStep = f4;
                        if (bl) {
                            Engine.this.mPendingSync = true;
                        }
                        if (!Engine.this.mOffsetMessageEnqueued) {
                            Engine.this.mOffsetMessageEnqueued = true;
                            Message message = Engine.this.mCaller.obtainMessage(10020);
                            Engine.this.mCaller.sendMessage(message);
                        }
                        return;
                    }
                }

                @Override
                public void moved(int n, int n2) {
                    Message message = Engine.this.mCaller.obtainMessageII(10035, n, n2);
                    Engine.this.mCaller.sendMessage(message);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void resized(Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, boolean bl, Configuration configuration) {
                    HandlerCaller handlerCaller = Engine.this.mCaller;
                    int n = bl ? 1 : 0;
                    Message message = handlerCaller.obtainMessageI(10030, n);
                    Engine.this.mCaller.sendMessage(message);
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void dispatchPointer(MotionEvent motionEvent) {
            if (!motionEvent.isTouchEvent()) {
                motionEvent.recycle();
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingMove = motionEvent.getAction() == 2 ? motionEvent : null;
            }
            Message message = this.mCaller.obtainMessageO(10040, motionEvent);
            this.mCaller.sendMessage(message);
        }

        /*
         * Enabled aggressive block sorting
         */
        void attach(IWallpaperEngineWrapper iWallpaperEngineWrapper) {
            block3: {
                block2: {
                    if (this.mDestroyed) break block2;
                    this.mIWallpaperEngine = iWallpaperEngineWrapper;
                    this.mCaller = iWallpaperEngineWrapper.mCaller;
                    this.mConnection = iWallpaperEngineWrapper.mConnection;
                    this.mWindowToken = iWallpaperEngineWrapper.mWindowToken;
                    this.mSurfaceHolder.setSizeFromLayout();
                    this.mInitializing = true;
                    this.mSession = WindowManagerGlobal.getWindowSession();
                    this.mWindow.setSession(this.mSession);
                    this.mScreenOn = ((PowerManager)WallpaperService.this.getSystemService("power")).isScreenOn();
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    WallpaperService.this.registerReceiver(this.mReceiver, intentFilter);
                    this.onCreate(this.mSurfaceHolder);
                    this.mInitializing = false;
                    this.mReportedVisible = false;
                    this.updateSurface(false, false, false);
                    if (this.isPreview()) break block3;
                }
                return;
            }
            this.mWallpaperConnectInfo = new WallpaperConnectInfo(this.mWindowToken);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void detach() {
            block11: {
                block10: {
                    if (this.mDestroyed) break block10;
                    this.mDestroyed = true;
                    if (this.mVisible) {
                        this.mVisible = false;
                        this.onVisibilityChanged(false);
                    }
                    this.reportSurfaceDestroyed();
                    this.onDestroy();
                    WallpaperService.this.unregisterReceiver(this.mReceiver);
                    if (this.mCreated) {
                        try {
                            if (this.mInputEventReceiver != null) {
                                this.mInputEventReceiver.dispose();
                                this.mInputEventReceiver = null;
                            }
                            this.mSession.remove(this.mWindow);
                        }
                        catch (RemoteException remoteException) {}
                        this.mSurfaceHolder.mSurface.release();
                        this.mCreated = false;
                        if (this.mInputChannel != null) {
                            this.mInputChannel.dispose();
                            this.mInputChannel = null;
                        }
                    }
                    if (this.mWallpaperConnectInfo != null) break block11;
                }
                return;
            }
            this.mWallpaperConnectInfo.unlinkDeathRecipient();
            this.mWallpaperConnectInfo = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        void doCommand(WallpaperCommand wallpaperCommand) {
            Bundle bundle = !this.mDestroyed ? this.onCommand(wallpaperCommand.action, wallpaperCommand.x, wallpaperCommand.y, wallpaperCommand.z, wallpaperCommand.extras, wallpaperCommand.sync) : null;
            if (!wallpaperCommand.sync) return;
            try {
                this.mSession.wallpaperCommandComplete(this.mWindow.asBinder(), bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void doDesiredSizeChanged(int n, int n2) {
            if (!this.mDestroyed) {
                this.mIWallpaperEngine.mReqWidth = n;
                this.mIWallpaperEngine.mReqHeight = n2;
                this.onDesiredSizeChanged(n, n2);
                this.doOffsetsChanged(true);
            }
        }

        void doDisplayPaddingChanged(Rect rect) {
            if (!this.mDestroyed && !this.mIWallpaperEngine.mDisplayPadding.equals(rect)) {
                this.mIWallpaperEngine.mDisplayPadding.set(rect);
                this.updateSurface(true, false, false);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void doOffsetsChanged(boolean bl) {
            if (this.mDestroyed) {
                return;
            }
            if (!bl) {
                if (!this.mOffsetsChanged) return;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            float f = this.mPendingXOffset;
            float f2 = this.mPendingYOffset;
            float f3 = this.mPendingXOffsetStep;
            float f4 = this.mPendingYOffsetStep;
            boolean bl2 = this.mPendingSync;
            this.mPendingSync = false;
            this.mOffsetMessageEnqueued = false;
            // MONITOREXIT : object
            if (this.mSurfaceCreated) {
                if (this.mReportedVisible) {
                    int n = this.mIWallpaperEngine.mReqWidth - this.mCurWidth;
                    int n2 = n > 0 ? -((int)(0.5f + f * (float)n)) : 0;
                    int n3 = this.mIWallpaperEngine.mReqHeight - this.mCurHeight;
                    int n4 = n3 > 0 ? -((int)(0.5f + f2 * (float)n3)) : 0;
                    this.onOffsetsChanged(f, f2, f3, f4, n2, n4);
                } else {
                    this.mOffsetsChanged = true;
                }
            }
            if (!bl2) return;
            try {
                this.mSession.wallpaperOffsetsComplete(this.mWindow.asBinder());
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void doVisibilityChanged(boolean bl) {
            if (!this.mDestroyed) {
                this.mVisible = bl;
                this.reportVisibility();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.print(string2);
            printWriter.print("mInitializing=");
            printWriter.print(this.mInitializing);
            printWriter.print(" mDestroyed=");
            printWriter.println(this.mDestroyed);
            printWriter.print(string2);
            printWriter.print("mVisible=");
            printWriter.print(this.mVisible);
            printWriter.print(" mScreenOn=");
            printWriter.print(this.mScreenOn);
            printWriter.print(" mReportedVisible=");
            printWriter.println(this.mReportedVisible);
            printWriter.print(string2);
            printWriter.print("mCreated=");
            printWriter.print(this.mCreated);
            printWriter.print(" mSurfaceCreated=");
            printWriter.print(this.mSurfaceCreated);
            printWriter.print(" mIsCreating=");
            printWriter.print(this.mIsCreating);
            printWriter.print(" mDrawingAllowed=");
            printWriter.println(this.mDrawingAllowed);
            printWriter.print(string2);
            printWriter.print("mWidth=");
            printWriter.print(this.mWidth);
            printWriter.print(" mCurWidth=");
            printWriter.print(this.mCurWidth);
            printWriter.print(" mHeight=");
            printWriter.print(this.mHeight);
            printWriter.print(" mCurHeight=");
            printWriter.println(this.mCurHeight);
            printWriter.print(string2);
            printWriter.print("mType=");
            printWriter.print(this.mType);
            printWriter.print(" mWindowFlags=");
            printWriter.print(this.mWindowFlags);
            printWriter.print(" mCurWindowFlags=");
            printWriter.println(this.mCurWindowFlags);
            printWriter.print(" mWindowPrivateFlags=");
            printWriter.print(this.mWindowPrivateFlags);
            printWriter.print(" mCurWindowPrivateFlags=");
            printWriter.println(this.mCurWindowPrivateFlags);
            printWriter.print(string2);
            printWriter.print("mVisibleInsets=");
            printWriter.print(this.mVisibleInsets.toShortString());
            printWriter.print(" mWinFrame=");
            printWriter.print(this.mWinFrame.toShortString());
            printWriter.print(" mContentInsets=");
            printWriter.println(this.mContentInsets.toShortString());
            printWriter.print(string2);
            printWriter.print("mConfiguration=");
            printWriter.println(this.mConfiguration);
            printWriter.print(string2);
            printWriter.print("mLayout=");
            printWriter.println(this.mLayout);
            Object object = this.mLock;
            synchronized (object) {
                printWriter.print(string2);
                printWriter.print("mPendingXOffset=");
                printWriter.print(this.mPendingXOffset);
                printWriter.print(" mPendingXOffset=");
                printWriter.println(this.mPendingXOffset);
                printWriter.print(string2);
                printWriter.print("mPendingXOffsetStep=");
                printWriter.print(this.mPendingXOffsetStep);
                printWriter.print(" mPendingXOffsetStep=");
                printWriter.println(this.mPendingXOffsetStep);
                printWriter.print(string2);
                printWriter.print("mOffsetMessageEnqueued=");
                printWriter.print(this.mOffsetMessageEnqueued);
                printWriter.print(" mPendingSync=");
                printWriter.println(this.mPendingSync);
                if (this.mPendingMove != null) {
                    printWriter.print(string2);
                    printWriter.print("mPendingMove=");
                    printWriter.println(this.mPendingMove);
                }
                return;
            }
        }

        public int getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        public int getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        public boolean isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        public boolean isVisible() {
            return this.mReportedVisible;
        }

        public void onApplyWindowInsets(WindowInsets windowInsets) {
        }

        public Bundle onCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            return null;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
        }

        public void onDesiredSizeChanged(int n, int n2) {
        }

        public void onDestroy() {
        }

        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
        }

        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        }

        public void onTouchEvent(MotionEvent motionEvent) {
        }

        public void onVisibilityChanged(boolean bl) {
        }

        void reportSurfaceDestroyed() {
            if (this.mSurfaceCreated) {
                this.mSurfaceCreated = false;
                this.mSurfaceHolder.ungetCallbacks();
                SurfaceHolder.Callback[] callbackArray = this.mSurfaceHolder.getCallbacks();
                if (callbackArray != null) {
                    int n = callbackArray.length;
                    for (int i = 0; i < n; ++i) {
                        callbackArray[i].surfaceDestroyed(this.mSurfaceHolder);
                    }
                }
                this.onSurfaceDestroyed(this.mSurfaceHolder);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void reportVisibility() {
            boolean bl;
            if (!this.mDestroyed && this.mReportedVisible != (bl = this.mVisible && this.mScreenOn)) {
                this.mReportedVisible = bl;
                if (bl) {
                    this.doOffsetsChanged(false);
                    this.updateSurface(false, false, false);
                }
                this.onVisibilityChanged(bl);
            }
        }

        public void setFixedSizeAllowed(boolean bl) {
            this.mFixedSizeAllowed = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setOffsetNotificationsEnabled(boolean bl) {
            int n = bl ? 4 | this.mWindowPrivateFlags : 0xFFFFFFFB & this.mWindowPrivateFlags;
            this.mWindowPrivateFlags = n;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setTouchEventsEnabled(boolean bl) {
            int n = bl ? 0xFFFFFFEF & this.mWindowFlags : 0x10 | this.mWindowFlags;
            this.mWindowFlags = n;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void updateSurface(boolean var1_1, boolean var2_2, boolean var3_3) {
            block35: {
                if (this.mDestroyed) {
                    Log.w("WallpaperService", "Ignoring updateSurface: destroyed");
                }
                var4_4 = false;
                var5_5 = this.mSurfaceHolder.getRequestedWidth();
                if (var5_5 <= 0) {
                    var5_5 = -1;
                } else {
                    var4_4 = true;
                }
                if ((var6_6 = this.mSurfaceHolder.getRequestedHeight()) <= 0) {
                    var6_6 = -1;
                } else {
                    var4_4 = true;
                }
                var7_7 = this.mCreated == false;
                var8_8 = this.mSurfaceCreated == false;
                var9_9 = this.mFormat != this.mSurfaceHolder.getRequestedFormat();
                var10_10 = this.mWidth != var5_5 || this.mHeight != var6_6;
                var11_11 = this.mCreated == false;
                var12_12 = this.mType != this.mSurfaceHolder.getRequestedType();
                var13_13 = this.mCurWindowFlags != this.mWindowFlags || this.mCurWindowPrivateFlags != this.mWindowPrivateFlags;
                if (!var1_1 && !var7_7 && !var8_8 && !var9_9 && !var10_10 && !var12_12 && !var13_13 && !var3_3 && this.mIWallpaperEngine.mShownReported) ** GOTO lbl-1000
                this.mWidth = var5_5;
                this.mHeight = var6_6;
                this.mFormat = this.mSurfaceHolder.getRequestedFormat();
                this.mType = this.mSurfaceHolder.getRequestedType();
                this.mLayout.x = 0;
                this.mLayout.y = 0;
                this.mLayout.width = var5_5;
                this.mLayout.height = var6_6;
                this.mLayout.format = this.mFormat;
                this.mCurWindowFlags = this.mWindowFlags;
                this.mLayout.flags = 8 | (256 | (512 | this.mWindowFlags));
                this.mCurWindowPrivateFlags = this.mWindowPrivateFlags;
                this.mLayout.privateFlags = this.mWindowPrivateFlags;
                this.mLayout.memoryType = this.mType;
                this.mLayout.token = this.mWindowToken;
                if (!this.mCreated) {
                    var53_14 = (WindowManager)WallpaperService.this.getSystemService("window");
                    var54_15 = WallpaperService.this.obtainStyledAttributes(R.styleable.Window);
                    var55_16 = var53_14.getDefaultDisplay().getDisplayId() == 0;
                    if (var55_16 && var54_15.hasValue(52)) {
                        if (this.mOutsetBottom == null) {
                            this.mOutsetBottom = new TypedValue();
                        }
                        var54_15.getValue(52, this.mOutsetBottom);
                    } else {
                        this.mOutsetBottom = null;
                    }
                    this.mWindowIsRound = WallpaperService.this.getResources().getBoolean(17956973);
                    var54_15.recycle();
                    this.mIsEmulator = Build.HARDWARE.contains("goldfish");
                    this.mIsCircularEmulator = SystemProperties.getBoolean("ro.emulator.circular", false);
                    this.mLayout.type = this.mIWallpaperEngine.mWindowType;
                    this.mLayout.gravity = 0x800033;
                    this.mLayout.setTitle(WallpaperService.this.getClass().getName());
                    this.mLayout.windowAnimations = 16974562;
                    this.mInputChannel = new InputChannel();
                    if (this.mSession.addToDisplay(this.mWindow, this.mWindow.mSeq, this.mLayout, 0, 0, this.mContentInsets, this.mInputChannel) < 0) {
                        Log.w("WallpaperService", "Failed to add window while updating wallpaper surface.");
                        return;
                    }
                    this.mCreated = true;
                    this.mInputEventReceiver = new WallpaperInputEventReceiver(this.mInputChannel, Looper.myLooper());
                }
                this.mSurfaceHolder.mSurfaceLock.lock();
                this.mDrawingAllowed = true;
                if (!var4_4) {
                    this.mLayout.surfaceInsets.set(this.mIWallpaperEngine.mDisplayPadding);
                } else {
                    this.mLayout.surfaceInsets.set(0, 0, 0, 0);
                }
                var15_17 = this.mSession.relayout(this.mWindow, this.mWindow.mSeq, this.mLayout, this.mWidth, this.mHeight, 0, 0, this.mWinFrame, this.mOverscanInsets, this.mContentInsets, this.mVisibleInsets, this.mStableInsets, this.mConfiguration, this.mSurfaceHolder.mSurface);
                var16_18 = this.mWinFrame.width();
                var17_19 = this.mWinFrame.height();
                if (!var4_4) {
                    var18_20 = this.mIWallpaperEngine.mDisplayPadding;
                    var16_18 += var18_20.left + var18_20.right;
                    var17_19 += var18_20.top + var18_20.bottom;
                    var19_21 = this.mOverscanInsets;
                    var19_21.left += var18_20.left;
                    var20_22 = this.mOverscanInsets;
                    var20_22.top += var18_20.top;
                    var21_23 = this.mOverscanInsets;
                    var21_23.right += var18_20.right;
                    var22_24 = this.mOverscanInsets;
                    var22_24.bottom += var18_20.bottom;
                    var23_25 = this.mContentInsets;
                    var23_25.left += var18_20.left;
                    var24_26 = this.mContentInsets;
                    var24_26.top += var18_20.top;
                    var25_27 = this.mContentInsets;
                    var25_27.right += var18_20.right;
                    var26_28 = this.mContentInsets;
                    var26_28.bottom += var18_20.bottom;
                    var27_29 = this.mStableInsets;
                    var27_29.left += var18_20.left;
                    var28_30 = this.mStableInsets;
                    var28_30.top += var18_20.top;
                    var29_31 = this.mStableInsets;
                    var29_31.right += var18_20.right;
                    var30_32 = this.mStableInsets;
                    var30_32.bottom += var18_20.bottom;
                }
                if (this.mCurWidth != var16_18) {
                    var10_10 = true;
                    this.mCurWidth = var16_18;
                }
                if (this.mCurHeight != var17_19) {
                    var10_10 = true;
                    this.mCurHeight = var17_19;
                }
                var31_33 = this.mDispatchedOverscanInsets.equals(this.mOverscanInsets) == false;
                var32_34 = var11_11 | var31_33;
                var33_35 = this.mDispatchedContentInsets.equals(this.mContentInsets) == false;
                var34_36 = var32_34 | var33_35;
                var35_37 = this.mDispatchedStableInsets.equals(this.mStableInsets) == false;
                var36_38 = var34_36 | var35_37;
                this.mSurfaceHolder.setSurfaceFrameSize(var16_18, var17_19);
                this.mSurfaceHolder.mSurfaceLock.unlock();
                if (this.mSurfaceHolder.mSurface.isValid()) break block35;
                this.reportSurfaceDestroyed();
                return;
            }
            this.mSurfaceHolder.ungetCallbacks();
            var38_39 = false;
            if (var8_8) {
                this.mIsCreating = true;
                var38_39 = true;
                this.onSurfaceCreated(this.mSurfaceHolder);
                var39_40 = this.mSurfaceHolder.getCallbacks();
                if (var39_40 != null) {
                    var40_41 = var39_40.length;
                    for (var41_42 = 0; var41_42 < var40_41; ++var41_42) {
                        var39_40[var41_42].surfaceCreated(this.mSurfaceHolder);
                    }
                }
            }
            ** GOTO lbl135
lbl-1000:
            // 1 sources

            {
                block38: {
                    block39: {
                        block37: {
                            block36: {
                                return;
lbl135:
                                // 1 sources

                                var42_43 = var7_7 != false || (var15_17 & 2) != 0;
                                var3_3 |= var42_43;
                                if (var2_2 || var7_7 || var8_8 || var9_9 || var10_10) {
                                    var38_39 = true;
                                    this.onSurfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                                    var43_44 = this.mSurfaceHolder.getCallbacks();
                                    if (var43_44 == null) break block36;
                                    var44_45 = var43_44.length;
                                    for (var45_46 = 0; var45_46 < var44_45; ++var45_46) {
                                        var43_44[var45_46].surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                                    }
                                }
                            }
                            if (!var36_38) break block38;
                            try {
                                this.mDispatchedOverscanInsets.set(this.mOverscanInsets);
                                this.mDispatchedContentInsets.set(this.mContentInsets);
                                this.mDispatchedStableInsets.set(this.mStableInsets);
                                if ((!this.mIsEmulator || !this.mIsCircularEmulator) && !this.mWindowIsRound) break block37;
                            }
                            catch (Throwable var37_54) {
                                this.mIsCreating = false;
                                this.mSurfaceCreated = true;
                                if (var3_3) {
                                    this.mSession.finishDrawing(this.mWindow);
                                }
                                this.mIWallpaperEngine.reportShown();
                                throw var37_54;
                            }
                            var46_47 = true;
                            break block39;
                        }
                        var46_47 = false;
                    }
                    this.mFinalSystemInsets.set(this.mDispatchedOverscanInsets);
                    this.mFinalStableInsets.set(this.mDispatchedStableInsets);
                    if (this.mOutsetBottom != null) {
                        var52_48 = WallpaperService.this.getResources().getDisplayMetrics();
                        this.mFinalSystemInsets.bottom = (int)this.mOutsetBottom.getDimension(var52_48) + this.mIWallpaperEngine.mDisplayPadding.bottom;
                    }
                    var47_49 = new WindowInsets(this.mFinalSystemInsets, null, this.mFinalStableInsets, var46_47);
                    this.onApplyWindowInsets(var47_49);
                }
                if (var3_3) {
                    this.onSurfaceRedrawNeeded(this.mSurfaceHolder);
                    var48_50 = this.mSurfaceHolder.getCallbacks();
                    if (var48_50 != null) {
                        for (SurfaceHolder.Callback var51_53 : var48_50) {
                            if (!(var51_53 instanceof SurfaceHolder.Callback2)) continue;
                            ((SurfaceHolder.Callback2)var51_53).surfaceRedrawNeeded(this.mSurfaceHolder);
                        }
                    }
                }
                if (var38_39 && !this.mReportedVisible) {
                    if (this.mIsCreating) {
                        this.onVisibilityChanged(true);
                    }
                    this.onVisibilityChanged(false);
                }
                ** try [egrp 4[TRYBLOCK] [36 : 1682->1757)] { 
lbl188:
                // 1 sources

                this.mIsCreating = false;
                this.mSurfaceCreated = true;
                if (var3_3) {
                    this.mSession.finishDrawing(this.mWindow);
                }
                this.mIWallpaperEngine.reportShown();
                return;
            }
lbl194:
            // 2 sources

            catch (RemoteException var14_55) {
                return;
            }
        }

        private class WallpaperConnectInfo
        implements IBinder.DeathRecipient {
            IBinder mBinder;

            WallpaperConnectInfo(IBinder iBinder) {
                this.mBinder = iBinder;
                try {
                    this.mBinder.linkToDeath(this, 0);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.binderDied();
                    return;
                }
            }

            @Override
            public void binderDied() {
                Log.w(WallpaperService.TAG, "Binder died");
                Engine.this.mIWallpaperEngine.destroy();
            }

            void unlinkDeathRecipient() {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        final class WallpaperInputEventReceiver
        extends InputEventReceiver {
            public WallpaperInputEventReceiver(InputChannel inputChannel, Looper looper) {
                super(inputChannel, looper);
            }

            @Override
            public void onInputEvent(InputEvent inputEvent) {
                boolean bl;
                block4: {
                    try {
                        boolean bl2 = inputEvent instanceof MotionEvent;
                        bl = false;
                        if (!bl2) break block4;
                    }
                    catch (Throwable throwable) {
                        this.finishInputEvent(inputEvent, false);
                        throw throwable;
                    }
                    int n = 2 & inputEvent.getSource();
                    bl = false;
                    if (n == 0) break block4;
                    MotionEvent motionEvent = MotionEvent.obtainNoHistory((MotionEvent)inputEvent);
                    Engine.this.dispatchPointer(motionEvent);
                    bl = true;
                }
                this.finishInputEvent(inputEvent, bl);
            }
        }
    }

    class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback {
        private final HandlerCaller mCaller;
        final IWallpaperConnection mConnection;
        final Rect mDisplayPadding = new Rect();
        Engine mEngine;
        final boolean mIsPreview;
        int mReqHeight;
        int mReqWidth;
        boolean mShownReported;
        final IBinder mWindowToken;
        final int mWindowType;

        IWallpaperEngineWrapper(WallpaperService wallpaperService2, IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3, Rect rect) {
            this.mCaller = new HandlerCaller(wallpaperService2, wallpaperService2.getMainLooper(), this, true);
            this.mConnection = iWallpaperConnection;
            this.mWindowToken = iBinder;
            this.mWindowType = n;
            this.mIsPreview = bl;
            this.mReqWidth = n2;
            this.mReqHeight = n3;
            this.mDisplayPadding.set(rect);
            Message message = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void destroy() {
            Message message = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void dispatchPointer(MotionEvent motionEvent) {
            if (this.mEngine != null) {
                this.mEngine.dispatchPointer(motionEvent);
                return;
            }
            motionEvent.recycle();
        }

        @Override
        public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle) {
            if (this.mEngine != null) {
                this.mEngine.mWindow.dispatchWallpaperCommand(string2, n, n2, n3, bundle, false);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void executeMessage(Message message) {
            Engine engine;
            switch (message.what) {
                default: {
                    Log.w(WallpaperService.TAG, "Unknown message type " + message.what);
                }
                case 10035: {
                    return;
                }
                case 10: {
                    try {
                        this.mConnection.attachEngine(this);
                        this.mEngine = engine = WallpaperService.this.onCreateEngine();
                        WallpaperService.this.mActiveEngines.add(engine);
                    }
                    catch (RemoteException remoteException) {
                        Log.w(WallpaperService.TAG, "Wallpaper host disappeared", remoteException);
                        return;
                    }
                }
                engine.attach(this);
                return;
                case 20: {
                    WallpaperService.this.mActiveEngines.remove(this.mEngine);
                    this.mEngine.detach();
                    return;
                }
                case 30: {
                    this.mEngine.doDesiredSizeChanged(message.arg1, message.arg2);
                    return;
                }
                case 40: {
                    this.mEngine.doDisplayPaddingChanged((Rect)message.obj);
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    return;
                }
                case 10010: {
                    Engine engine2 = this.mEngine;
                    boolean bl = message.arg1 != 0;
                    engine2.doVisibilityChanged(bl);
                    return;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged(true);
                    return;
                }
                case 10025: {
                    WallpaperCommand wallpaperCommand = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(wallpaperCommand);
                    return;
                }
                case 10030: {
                    boolean bl = message.arg1 != 0;
                    this.mEngine.updateSurface(true, false, bl);
                    this.mEngine.doOffsetsChanged(true);
                    return;
                }
                case 10040: 
            }
            MotionEvent motionEvent = (MotionEvent)message.obj;
            int n = motionEvent.getAction();
            boolean bl = false;
            if (n == 2) {
                Object object = this.mEngine.mLock;
                synchronized (object) {
                    if (this.mEngine.mPendingMove == motionEvent) {
                        this.mEngine.mPendingMove = null;
                    } else {
                        bl = true;
                    }
                }
            }
            if (!bl) {
                this.mEngine.onTouchEvent(motionEvent);
            }
            motionEvent.recycle();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void reportShown() {
            if (this.mShownReported) return;
            this.mShownReported = true;
            try {
                this.mConnection.engineShown(this);
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(WallpaperService.TAG, "Wallpaper host disappeared", remoteException);
                return;
            }
        }

        @Override
        public void setDesiredSize(int n, int n2) {
            Message message = this.mCaller.obtainMessageII(30, n, n2);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void setDisplayPadding(Rect rect) {
            Message message = this.mCaller.obtainMessageO(40, rect);
            this.mCaller.sendMessage(message);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setVisibility(boolean bl) {
            HandlerCaller handlerCaller = this.mCaller;
            int n = bl ? 1 : 0;
            Message message = handlerCaller.obtainMessageI(10010, n);
            this.mCaller.sendMessage(message);
        }
    }

    class IWallpaperServiceWrapper
    extends IWallpaperService.Stub {
        private final WallpaperService mTarget;

        public IWallpaperServiceWrapper(WallpaperService wallpaperService2) {
            this.mTarget = wallpaperService2;
        }

        @Override
        public void attach(IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3, Rect rect) {
            new IWallpaperEngineWrapper(this.mTarget, iWallpaperConnection, iBinder, n, bl, n2, n3, rect);
        }
    }

    static final class WallpaperCommand {
        String action;
        Bundle extras;
        boolean sync;
        int x;
        int y;
        int z;

        WallpaperCommand() {
        }
    }
}

