/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.ConditionVariable;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class AudioPlaybackQueueItem
extends PlaybackQueueItem {
    private static final String TAG = "TTS.AudioQueueItem";
    private final TextToSpeechService.AudioOutputParams mAudioParams;
    private final Context mContext;
    private final ConditionVariable mDone;
    private volatile boolean mFinished;
    private MediaPlayer mPlayer;
    private final Uri mUri;

    AudioPlaybackQueueItem(TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, Context context, Uri uri, TextToSpeechService.AudioOutputParams audioOutputParams) {
        super(utteranceProgressDispatcher, object);
        this.mContext = context;
        this.mUri = uri;
        this.mAudioParams = audioOutputParams;
        this.mDone = new ConditionVariable();
        this.mPlayer = null;
        this.mFinished = false;
    }

    static /* synthetic */ boolean access$102(AudioPlaybackQueueItem audioPlaybackQueueItem, boolean bl) {
        audioPlaybackQueueItem.mFinished = bl;
        return bl;
    }

    private static final float clip(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f < f3) {
            return f;
        }
        return f3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finish() {
        try {
            this.mPlayer.stop();
        }
        catch (IllegalStateException illegalStateException) {}
        this.mPlayer.release();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void setupVolume(MediaPlayer mediaPlayer, float f, float f2) {
        float f3 = AudioPlaybackQueueItem.clip(f, 0.0f, 1.0f);
        float f4 = AudioPlaybackQueueItem.clip(f2, -1.0f, 1.0f);
        float f5 = f3;
        float f6 = f3;
        if (f4 > 0.0f) {
            f5 *= 1.0f - f4;
        } else if (f4 < 0.0f) {
            f6 *= 1.0f + f4;
        }
        mediaPlayer.setVolume(f5, f6);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher = this.getDispatcher();
        utteranceProgressDispatcher.dispatchOnStart();
        int n = this.mAudioParams.mSessionId;
        Context context = this.mContext;
        Uri uri = this.mUri;
        AudioAttributes audioAttributes = this.mAudioParams.mAudioAttributes;
        if (n <= 0) {
            n = 0;
        }
        this.mPlayer = MediaPlayer.create(context, uri, null, audioAttributes, n);
        if (this.mPlayer == null) {
            utteranceProgressDispatcher.dispatchOnError(-5);
            return;
        }
        try {
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                @Override
                public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                    Log.w(AudioPlaybackQueueItem.TAG, "Audio playback error: " + n + ", " + n2);
                    AudioPlaybackQueueItem.this.mDone.open();
                    return true;
                }
            });
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                @Override
                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioPlaybackQueueItem.access$102(AudioPlaybackQueueItem.this, true);
                    AudioPlaybackQueueItem.this.mDone.open();
                }
            });
            AudioPlaybackQueueItem.setupVolume(this.mPlayer, this.mAudioParams.mVolume, this.mAudioParams.mPan);
            this.mPlayer.start();
            this.mDone.block();
            this.finish();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w(TAG, "MediaPlayer failed", illegalArgumentException);
            this.mDone.open();
        }
        if (this.mFinished) {
            utteranceProgressDispatcher.dispatchOnSuccess();
            return;
        }
        utteranceProgressDispatcher.dispatchOnStop();
    }

    @Override
    void stop(int n) {
        this.mDone.open();
    }
}

