/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Voice
implements Parcelable {
    public static final Parcelable.Creator<Voice> CREATOR = new Parcelable.Creator<Voice>(){

        @Override
        public Voice createFromParcel(Parcel parcel) {
            return new Voice(parcel);
        }

        public Voice[] newArray(int n) {
            return new Voice[n];
        }
    };
    public static final int LATENCY_HIGH = 400;
    public static final int LATENCY_LOW = 200;
    public static final int LATENCY_NORMAL = 300;
    public static final int LATENCY_VERY_HIGH = 500;
    public static final int LATENCY_VERY_LOW = 100;
    public static final int QUALITY_HIGH = 400;
    public static final int QUALITY_LOW = 200;
    public static final int QUALITY_NORMAL = 300;
    public static final int QUALITY_VERY_HIGH = 500;
    public static final int QUALITY_VERY_LOW = 100;
    private final Set<String> mFeatures;
    private final int mLatency;
    private final Locale mLocale;
    private final String mName;
    private final int mQuality;
    private final boolean mRequiresNetworkConnection;

    /*
     * Enabled aggressive block sorting
     */
    private Voice(Parcel parcel) {
        this.mName = parcel.readString();
        this.mLocale = (Locale)parcel.readSerializable();
        this.mQuality = parcel.readInt();
        this.mLatency = parcel.readInt();
        boolean bl = parcel.readByte() == 1;
        this.mRequiresNetworkConnection = bl;
        this.mFeatures = new HashSet<String>();
        Collections.addAll(this.mFeatures, parcel.readStringArray());
    }

    public Voice(String string2, Locale locale, int n, int n2, boolean bl, Set<String> set) {
        this.mName = string2;
        this.mLocale = locale;
        this.mQuality = n;
        this.mLatency = n2;
        this.mRequiresNetworkConnection = bl;
        this.mFeatures = set;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block11: {
            block10: {
                if (this == object) break block10;
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Voice voice = (Voice)object;
                if (this.mFeatures == null ? voice.mFeatures != null : !this.mFeatures.equals(voice.mFeatures)) {
                    return false;
                }
                if (this.mLatency != voice.mLatency) {
                    return false;
                }
                if (this.mLocale == null ? voice.mLocale != null : !this.mLocale.equals(voice.mLocale)) {
                    return false;
                }
                if (this.mName == null ? voice.mName != null : !this.mName.equals(voice.mName)) {
                    return false;
                }
                if (this.mQuality != voice.mQuality) {
                    return false;
                }
                if (this.mRequiresNetworkConnection != voice.mRequiresNetworkConnection) break block11;
            }
            return true;
        }
        return false;
    }

    public Set<String> getFeatures() {
        return this.mFeatures;
    }

    public int getLatency() {
        return this.mLatency;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public String getName() {
        return this.mName;
    }

    public int getQuality() {
        return this.mQuality;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        int n2 = this.mFeatures == null ? 0 : this.mFeatures.hashCode();
        int n3 = 31 * (31 * (n2 + 31) + this.mLatency);
        int n4 = this.mLocale == null ? 0 : this.mLocale.hashCode();
        int n5 = 31 * (n3 + n4);
        String string2 = this.mName;
        int n6 = 0;
        if (string2 != null) {
            n6 = this.mName.hashCode();
        }
        int n7 = 31 * (31 * (n5 + n6) + this.mQuality);
        if (this.mRequiresNetworkConnection) {
            n = 1231;
            return n7 + n;
        }
        n = 1237;
        return n7 + n;
    }

    public boolean isNetworkConnectionRequired() {
        return this.mRequiresNetworkConnection;
    }

    public String toString() {
        return new StringBuilder(64).append("Voice[Name: ").append(this.mName).append(", locale: ").append(this.mLocale).append(", quality: ").append(this.mQuality).append(", latency: ").append(this.mLatency).append(", requiresNetwork: ").append(this.mRequiresNetworkConnection).append(", features: ").append(this.mFeatures.toString()).append("]").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mName);
        parcel.writeSerializable(this.mLocale);
        parcel.writeInt(this.mQuality);
        parcel.writeInt(this.mLatency);
        boolean bl = this.mRequiresNetworkConnection;
        parcel.writeByte((byte)(bl ? 1 : 0));
        parcel.writeStringList(new ArrayList<String>(this.mFeatures));
    }
}

