/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

public final class DisconnectCause
implements Parcelable {
    public static final int BUSY = 7;
    public static final int CANCELED = 4;
    public static final Parcelable.Creator<DisconnectCause> CREATOR = new Parcelable.Creator<DisconnectCause>(){

        @Override
        public DisconnectCause createFromParcel(Parcel parcel) {
            return new DisconnectCause(parcel.readInt(), TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel), TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel), parcel.readString(), parcel.readInt());
        }

        public DisconnectCause[] newArray(int n) {
            return new DisconnectCause[n];
        }
    };
    public static final int ERROR = 1;
    public static final int LOCAL = 2;
    public static final int MISSED = 5;
    public static final int OTHER = 9;
    public static final int REJECTED = 6;
    public static final int REMOTE = 3;
    public static final int RESTRICTED = 8;
    public static final int UNKNOWN;
    private int mDisconnectCode;
    private CharSequence mDisconnectDescription;
    private CharSequence mDisconnectLabel;
    private String mDisconnectReason;
    private int mToneToPlay;

    public DisconnectCause(int n) {
        this(n, null, null, null, -1);
    }

    public DisconnectCause(int n, CharSequence charSequence, CharSequence charSequence2, String string2) {
        this(n, charSequence, charSequence2, string2, -1);
    }

    public DisconnectCause(int n, CharSequence charSequence, CharSequence charSequence2, String string2, int n2) {
        this.mDisconnectCode = n;
        this.mDisconnectLabel = charSequence;
        this.mDisconnectDescription = charSequence2;
        this.mDisconnectReason = string2;
        this.mToneToPlay = n2;
    }

    public DisconnectCause(int n, String string2) {
        this(n, null, null, string2, -1);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof DisconnectCause;
        boolean bl2 = false;
        if (bl) {
            DisconnectCause disconnectCause = (DisconnectCause)object;
            boolean bl3 = Objects.equals(this.mDisconnectCode, disconnectCause.getCode());
            bl2 = false;
            if (bl3) {
                boolean bl4 = Objects.equals(this.mDisconnectLabel, disconnectCause.getLabel());
                bl2 = false;
                if (bl4) {
                    boolean bl5 = Objects.equals(this.mDisconnectDescription, disconnectCause.getDescription());
                    bl2 = false;
                    if (bl5) {
                        boolean bl6 = Objects.equals(this.mDisconnectReason, disconnectCause.getReason());
                        bl2 = false;
                        if (bl6) {
                            boolean bl7 = Objects.equals(this.mToneToPlay, disconnectCause.getTone());
                            bl2 = false;
                            if (bl7) {
                                bl2 = true;
                            }
                        }
                    }
                }
            }
        }
        return bl2;
    }

    public int getCode() {
        return this.mDisconnectCode;
    }

    public CharSequence getDescription() {
        return this.mDisconnectDescription;
    }

    public CharSequence getLabel() {
        return this.mDisconnectLabel;
    }

    public String getReason() {
        return this.mDisconnectReason;
    }

    public int getTone() {
        return this.mToneToPlay;
    }

    public int hashCode() {
        return Objects.hashCode(this.mDisconnectCode) + Objects.hashCode(this.mDisconnectLabel) + Objects.hashCode(this.mDisconnectDescription) + Objects.hashCode(this.mDisconnectReason) + Objects.hashCode(this.mToneToPlay);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        String string3;
        switch (this.getCode()) {
            default: {
                string3 = "UNKNOWN";
                break;
            }
            case 1: {
                string3 = "ERROR";
                break;
            }
            case 2: {
                string3 = "LOCAL";
                break;
            }
            case 3: {
                string3 = "REMOTE";
                break;
            }
            case 5: {
                string3 = "MISSED";
                break;
            }
            case 6: {
                string3 = "REJECTED";
                break;
            }
            case 7: {
                string3 = "BUSY";
                break;
            }
            case 8: {
                string3 = "RESTRICTED";
                break;
            }
            case 9: {
                string3 = "OTHER";
            }
        }
        String string4 = this.mDisconnectLabel == null ? "" : this.mDisconnectLabel.toString();
        String string5 = this.mDisconnectDescription == null ? "" : this.mDisconnectDescription.toString();
        if (this.mDisconnectReason == null) {
            string2 = "";
            return "DisconnectCause [ Code: (" + string3 + ")" + " Label: (" + string4 + ")" + " Description: (" + string5 + ")" + " Reason: (" + string2 + ")" + " Tone: (" + this.mToneToPlay + ") ]";
        }
        string2 = this.mDisconnectReason;
        return "DisconnectCause [ Code: (" + string3 + ")" + " Label: (" + string4 + ")" + " Description: (" + string5 + ")" + " Reason: (" + string2 + ")" + " Tone: (" + this.mToneToPlay + ") ]";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mDisconnectCode);
        TextUtils.writeToParcel(this.mDisconnectLabel, parcel, n);
        TextUtils.writeToParcel(this.mDisconnectDescription, parcel, n);
        parcel.writeString(this.mDisconnectReason);
        parcel.writeInt(this.mToneToPlay);
    }
}

