/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.IllegalFormatException;
import java.util.Locale;

public final class Log {
    public static final boolean DEBUG = false;
    public static final boolean ERROR = false;
    public static final boolean FORCE_LOGGING = false;
    public static final boolean INFO = false;
    private static final String TAG = "TelecomFramework";
    public static final boolean VERBOSE;
    public static final boolean WARN;

    static {
        DEBUG = Log.isLoggable(3);
        INFO = Log.isLoggable(4);
        VERBOSE = Log.isLoggable(2);
        WARN = Log.isLoggable(5);
        ERROR = Log.isLoggable(6);
    }

    private Log() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildMessage(String string2, String string3, Object ... objectArray) {
        String string4;
        block5: {
            if (objectArray != null) {
                int n = objectArray.length;
                if (n != 0) break block5;
            }
            string4 = string3;
            return String.format(Locale.US, "%s: %s", string2, string4);
        }
        try {
            String string5;
            string4 = string5 = String.format(Locale.US, string3, objectArray);
            return String.format(Locale.US, "%s: %s", string2, string4);
        }
        catch (IllegalFormatException illegalFormatException) {
            Object[] objectArray2 = new Object[]{string3, objectArray.length};
            Log.wtf("Log", (Throwable)illegalFormatException, "IllegalFormatException: formatString='%s' numArgs=%d", objectArray2);
            string4 = string3 + " (An error occurred while formatting the message.)";
            return String.format(Locale.US, "%s: %s", string2, string4);
        }
    }

    public static void d(Object object, String string2, Object ... objectArray) {
        if (DEBUG) {
            android.util.Log.d(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray));
        }
    }

    public static void d(String string2, String string3, Object ... objectArray) {
        if (DEBUG) {
            android.util.Log.d(TAG, Log.buildMessage(string2, string3, objectArray));
        }
    }

    public static void e(Object object, Throwable throwable, String string2, Object ... objectArray) {
        if (ERROR) {
            android.util.Log.e(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray), throwable);
        }
    }

    public static void e(String string2, Throwable throwable, String string3, Object ... objectArray) {
        if (ERROR) {
            android.util.Log.e(TAG, Log.buildMessage(string2, string3, objectArray), throwable);
        }
    }

    private static String encodeHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0xFF & byArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n, 16));
        }
        return stringBuffer.toString();
    }

    private static String getPrefixFromObject(Object object) {
        if (object == null) {
            return "<null>";
        }
        return object.getClass().getSimpleName();
    }

    public static void i(Object object, String string2, Object ... objectArray) {
        if (INFO) {
            android.util.Log.i(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray));
        }
    }

    public static void i(String string2, String string3, Object ... objectArray) {
        if (INFO) {
            android.util.Log.i(TAG, Log.buildMessage(string2, string3, objectArray));
        }
    }

    public static boolean isLoggable(int n) {
        return android.util.Log.isLoggable(TAG, n);
    }

    public static String pii(Object object) {
        if (object == null || VERBOSE) {
            return String.valueOf(object);
        }
        return "[" + Log.secureHash(String.valueOf(object).getBytes()) + "]";
    }

    private static String secureHash(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return Log.encodeHex(messageDigest.digest());
    }

    public static void v(Object object, String string2, Object ... objectArray) {
        if (VERBOSE) {
            android.util.Log.v(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray));
        }
    }

    public static void v(String string2, String string3, Object ... objectArray) {
        if (VERBOSE) {
            android.util.Log.v(TAG, Log.buildMessage(string2, string3, objectArray));
        }
    }

    public static void w(Object object, String string2, Object ... objectArray) {
        if (WARN) {
            android.util.Log.w(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray));
        }
    }

    public static void w(String string2, String string3, Object ... objectArray) {
        if (WARN) {
            android.util.Log.w(TAG, Log.buildMessage(string2, string3, objectArray));
        }
    }

    public static void wtf(Object object, String string2, Object ... objectArray) {
        String string3 = Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray);
        android.util.Log.wtf(TAG, string3, new IllegalStateException(string3));
    }

    public static void wtf(Object object, Throwable throwable, String string2, Object ... objectArray) {
        android.util.Log.wtf(TAG, Log.buildMessage(Log.getPrefixFromObject(object), string2, objectArray), throwable);
    }

    public static void wtf(String string2, String string3, Object ... objectArray) {
        String string4 = Log.buildMessage(string2, string3, objectArray);
        android.util.Log.wtf(TAG, string4, new IllegalStateException(string4));
    }

    public static void wtf(String string2, Throwable throwable, String string3, Object ... objectArray) {
        android.util.Log.wtf(TAG, Log.buildMessage(string2, string3, objectArray), throwable);
    }
}

