/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;

public final class CellIdentityCdma
implements Parcelable {
    public static final Parcelable.Creator<CellIdentityCdma> CREATOR = new Parcelable.Creator<CellIdentityCdma>(){

        @Override
        public CellIdentityCdma createFromParcel(Parcel parcel) {
            return new CellIdentityCdma(parcel);
        }

        public CellIdentityCdma[] newArray(int n) {
            return new CellIdentityCdma[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "CellSignalStrengthCdma";
    private final int mBasestationId;
    private final int mLatitude;
    private final int mLongitude;
    private final int mNetworkId;
    private final int mSystemId;

    public CellIdentityCdma() {
        this.mNetworkId = Integer.MAX_VALUE;
        this.mSystemId = Integer.MAX_VALUE;
        this.mBasestationId = Integer.MAX_VALUE;
        this.mLongitude = Integer.MAX_VALUE;
        this.mLatitude = Integer.MAX_VALUE;
    }

    public CellIdentityCdma(int n, int n2, int n3, int n4, int n5) {
        this.mNetworkId = n;
        this.mSystemId = n2;
        this.mBasestationId = n3;
        this.mLongitude = n4;
        this.mLatitude = n5;
    }

    private CellIdentityCdma(Parcel parcel) {
        this.mNetworkId = parcel.readInt();
        this.mSystemId = parcel.readInt();
        this.mBasestationId = parcel.readInt();
        this.mLongitude = parcel.readInt();
        this.mLatitude = parcel.readInt();
    }

    private CellIdentityCdma(CellIdentityCdma cellIdentityCdma) {
        this.mNetworkId = cellIdentityCdma.mNetworkId;
        this.mSystemId = cellIdentityCdma.mSystemId;
        this.mBasestationId = cellIdentityCdma.mBasestationId;
        this.mLongitude = cellIdentityCdma.mLongitude;
        this.mLatitude = cellIdentityCdma.mLatitude;
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    CellIdentityCdma copy() {
        return new CellIdentityCdma(this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        CellIdentityCdma cellIdentityCdma;
        boolean bl2 = super.equals(object);
        boolean bl = false;
        if (!bl2) return bl;
        try {
            cellIdentityCdma = (CellIdentityCdma)object;
            int n = this.mNetworkId;
            int n2 = cellIdentityCdma.mNetworkId;
            bl = false;
            if (n != n2) return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n3 = this.mSystemId;
        int n4 = cellIdentityCdma.mSystemId;
        bl = false;
        if (n3 != n4) return bl;
        int n5 = this.mBasestationId;
        int n6 = cellIdentityCdma.mBasestationId;
        bl = false;
        if (n5 != n6) return bl;
        int n7 = this.mLatitude;
        int n8 = cellIdentityCdma.mLatitude;
        bl = false;
        if (n7 != n8) return bl;
        int n9 = this.mLongitude;
        int n10 = cellIdentityCdma.mLongitude;
        bl = false;
        if (n9 != n10) return bl;
        return true;
    }

    public int getBasestationId() {
        return this.mBasestationId;
    }

    public int getLatitude() {
        return this.mLatitude;
    }

    public int getLongitude() {
        return this.mLongitude;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public int getSystemId() {
        return this.mSystemId;
    }

    public int hashCode() {
        return 31 * this.mNetworkId + 31 * this.mSystemId + 31 * this.mBasestationId + 31 * this.mLatitude + 31 * this.mLongitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CellIdentityCdma:{");
        stringBuilder.append(" mNetworkId=");
        stringBuilder.append(this.mNetworkId);
        stringBuilder.append(" mSystemId=");
        stringBuilder.append(this.mSystemId);
        stringBuilder.append(" mBasestationId=");
        stringBuilder.append(this.mBasestationId);
        stringBuilder.append(" mLongitude=");
        stringBuilder.append(this.mLongitude);
        stringBuilder.append(" mLatitude=");
        stringBuilder.append(this.mLatitude);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mNetworkId);
        parcel.writeInt(this.mSystemId);
        parcel.writeInt(this.mBasestationId);
        parcel.writeInt(this.mLongitude);
        parcel.writeInt(this.mLatitude);
    }
}

