/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;

public final class CellIdentityGsm
implements Parcelable {
    public static final Parcelable.Creator<CellIdentityGsm> CREATOR = new Parcelable.Creator<CellIdentityGsm>(){

        @Override
        public CellIdentityGsm createFromParcel(Parcel parcel) {
            return new CellIdentityGsm(parcel);
        }

        public CellIdentityGsm[] newArray(int n) {
            return new CellIdentityGsm[n];
        }
    };
    private static final boolean DBG = false;
    private static final String LOG_TAG = "CellIdentityGsm";
    private final int mCid;
    private final int mLac;
    private final int mMcc;
    private final int mMnc;

    public CellIdentityGsm() {
        this.mMcc = Integer.MAX_VALUE;
        this.mMnc = Integer.MAX_VALUE;
        this.mLac = Integer.MAX_VALUE;
        this.mCid = Integer.MAX_VALUE;
    }

    public CellIdentityGsm(int n, int n2, int n3, int n4) {
        this.mMcc = n;
        this.mMnc = n2;
        this.mLac = n3;
        this.mCid = n4;
    }

    private CellIdentityGsm(Parcel parcel) {
        this.mMcc = parcel.readInt();
        this.mMnc = parcel.readInt();
        this.mLac = parcel.readInt();
        this.mCid = parcel.readInt();
    }

    private CellIdentityGsm(CellIdentityGsm cellIdentityGsm) {
        this.mMcc = cellIdentityGsm.mMcc;
        this.mMnc = cellIdentityGsm.mMnc;
        this.mLac = cellIdentityGsm.mLac;
        this.mCid = cellIdentityGsm.mCid;
    }

    private static void log(String string2) {
        Rlog.w(LOG_TAG, string2);
    }

    CellIdentityGsm copy() {
        return new CellIdentityGsm(this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        CellIdentityGsm cellIdentityGsm;
        boolean bl2 = super.equals(object);
        boolean bl = false;
        if (!bl2) return bl;
        try {
            cellIdentityGsm = (CellIdentityGsm)object;
            int n = this.mMcc;
            int n2 = cellIdentityGsm.mMcc;
            bl = false;
            if (n != n2) return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n3 = this.mMnc;
        int n4 = cellIdentityGsm.mMnc;
        bl = false;
        if (n3 != n4) return bl;
        int n5 = this.mLac;
        int n6 = cellIdentityGsm.mLac;
        bl = false;
        if (n5 != n6) return bl;
        int n7 = this.mCid;
        int n8 = cellIdentityGsm.mCid;
        bl = false;
        if (n7 != n8) return bl;
        return true;
    }

    public int getCid() {
        return this.mCid;
    }

    public int getLac() {
        return this.mLac;
    }

    public int getMcc() {
        return this.mMcc;
    }

    public int getMnc() {
        return this.mMnc;
    }

    @Deprecated
    public int getPsc() {
        return Integer.MAX_VALUE;
    }

    public int hashCode() {
        return 31 * this.mMcc + 31 * this.mMnc + 31 * this.mLac + 31 * this.mCid;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CellIdentityGsm:{");
        stringBuilder.append(" mMcc=").append(this.mMcc);
        stringBuilder.append(" mMnc=").append(this.mMnc);
        stringBuilder.append(" mLac=").append(this.mLac);
        stringBuilder.append(" mCid=").append(this.mCid);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mMcc);
        parcel.writeInt(this.mMnc);
        parcel.writeInt(this.mLac);
        parcel.writeInt(this.mCid);
    }
}

