/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ParagraphStyle;
import android.util.FloatMath;

public class BoringLayout
extends Layout
implements TextUtils.EllipsizeCallback {
    private static final char FIRST_RIGHT_TO_LEFT = '\u0590';
    private static final TextPaint sTemp = new TextPaint();
    int mBottom;
    private int mBottomPadding;
    int mDesc;
    private String mDirect;
    private int mEllipsizedCount;
    private int mEllipsizedStart;
    private int mEllipsizedWidth;
    private float mMax;
    private Paint mPaint;
    private int mTopPadding;

    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        super(charSequence, textPaint, n, alignment, f, f2);
        this.mEllipsizedWidth = n;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(charSequence, textPaint, n, alignment, f, f2, metrics, bl, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public BoringLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        super(charSequence, textPaint, n, alignment, f, f2);
        boolean bl2;
        if (truncateAt == null || truncateAt == TextUtils.TruncateAt.MARQUEE) {
            this.mEllipsizedWidth = n;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            bl2 = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(charSequence, textPaint, n2, truncateAt, true, this), textPaint, n, alignment, f, f2);
            this.mEllipsizedWidth = n2;
            bl2 = false;
        }
        this.init(this.getText(), textPaint, n, alignment, f, f2, metrics, bl, bl2);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint) {
        return BoringLayout.isBoring(charSequence, textPaint, TextDirectionHeuristics.FIRSTSTRONG_LTR, null);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint, Metrics metrics) {
        return BoringLayout.isBoring(charSequence, textPaint, TextDirectionHeuristics.FIRSTSTRONG_LTR, metrics);
    }

    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic) {
        return BoringLayout.isBoring(charSequence, textPaint, textDirectionHeuristic, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Metrics isBoring(CharSequence charSequence, TextPaint textPaint, TextDirectionHeuristic textDirectionHeuristic, Metrics metrics) {
        int n;
        char[] cArray = TextUtils.obtain(500);
        int n2 = charSequence.length();
        boolean bl = true;
        block0: for (int i = 0; i < n2; i += 500) {
            int n3 = 500 + i;
            if (n3 > n2) {
                n3 = n2;
            }
            TextUtils.getChars(charSequence, i, n3, cArray, 0);
            int n4 = n3 - i;
            for (int j = 0; j < n4; ++j) {
                char c = cArray[j];
                if (c != '\n' && c != '\t' && c < '\u0590') continue;
                bl = false;
                break block0;
            }
            if (textDirectionHeuristic == null || !textDirectionHeuristic.isRtl(cArray, 0, n4)) continue;
            bl = false;
            break;
        }
        TextUtils.recycle(cArray);
        if (bl && charSequence instanceof Spanned && ((Spanned)charSequence).getSpans(0, n2, ParagraphStyle.class).length > 0) {
            return null;
        }
        if (!bl) {
            return null;
        }
        Metrics metrics2 = metrics;
        if (metrics2 == null) {
            metrics2 = new Metrics();
        }
        textPaint.set(textPaint);
        TextLine textLine = TextLine.obtain();
        textLine.set(textPaint, charSequence, 0, n2, 1, Layout.DIRS_ALL_LEFT_TO_RIGHT, false, null);
        metrics2.width = n = (int)FloatMath.ceil(textLine.metrics(metrics2));
        TextLine.recycle(textLine);
        return metrics2;
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        return new BoringLayout(charSequence, textPaint, n, alignment, f, f2, metrics, bl);
    }

    public static BoringLayout make(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        return new BoringLayout(charSequence, textPaint, n, alignment, f, f2, metrics, bl, truncateAt, n2);
    }

    @Override
    public void draw(Canvas canvas, Path path, Paint paint, int n) {
        if (this.mDirect != null && path == null) {
            canvas.drawText(this.mDirect, 0.0f, this.mBottom - this.mDesc, this.mPaint);
            return;
        }
        super.draw(canvas, path, paint, n);
    }

    @Override
    public void ellipsized(int n, int n2) {
        this.mEllipsizedStart = n;
        this.mEllipsizedCount = n2 - n;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getEllipsisCount(int n) {
        return this.mEllipsizedCount;
    }

    @Override
    public int getEllipsisStart(int n) {
        return this.mEllipsizedStart;
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getHeight() {
        return this.mBottom;
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return false;
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public int getLineDescent(int n) {
        return this.mDesc;
    }

    @Override
    public final Layout.Directions getLineDirections(int n) {
        return Layout.DIRS_ALL_LEFT_TO_RIGHT;
    }

    @Override
    public float getLineMax(int n) {
        return this.mMax;
    }

    @Override
    public int getLineStart(int n) {
        if (n == 0) {
            return 0;
        }
        return this.getText().length();
    }

    @Override
    public int getLineTop(int n) {
        if (n == 0) {
            return 0;
        }
        return this.mBottom;
    }

    @Override
    public int getParagraphDirection(int n) {
        return 1;
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    /*
     * Enabled aggressive block sorting
     */
    void init(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, boolean bl2) {
        this.mDirect = charSequence instanceof String && alignment == Layout.Alignment.ALIGN_NORMAL ? charSequence.toString() : null;
        this.mPaint = textPaint;
        int n2 = bl ? metrics.bottom - metrics.top : metrics.descent - metrics.ascent;
        this.mBottom = n2;
        this.mDesc = bl ? n2 + metrics.top : n2 + metrics.ascent;
        if (bl2) {
            this.mMax = metrics.width;
        } else {
            TextLine textLine = TextLine.obtain();
            textLine.set(textPaint, charSequence, 0, charSequence.length(), 1, Layout.DIRS_ALL_LEFT_TO_RIGHT, false, null);
            this.mMax = (int)FloatMath.ceil(textLine.metrics(null));
            TextLine.recycle(textLine);
        }
        if (bl) {
            this.mTopPadding = metrics.top - metrics.ascent;
            this.mBottomPadding = metrics.bottom - metrics.descent;
        }
    }

    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl) {
        this.replaceWith(charSequence, textPaint, n, alignment, f, f2);
        this.mEllipsizedWidth = n;
        this.mEllipsizedStart = 0;
        this.mEllipsizedCount = 0;
        this.init(charSequence, textPaint, n, alignment, f, f2, metrics, bl, true);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BoringLayout replaceOrMake(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, Metrics metrics, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        boolean bl2;
        if (truncateAt == null || truncateAt == TextUtils.TruncateAt.MARQUEE) {
            this.replaceWith(charSequence, textPaint, n, alignment, f, f2);
            this.mEllipsizedWidth = n;
            this.mEllipsizedStart = 0;
            this.mEllipsizedCount = 0;
            bl2 = true;
        } else {
            this.replaceWith(TextUtils.ellipsize(charSequence, textPaint, n2, truncateAt, true, this), textPaint, n, alignment, f, f2);
            this.mEllipsizedWidth = n2;
            bl2 = false;
        }
        this.init(this.getText(), textPaint, n, alignment, f, f2, metrics, bl, bl2);
        return this;
    }

    public static class Metrics
    extends Paint.FontMetricsInt {
        public int width;

        @Override
        public String toString() {
            return super.toString() + " width=" + this.width;
        }
    }
}

