/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.BaseKeyListener;
import android.view.KeyEvent;
import android.view.View;

public abstract class NumberKeyListener
extends BaseKeyListener
implements InputFilter {
    protected static boolean ok(char[] cArray, char c) {
        for (int i = -1 + cArray.length; i >= 0; --i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        char[] cArray = this.getAcceptedChars();
        int n5 = n;
        while (true) {
            if (n5 >= n2 || !NumberKeyListener.ok(cArray, charSequence.charAt(n5))) {
                if (n5 != n2) break;
                return null;
            }
            ++n5;
        }
        if (n2 - n == 1) {
            return "";
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
        int n6 = n5 - n;
        int n7 = n2 - n;
        int cfr_ignored_0 = n7 - n;
        int n8 = n7 - 1;
        while (n8 >= n6) {
            if (!NumberKeyListener.ok(cArray, charSequence.charAt(n8))) {
                spannableStringBuilder.delete(n8, n8 + 1);
            }
            --n8;
        }
        return spannableStringBuilder;
    }

    protected abstract char[] getAcceptedChars();

    protected int lookup(KeyEvent keyEvent, Spannable spannable) {
        return keyEvent.getMatch(this.getAcceptedChars(), NumberKeyListener.getMetaState((CharSequence)spannable, keyEvent));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        int n2 = Selection.getSelectionStart(editable);
        int n3 = Selection.getSelectionEnd(editable);
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (n4 < 0 || n5 < 0) {
            n5 = 0;
            n4 = 0;
            Selection.setSelection(editable, 0);
        }
        int n6 = keyEvent != null ? this.lookup(keyEvent, editable) : 0;
        int n7 = 0;
        if (keyEvent != null) {
            n7 = keyEvent.getRepeatCount();
        }
        if (n7 == 0) {
            if (n6 != 0) {
                if (n4 != n5) {
                    Selection.setSelection(editable, n5);
                }
                editable.replace(n4, n5, String.valueOf((char)n6));
                NumberKeyListener.adjustMetaAfterKeypress(editable);
                return true;
            }
        } else if (n6 == 48 && n7 == 1 && n4 == n5 && n5 > 0 && editable.charAt(n4 - 1) == '0') {
            editable.replace(n4 - 1, n5, String.valueOf('+'));
            NumberKeyListener.adjustMetaAfterKeypress(editable);
            return true;
        }
        NumberKeyListener.adjustMetaAfterKeypress(editable);
        return super.onKeyDown(view, editable, n, keyEvent);
    }
}

